/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.tools.AbstractNativeToolExecutor;
import com.datical.liquibase.ext.tools.PsqlRunner;
import java.util.List;
import liquibase.Scope;
import liquibase.exception.DatabaseException;
import liquibase.logging.Logger;
import liquibase.sql.Sql;
import liquibase.sql.visitor.SqlVisitor;
import liquibase.sqlgenerator.SqlGeneratorFactory;
import liquibase.statement.SqlStatement;

public class PsqlExecutor
extends AbstractNativeToolExecutor {
    public PsqlExecutor() {
        super("psql");
    }

    public String getName() {
        return "psql";
    }

    public int getPriority() {
        return 101;
    }

    public void execute(SqlStatement action, List<SqlVisitor> sqlVisitors) throws DatabaseException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.info("Executing with the '" + this.getName() + "' executor");
        Sql[] sqlList = SqlGeneratorFactory.getInstance().generateSql(action, this.database);
        try {
            PsqlRunner runner = new PsqlRunner(this.changeSet, null);
            runner.executeCommand(this.database);
            log.info("Successfully validated psql");
            runner = new PsqlRunner(this.changeSet, sqlList);
            runner.executeCommand(this.database);
            String successMessage = String.format("Success! Changeset '%s' by '%s' deployed by psql", this.changeSet.getId(), this.changeSet.getAuthor());
            log.info(successMessage);
        }
        catch (Exception e) {
            String errorMessage = String.format("%nChangeset '%s' by '%s' failed to deploy with 'psql'. Please check psql logs or use the --log-level flag for more information.", this.changeSet.getId(), this.changeSet.getAuthor());
            log.warning(errorMessage);
            throw new DatabaseException((Throwable)e);
        }
    }
}

