/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.config.SqlcmdConfiguration;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import com.datical.liquibase.ext.util.ResourceUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.TimeoutException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.change.core.ExecuteShellCommandChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.MSSQLDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.logging.Logger;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.util.FileUtil;
import liquibase.util.FilenameUtil;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlcmdRunner
extends NativeExecutorRunner {
    private File outFile = null;
    private Boolean keepTempFile = false;
    private Boolean tempOverwrite = true;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private String logFile;
    private String catalogName;
    private Integer timeout;
    private File sqlcmdExec;
    private static final String EXECUTABLE_NAME = "sqlcmd";

    public SqlcmdRunner(ChangeSet changeSet, Sql[] sqlStrings) {
        super(sqlStrings);
        this.changeSet = changeSet;
        this.setTimeout("1800");
    }

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    protected List<String> createFinalCommandArray(Database database) {
        this.loadSqlcmdProperties();
        List commandArray = super.createFinalCommandArray(database);
        String useCatalogName = this.getCatalogName() != null ? this.getCatalogName() : database.getDefaultCatalogName();
        try {
            if (useCatalogName != null && !((MSSQLDatabase)database).isAzureDb()) {
                this.writeSql(useCatalogName);
            } else {
                this.writeSql(null);
            }
        }
        catch (Exception ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = (Boolean)SqlcmdConfiguration.TEMP_KEEP.getCurrentValue();
        }
        commandArray.add("-S");
        commandArray.add(this.getDatabaseHostname(database));
        String userName = "";
        String password = "";
        DatabaseConnection connection = database.getConnection();
        if (connection instanceof ProJdbcConnection) {
            ProJdbcConnection proJdbcConnection = (ProJdbcConnection)connection;
            userName = proJdbcConnection.getUsername();
            if (userName == null) {
                userName = connection.getConnectionUserName();
            }
            userName = StringUtil.trimToEmpty((String)userName);
            password = StringUtil.trimToEmpty((String)proJdbcConnection.getPassword());
            if (password.equals("")) {
                userName = "";
            }
        }
        this.addCredentials(commandArray, userName, password);
        if (((MSSQLDatabase)database).isAzureDb()) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database is AzureDB");
            commandArray.add("-d");
            commandArray.add(useCatalogName);
        }
        if (this.isActiveDirectoryAuthentication(database)) {
            commandArray.add("-G");
        }
        if (this.outFile != null) {
            commandArray.add("-i");
            commandArray.add(this.outFile.getAbsolutePath());
        }
        commandArray.add("-b");
        commandArray.add("-e");
        if (!this.args.isEmpty()) {
            commandArray.addAll(Collections.unmodifiableList(this.args));
        }
        String commandLine = StringUtil.join((Collection)commandArray, (String)" ");
        commandLine = commandLine.replaceAll("^(.*?) (.*?) -U (.*?) -P (.*?) (.*)", "$1 $2 -U ****** -P ****** $5");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD command:\n" + commandLine);
        return commandArray;
    }

    private void addCredentials(List<String> commandArray, String userName, String password) {
        if (StringUtil.isEmpty((String)userName) || StringUtil.isEmpty((String)password)) {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection is missing username and/or password. Assuming integratedSecurity.");
            commandArray.add("-E");
        } else {
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).fine("database connection has both username and password. Adding -U and -P to commandArray.");
            commandArray.add("-U");
            commandArray.add(userName);
            commandArray.add("-P");
            commandArray.add(password);
        }
    }

    public void executeCommand(Database database) throws Exception {
        try {
            this.finalCommandArray = this.createFinalCommandArray(database);
            super.executeCommand(database);
        }
        catch (TimeoutException e) {
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.processResult(0, null, null, database);
            String message = e.getMessage() + System.lineSeparator() + System.lineSeparator() + "The sqlcmd executable failed to return a response within the configured timeout.\nPlease check liquibase.sqlcmd.timeout specified in liquibase.sqlcmd.conf file, the LIQUIBASE_SQLCMD_TIMEOUT Environment variable, or other config locations.\nLearn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sqlcmd-integration.html." + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning(message);
            throw new LiquibaseException((Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            String tempDirectoryPath = this.tempPath;
            String message = e.getMessage();
            try {
                if (this.logFile != null) {
                    File file;
                    if (tempDirectoryPath == null) {
                        tempDirectoryPath = System.getProperty("java.io.tmpdir");
                    }
                    if ((file = new File(tempDirectoryPath, this.logFile)).exists()) {
                        message = FileUtil.getContents((File)file);
                    }
                }
            }
            catch (Exception e1) {
                Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning("Error reading logfile '" + new File(tempDirectoryPath, this.logFile) + this.logFile + "' " + e.getMessage());
            }
            throw new DatabaseException(message, (Throwable)e);
        }
        finally {
            if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLCMD run script can be located at: " + this.outFile.getAbsolutePath());
            }
        }
    }

    protected void processResult(int returnCode, String errorStreamOut, String infoStreamOut, Database database) {
        if (returnCode != 0 && !StringUtil.isEmpty((String)infoStreamOut)) {
            String returnString = this.getCommandString() + " returned a code of " + returnCode + "\n" + infoStreamOut;
            throw new UnexpectedLiquibaseException(returnString);
        }
        super.processResult(returnCode, errorStreamOut, infoStreamOut, database);
    }

    protected ExecuteShellCommandChange.StreamGobbler createErrorGobbler(InputStream processStream, OutputStream errorStream) {
        return new ExecuteShellCommandChange.StreamGobbler((ExecuteShellCommandChange)this, processStream, errorStream, Thread.currentThread());
    }

    private boolean isActiveDirectoryAuthentication(Database database) {
        String url = database.getConnection().getURL();
        return url.toLowerCase().contains("authentication=activedirectorypassword") || url.toLowerCase().contains("authentication=activedirectorymsi") || url.toLowerCase().contains("activedirectoryintegrated");
    }

    private String getDatabaseHostname(Database database) {
        String port;
        String hostname;
        String url = database.getConnection().getURL();
        Pattern pattern = Pattern.compile(".*?//(.*?):(\\d+);.*");
        Matcher matcher = pattern.matcher(url);
        if (matcher.matches()) {
            hostname = matcher.group(1);
            port = matcher.group(2);
        } else {
            hostname = url.replaceFirst(".*?//", "").replaceFirst(":.*", "").replaceFirst(";.*", "");
            port = "1433";
        }
        return "tcp:" + hostname + "," + port;
    }

    private void loadSqlcmdProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(NativeExecutorRunner.ConfigFile.SQLCMD);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        this.addPropertiesToMdc();
        this.handleSqlcmdExecutable(this.sqlcmdExec);
        this.handleTimeout(this.timeout);
        this.logProperties();
    }

    private void handleArgs(String argsString) {
        if (argsString != null) {
            argsString = argsString.trim();
            Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdArgs", argsString);
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a extra arguments of '" + argsString + "'");
            this.args = StringUtil.splitAndTrim((String)argsString, (String)" ");
        }
    }

    private void handleTimeout(Integer timeout) {
        if (timeout != null) {
            Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdTimeout", String.valueOf(timeout));
            NativeRunnerUtil.validateTimeout(timeout);
            this.setTimeout(String.valueOf(timeout));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a timeout of '" + timeout + "'");
        }
    }

    private void handleSqlcmdExecutable(File sqlcmdExec) {
        if (sqlcmdExec == null) {
            return;
        }
        this.checkSqlcmdExecutable(sqlcmdExec);
        try {
            this.setExecutable(sqlcmdExec.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'sqlcmd' executable located at:  '" + sqlcmdExec.getCanonicalPath() + "'");
            Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdPath", sqlcmdExec.toString());
            this.sqlcmdExec = sqlcmdExec;
        }
        catch (IOException ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.keepTempFile = SqlcmdConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)SqlcmdConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        this.tempName = SqlcmdConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)SqlcmdConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = SqlcmdConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)SqlcmdConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.tempOverwrite = SqlcmdConfiguration.TEMP_OVERWRITE.getCurrentValue() != null ? (Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getCurrentValue() : this.tempOverwrite;
        this.logFile = SqlcmdConfiguration.LOG_FILE.getCurrentValue() != null ? (String)SqlcmdConfiguration.LOG_FILE.getCurrentValue() : this.logFile;
        this.catalogName = SqlcmdConfiguration.CATALOG_NAME.getCurrentValue() != null ? (String)SqlcmdConfiguration.CATALOG_NAME.getCurrentValue() : this.catalogName;
        Integer n = this.timeout = SqlcmdConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)SqlcmdConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        if (SqlcmdConfiguration.PATH.getCurrentValue() != null) {
            this.sqlcmdExec = new File((String)SqlcmdConfiguration.PATH.getCurrentValue());
        }
        if (SqlcmdConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)SqlcmdConfiguration.ARGS.getCurrentValue());
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a keep temp file name value of '" + this.tempName + "'");
        }
        if (this.logFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlcmd' with a log file value of '" + this.logFile + "'");
        }
    }

    private void checkSqlcmdExecutable(File sqlcmdExec) {
        if (!sqlcmdExec.exists()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable was not found at '" + sqlcmdExec.getAbsolutePath() + "'.\nPlease check the liquibase.sqlcmd.path property in liquibase.sqlcmd.conf, the LIQUIBASE_SQLCMD_PATH Environment variable, \nor other config locations. Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sqlcmd-integration.html.\n");
        }
        if (!sqlcmdExec.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'sqlcmd' executable located at '" + sqlcmdExec.getAbsolutePath() + "' cannot be executed");
        }
    }

    private void addPropertiesToMdc() {
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdKeepTemp", String.valueOf(this.keepTempFile));
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdKeepTempPath", this.tempPath);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdKeepTempName", this.tempName);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdLogFile", this.logFile);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdTempOverwrite", String.valueOf(this.tempOverwrite));
        Scope.getCurrentScope().addMdcValue("liquibaseSqlcmdCatalogName", this.catalogName);
    }

    private int determineTimeout(Properties properties) {
        String timeoutString = properties.getProperty("liquibase.sqlcmd.timeout");
        if (timeoutString == null) {
            return -1;
        }
        try {
            return Integer.parseInt(timeoutString);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Invalid value '" + timeoutString + "' for timeoutString 'liquibase.sqlcmd.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sqlcmd-integration.html");
        }
    }

    private void setupConfProperties(Properties properties) {
        if (properties.containsKey(SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties(properties, "liquibase.sqlcmd.keep.temp");
        }
        if (properties.containsKey(SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
            this.tempOverwrite = NativeRunnerUtil.getBooleanFromProperties(properties, SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        }
        if (properties.containsKey(SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey(SqlcmdConfiguration.ConfigurationKeys.getFullKey("logFile"))) {
            this.logFile = properties.getProperty(SqlcmdConfiguration.ConfigurationKeys.getFullKey("logFile"));
        }
        if (properties.containsKey("liquibase.sqlcmd.path")) {
            this.sqlcmdExec = new File(properties.getProperty("liquibase.sqlcmd.path"));
        }
        if (properties.containsKey("liquibase.sqlcmd.timeout")) {
            this.timeout = this.determineTimeout(properties);
        }
        if (properties.containsKey("liquibase.sqlcmd.args")) {
            this.handleArgs(properties.getProperty("liquibase.sqlcmd.args"));
        }
        if (properties.containsKey("liquibase.sqlcmd.catalogName")) {
            this.catalogName = properties.getProperty(SqlcmdConfiguration.ConfigurationKeys.getFullKey("catalogName"));
        }
    }

    private void writeSql(String useCatalogName) throws Exception {
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        log.info("Creating the SQL run script");
        NativeToolFileCreator sqlcmdFileCreator = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlcmdConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        try {
            this.outFile = sqlcmdFileCreator.generateTemporaryFile(NativeToolFileCreator.FileTypeEnum.sql);
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        for (Sql sql : this.sqlStrings) {
            if (this.warnOnOutStatements(sql)) break;
        }
        String lineSeparator = System.lineSeparator();
        Path path = Paths.get(this.outFile.getAbsolutePath(), new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            if (this.logFile != null) {
                String logFilePath = null;
                try {
                    Pattern p = Pattern.compile("(.*?)(\\..*)$");
                    Matcher m = p.matcher(this.logFile);
                    String changeSetString = FilenameUtil.sanitizeFileName((String)("-" + this.changeSet.getAuthor() + "-" + this.changeSet.getId()));
                    this.logFile = m.matches() ? m.group(1) + changeSetString + m.group(2) : this.logFile + changeSetString + ".log";
                    Scope.getCurrentScope().getLog(SqlcmdRunner.class).info("Using log file name '" + this.logFile + "'");
                    if (ResourceUtil.isAbsolute(this.logFile)) {
                        logFilePath = this.logFile;
                    } else {
                        NativeToolFileCreator logFileCreator = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlcmdConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlcmdConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlcmdConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"));
                        File logFileObject = logFileCreator.generateTemporaryFile(NativeToolFileCreator.FileTypeEnum.log, false);
                        logFilePath = logFileObject.getParent() + "/" + this.logFile;
                        logFilePath = logFilePath.replace("//", "/");
                        if (!Files.deleteIfExists(logFileObject.toPath())) {
                            Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning("Unable to clean up temporary file '" + logFileObject.getAbsolutePath() + "'");
                        }
                    }
                    Scope.getCurrentScope().getLog(SqlcmdRunner.class).info("Full log file path is '" + logFilePath + "'");
                }
                catch (IOException e) {
                    throw new UnexpectedLiquibaseException((Throwable)e);
                }
                logFilePath = logFilePath.replace(" ", "_");
                writer.write("\n:OUT " + logFilePath + lineSeparator);
            }
            if (useCatalogName != null) {
                writer.write("USE [" + useCatalogName + "];" + lineSeparator);
                writer.write("GO" + lineSeparator);
            }
            writer.write(";" + lineSeparator);
            this.writeSqlStrings(writer);
            String endDelimiter = this.getEndDelimiter();
            if (endDelimiter != null && endDelimiter.equals("\n/$")) {
                writer.write("/\n");
            }
            writer.write("GO\n");
        }
    }

    private boolean warnOnOutStatements(Sql sql) {
        String[] lines;
        for (String line : lines = sql.toSql().split("\n")) {
            if (!line.matches("(?im)^\\s*:out .*")) continue;
            Scope.getCurrentScope().getLog(SqlcmdRunner.class).warning("OUT statements were detected in your script for changeset " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent SQLCMD output from being included in the Liquibase logs");
            return true;
        }
        return false;
    }

    @Override
    public String getIntegrationDisplayName() {
        return "SQLCMD";
    }
}

