/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.util;

import com.datical.liquibase.ext.command.ProReferenceSnapshotCommandStep;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import liquibase.Scope;
import liquibase.command.core.DiffCommandStep;
import liquibase.database.Database;
import liquibase.snapshot.SnapshotControl;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.DatabaseObjectFactory;
import liquibase.structure.core.ForeignKey;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.UniqueConstraint;
import liquibase.util.StringUtil;

public class SnapshotControlUtil {
    public static SnapshotControl createSnapshotControl(Database database, String typesString) {
        Class[] types = SnapshotControlUtil.determineTypesToSnapshot(typesString);
        List finalList = Arrays.stream(types).map(Class::getSimpleName).collect(Collectors.toList());
        Scope.getCurrentScope().getLog(ProReferenceSnapshotCommandStep.class).info(String.format("Running snapshot with filters: %s", StringUtil.join(finalList, (String)",")));
        return new SnapshotControl(database, types);
    }

    public static String getStandardTypes() {
        Set standardTypes = DatabaseObjectFactory.getInstance().getStandardTypes();
        ArrayList typesList = new ArrayList();
        standardTypes.forEach(type -> {
            String[] parts = type.getName().split("\\.");
            String name = parts[parts.length - 1];
            typesList.add(name);
        });
        StringBuilder builder = new StringBuilder();
        Collections.sort(typesList);
        typesList.forEach(name -> {
            if (builder.length() == 0) {
                builder.append((String)name);
            } else {
                builder.append(", ");
                builder.append((String)name);
            }
        });
        return builder.toString();
    }

    public static String getAvailableTypes() {
        return "Catalog, CheckConstraint, Column, DatabasePackage, DatabasePackageBody, ForeignKey, Function, Index, PrimaryKey, Schema, Sequence, StoredProcedure, Synonym, Table, Trigger, UniqueConstraint, View";
    }

    private static Class<? extends DatabaseObject>[] determineTypesToSnapshot(String typesString) {
        Class[] newTypes;
        if (typesString == null) {
            return null;
        }
        Class[] types = DiffCommandStep.parseSnapshotTypes((String[])new String[]{typesString});
        boolean foundOthers = false;
        boolean foundIndexClass = false;
        boolean foundColumnClass = false;
        for (Class type : types) {
            if (type.isAssignableFrom(PrimaryKey.class) || type.isAssignableFrom(ForeignKey.class) || type.isAssignableFrom(UniqueConstraint.class)) {
                foundOthers = true;
            }
            if (type.isAssignableFrom(Index.class)) {
                foundIndexClass = true;
            }
            if (!type.isAssignableFrom(Column.class)) continue;
            foundColumnClass = true;
        }
        if (foundOthers) {
            newTypes = new Class[types.length + 1];
            ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(types));
            if (!foundIndexClass) {
                list.add(Index.class);
                Scope.getCurrentScope().getLog(ProReferenceSnapshotCommandStep.class).fine("Added Index to the types list");
            }
            if (!foundColumnClass) {
                list.add(Column.class);
                Scope.getCurrentScope().getLog(ProReferenceSnapshotCommandStep.class).fine("Added Column to the types list");
            }
            if (list.size() > types.length) {
                types = list.toArray(newTypes);
            }
        } else if (foundIndexClass && !foundColumnClass) {
            newTypes = new Class[types.length + 1];
            ArrayList<Class> list = new ArrayList<Class>(Arrays.asList(types));
            list.add(Column.class);
            Scope.getCurrentScope().getLog(ProReferenceSnapshotCommandStep.class).fine("Added Column to the types list");
            types = list.toArray(newTypes);
        }
        return types;
    }
}

