/*
 * Decompiled with CFR 0.152.
 */
package liquibase.license.pro;

import com.datical.liquibase.ext.config.LiquibaseLabsConfiguration;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import liquibase.license.LicenseServiceUtils;
import liquibase.util.StringUtil;

public enum LicenseTier {
    LABS("Liquibase Labs", 200),
    PRO("Liquibase Pro", Collections.singletonList(LABS), 100),
    COMMUNITY("Liquibase", Arrays.asList(PRO, LABS), 0);

    private final String subject;
    private final List<LicenseTier> supersetLicenses;
    private final int value;

    private LicenseTier(String subject, int value) {
        this(subject, null, value);
    }

    private LicenseTier(String subject, List<LicenseTier> supersetLicenses, int value) {
        this.subject = subject;
        this.supersetLicenses = supersetLicenses;
        this.value = value;
    }

    public String getSubject() {
        return this.subject;
    }

    public List<LicenseTier> getSupersetLicenses() {
        return this.supersetLicenses;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isValid() {
        if (this == LABS) {
            return LiquibaseLabsConfiguration.isLabsLicenseValid();
        }
        if (this == PRO) {
            return LicenseServiceUtils.isProLicenseValid();
        }
        return this == COMMUNITY;
    }

    public static LicenseTier fromSubject(String subject) {
        if (!StringUtil.isEmpty((String)subject)) {
            for (LicenseTier value : LicenseTier.values()) {
                if (!value.getSubject().equals(subject)) continue;
                return value;
            }
        }
        return null;
    }
}

