/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.difflib.patch;

import java.util.List;
import liquibase.repackaged.com.github.difflib.patch.AbstractDelta;
import liquibase.repackaged.com.github.difflib.patch.Chunk;
import liquibase.repackaged.com.github.difflib.patch.DeltaType;
import liquibase.repackaged.com.github.difflib.patch.PatchFailedException;

public final class DeleteDelta<T>
extends AbstractDelta<T> {
    public DeleteDelta(Chunk<T> original, Chunk<T> revised) {
        super(DeltaType.DELETE, original, revised);
    }

    @Override
    protected void applyTo(List<T> target) throws PatchFailedException {
        int position = this.getSource().getPosition();
        int size = this.getSource().size();
        for (int i = 0; i < size; ++i) {
            target.remove(position);
        }
    }

    @Override
    protected void restore(List<T> target) {
        int position = this.getTarget().getPosition();
        List lines = this.getSource().getLines();
        for (int i = 0; i < lines.size(); ++i) {
            target.add(position + i, lines.get(i));
        }
    }

    public String toString() {
        return "[DeleteDelta, position: " + this.getSource().getPosition() + ", lines: " + this.getSource().getLines() + "]";
    }

    @Override
    public AbstractDelta<T> withChunks(Chunk<T> original, Chunk<T> revised) {
        return new DeleteDelta<T>(original, revised);
    }
}

