/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.com.github.vertical_blank.sqlformatter.core;

import java.util.ArrayDeque;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import liquibase.repackaged.com.github.vertical_blank.sqlformatter.core.Token;

public interface Params {
    public static final Params EMPTY = new Empty();

    public boolean isEmpty();

    public Object get();

    public Object getByName(String var1);

    public static Params of(Map<String, ?> params) {
        return new NamedParams(params);
    }

    public static Params of(List<?> params) {
        return new IndexedParams(params);
    }

    default public Object get(Token token) {
        if (this.isEmpty()) {
            return token.value;
        }
        if (token.key != null && !token.key.isEmpty()) {
            return this.getByName(token.key);
        }
        return this.get();
    }

    public static class NamedParams
    implements Params {
        private final Map<String, ?> params;

        NamedParams(Map<String, ?> params) {
            this.params = params;
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public Object getByName(String key) {
            return this.params.get(key);
        }

        public String toString() {
            return this.params.toString();
        }
    }

    public static class IndexedParams
    implements Params {
        private final Queue<?> params;

        IndexedParams(List<?> params) {
            this.params = new ArrayDeque(params);
        }

        @Override
        public boolean isEmpty() {
            return this.params.isEmpty();
        }

        @Override
        public Object get() {
            return this.params.poll();
        }

        @Override
        public Object getByName(String key) {
            return null;
        }

        public String toString() {
            return this.params.toString();
        }
    }

    public static class Empty
    implements Params {
        Empty() {
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public Object getByName(String key) {
            return null;
        }

        public String toString() {
            return "[]";
        }
    }
}

