/*
 * Decompiled with CFR 0.152.
 */
package liquibase.repackaged.net.sf.jsqlparser.util.deparser;

import liquibase.repackaged.net.sf.jsqlparser.expression.ExpressionVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.select.SelectVisitor;
import liquibase.repackaged.net.sf.jsqlparser.statement.upsert.Upsert;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.AbstractDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.ExpressionDeParser;
import liquibase.repackaged.net.sf.jsqlparser.util.deparser.SelectDeParser;

public class UpsertDeParser
extends AbstractDeParser<Upsert> {
    private ExpressionDeParser expressionVisitor;
    private SelectDeParser selectVisitor;

    public UpsertDeParser(ExpressionDeParser expressionVisitor, SelectDeParser selectVisitor, StringBuilder buffer) {
        super(buffer);
        this.expressionVisitor = expressionVisitor;
        this.expressionVisitor.setSelectVisitor(selectVisitor);
        this.selectVisitor = selectVisitor;
        this.selectVisitor.setExpressionVisitor(expressionVisitor);
    }

    @Override
    public void deParse(Upsert upsert) {
        switch (upsert.getUpsertType()) {
            case REPLACE: 
            case REPLACE_SET: {
                this.buffer.append("REPLACE ");
                break;
            }
            case INSERT_OR_ABORT: {
                this.buffer.append("INSERT OR ABORT ");
                break;
            }
            case INSERT_OR_FAIL: {
                this.buffer.append("INSERT OR FAIL ");
                break;
            }
            case INSERT_OR_IGNORE: {
                this.buffer.append("INSERT OR IGNORE ");
                break;
            }
            case INSERT_OR_REPLACE: {
                this.buffer.append("INSERT OR REPLACE ");
                break;
            }
            case INSERT_OR_ROLLBACK: {
                this.buffer.append("INSERT OR ROLLBACK ");
                break;
            }
            default: {
                this.buffer.append("UPSERT ");
            }
        }
        if (upsert.isUsingInto()) {
            this.buffer.append("INTO ");
        }
        this.buffer.append(upsert.getTable().getFullyQualifiedName());
        if (upsert.getUpdateSets() != null) {
            this.buffer.append(" SET ");
            UpsertDeParser.deparseUpdateSets(upsert.getUpdateSets(), this.buffer, this.expressionVisitor);
        } else {
            if (upsert.getColumns() != null) {
                upsert.getColumns().accept(this.expressionVisitor);
            }
            if (upsert.getExpressions() != null) {
                upsert.getExpressions().accept(this.expressionVisitor);
            }
            if (upsert.getSelect() != null) {
                this.buffer.append(" ");
                upsert.getSelect().accept(this.selectVisitor);
            }
            if (upsert.getDuplicateUpdateSets() != null) {
                this.buffer.append(" ON DUPLICATE KEY UPDATE ");
                UpsertDeParser.deparseUpdateSets(upsert.getDuplicateUpdateSets(), this.buffer, this.expressionVisitor);
            }
        }
    }

    public ExpressionVisitor getExpressionVisitor() {
        return this.expressionVisitor;
    }

    public SelectVisitor getSelectVisitor() {
        return this.selectVisitor;
    }

    public void setExpressionVisitor(ExpressionDeParser visitor) {
        this.expressionVisitor = visitor;
    }

    public void setSelectVisitor(SelectDeParser visitor) {
        this.selectVisitor = visitor;
    }
}

