/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core;

import javax.annotation.CheckForNull;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truelicense.core.BasicLicenseManager;
import net.java.truelicense.core.License;
import net.java.truelicense.core.LicenseManagementException;
import net.java.truelicense.core.auth.Artifactory;
import net.java.truelicense.core.io.Source;
import net.java.truelicense.core.io.Store;
import net.java.truelicense.core.util.CacheEntry;
import net.java.truelicense.core.util.CachePeriodProvider;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@ThreadSafe
abstract class CachingLicenseConsumerManager
extends BasicLicenseManager
implements CachePeriodProvider {
    private volatile CachedArtifactory cachedArtifactory = new CachedArtifactory();
    private volatile CachedLicense cachedLicense = new CachedLicense();
    static final /* synthetic */ boolean $assertionsDisabled;

    CachingLicenseConsumerManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public License install(Source source) throws LicenseManagementException {
        Store store;
        Store store2 = store = this.store();
        synchronized (store2) {
            License license = super.install(source);
            if (!($assertionsDisabled || this.cachedArtifactory.matches(source) || this.cachedArtifactory.matches(store) || this.cachedArtifactory.isObsolete())) {
                throw new AssertionError();
            }
            if (!($assertionsDisabled || this.cachedLicense.matches(source) || this.cachedLicense.matches(store) || this.cachedLicense.isObsolete())) {
                throw new AssertionError();
            }
            this.cachedArtifactory = this.cachedArtifactory.source(store);
            this.cachedLicense = this.cachedLicense.source(store);
            return license;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uninstall() throws LicenseManagementException {
        CachedArtifactory cachedArtifactory = new CachedArtifactory();
        CachedLicense cachedLicense = new CachedLicense();
        Store store = this.store();
        synchronized (store) {
            super.uninstall();
            this.cachedArtifactory = cachedArtifactory;
            this.cachedLicense = cachedLicense;
        }
    }

    @Override
    void validate(Source source) throws Exception {
        License license = (License)this.cachedLicense.map(source);
        if (null == license) {
            license = this.decodeLicense(source);
            this.cachedLicense = new CachedLicense(source, license, this.cachePeriodMillis());
        }
        this.validation().validate(license);
    }

    @Override
    Artifactory authenticate(Source source) throws Exception {
        Artifactory artifactory = (Artifactory)this.cachedArtifactory.map(source);
        if (null == artifactory) {
            artifactory = super.authenticate(source);
            this.cachedArtifactory = new CachedArtifactory(source, artifactory, this.cachePeriodMillis());
        }
        return artifactory;
    }

    static {
        CachingLicenseConsumerManager.$assertionsDisabled = !CachingLicenseConsumerManager.class.desiredAssertionStatus();
    }

    @Immutable
    private static class CachedLicense
    extends CacheEntry<Source, License> {
        private static final long serialVersionUID = 1L;

        CachedLicense() {
            this(null, null, 0L);
        }

        CachedLicense(@CheckForNull Source source, @CheckForNull License license, long l) {
            super(source, license, l);
        }

        CachedLicense source(Source source) {
            return source.equals(this.getKey()) ? this : new CachedLicense(source, (License)this.getValue(), this.getCachePeriodMillis());
        }
    }

    @Immutable
    private static class CachedArtifactory
    extends CacheEntry<Source, Artifactory> {
        private static final long serialVersionUID = 1L;

        CachedArtifactory() {
            this(null, null, 0L);
        }

        CachedArtifactory(@CheckForNull Source source, @CheckForNull Artifactory artifactory, long l) {
            super(source, artifactory, l);
        }

        CachedArtifactory source(Source source) {
            return source.equals(this.getKey()) ? this : new CachedArtifactory(source, (Artifactory)this.getValue(), this.getCachePeriodMillis());
        }
    }
}

