/*
 * Decompiled with CFR 0.152.
 */
package net.java.truelicense.core.codec;

import java.nio.charset.Charset;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.CheckForNull;
import net.java.truelicense.core.codec.BinaryCodecException;
import net.java.truelicense.core.codec.Codec;
import net.java.truelicense.core.codec.SerializationCodec;
import net.java.truelicense.core.io.MemoryStore;
import net.java.truelicense.obfuscate.ObfuscatedString;
import org.apache.commons.codec.Charsets;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class Codecs {
    private static final Pattern CHARSET_PATTERN;
    static final /* synthetic */ boolean $assertionsDisabled;

    @CheckForNull
    public static Charset charset(Codec codec) {
        try {
            return Codecs.contentTransferCharset(codec);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static Charset contentTransferCharset(Codec codec) {
        String string = codec.contentTransferEncoding();
        if (Codecs.SEVEN_BIT().equalsIgnoreCase(string) || Codecs.QUOTED_PRINTABLE().equalsIgnoreCase(string) || Codecs.BASE64().equalsIgnoreCase(string)) {
            return Charsets.US_ASCII;
        }
        if (Codecs.EIGHT_BIT().equalsIgnoreCase(string)) {
            Matcher matcher = CHARSET_PATTERN.matcher(codec.contentType());
            if (matcher.find()) {
                if (!$assertionsDisabled && 2 != matcher.groupCount()) {
                    throw new AssertionError();
                }
                String string2 = matcher.group(1);
                if (null == string2) {
                    string2 = matcher.group(2);
                }
                return Charset.forName(string2);
            }
            return Charsets.UTF_8;
        }
        throw new BinaryCodecException(Codecs._string#6() + string + Codecs._string#7());
    }

    public static <T> T clone(T t) throws Exception {
        return Codecs.clone(t, new SerializationCodec());
    }

    public static <T> T clone(T t, Codec codec) throws Exception {
        MemoryStore memoryStore = new MemoryStore();
        codec.encode(memoryStore, t);
        return codec.decode(memoryStore, t.getClass());
    }

    private Codecs() {
    }

    private static /* synthetic */ void _clinit@1506769857326#0() {
        $assertionsDisabled = !Codecs.class.desiredAssertionStatus();
        CHARSET_PATTERN = Pattern.compile(Codecs.CHARSET_REGEXP(), 2);
    }

    static {
        Codecs._clinit@1506769857326#0();
    }

    static final /* synthetic */ String APPLICATION_XML_WITH_UTF_8() {
        return new ObfuscatedString(new long[]{7658750889006776111L, -4237638141282606458L, -3084759486613817549L, 7065633719812494979L, 4251848226300124421L}).toString();
    }

    static final /* synthetic */ String SEVEN_BIT() {
        return new ObfuscatedString(new long[]{9074049443229818426L, -8300529409867234500L}).toString();
    }

    static final /* synthetic */ String EIGHT_BIT() {
        return new ObfuscatedString(new long[]{2161736926036802916L, 318660202139074065L}).toString();
    }

    static final /* synthetic */ String QUOTED_PRINTABLE() {
        return new ObfuscatedString(new long[]{2536016490693978115L, 2331797449672517801L, -1149314475561633138L}).toString();
    }

    static final /* synthetic */ String BASE64() {
        return new ObfuscatedString(new long[]{6201883626566121336L, 5994732255170403809L}).toString();
    }

    private static final /* synthetic */ String CHARSET_REGEXP() {
        return new ObfuscatedString(new long[]{5783620761785920849L, 6341529770119497932L, -7478190673998334149L, 6072319168260293147L, -1598969503062490782L, -7896551308073304562L, -5246059827333486787L, 9133846383225841917L, 4413325656540205909L}).toString();
    }

    private static /* synthetic */ String _string#6() {
        return new ObfuscatedString(new long[]{6745337542070884646L, -1036736822296233523L, 3426546587393560431L, -7736141988619042840L, 6904154175994453973L}).toString();
    }

    private static /* synthetic */ String _string#7() {
        return new ObfuscatedString(new long[]{1032082319570324896L, 287901220852956385L, -1736579278318226692L, -6811873642137649251L}).toString();
    }
}

