/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.appdba.type;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.CreateCompositeTypeChange;
import com.datical.liquibase.ext.appdba.type.TypeAttribute;
import com.datical.liquibase.ext.license.LicenseCheckingChangeGenerator;
import com.datical.liquibase.ext.storedlogic.function.Function;
import java.util.List;
import java.util.stream.Collectors;
import liquibase.change.Change;
import liquibase.database.Database;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGeneratorChain;
import liquibase.diff.output.changelog.MissingObjectChangeGenerator;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.StoredProcedure;
import liquibase.structure.core.Table;
import liquibase.structure.core.View;

public class MissingCompositeTypeChangeGenerator
extends LicenseCheckingChangeGenerator
implements MissingObjectChangeGenerator {
    @Override
    public int getPriority(Class<? extends DatabaseObject> objectType, Database database) {
        if (CompositeType.class.isAssignableFrom(objectType)) {
            return super.getPriority(objectType, database);
        }
        return -1;
    }

    public Class<? extends DatabaseObject>[] runAfterTypes() {
        return new Class[0];
    }

    public Class<? extends DatabaseObject>[] runBeforeTypes() {
        return new Class[]{Table.class, View.class, StoredProcedure.class, Function.class};
    }

    public Change[] fixMissing(DatabaseObject missingObject, DiffOutputControl control, Database referenceDatabase, Database comparisonDatabase, ChangeGeneratorChain chain) {
        CompositeType compositeType = (CompositeType)missingObject;
        CreateCompositeTypeChange change = new CreateCompositeTypeChange();
        change.setTypeName(compositeType.getName());
        change.setCatalogName(compositeType.getSchema().getCatalogName());
        change.setSchemaName(compositeType.getSchema().getName());
        change.setTypeAttributes(this.copyAttributes(compositeType.getTypeAttributes()));
        return new Change[]{change};
    }

    private List<TypeAttribute> copyAttributes(List<TypeAttribute> snapshotAttributes) {
        return snapshotAttributes.stream().map(snapshotAttribute -> {
            TypeAttribute attribute = new TypeAttribute();
            attribute.setType(snapshotAttribute.getType());
            attribute.setName(snapshotAttribute.getName());
            attribute.setCollation(snapshotAttribute.getCollation());
            return attribute;
        }).collect(Collectors.toList());
    }
}

