/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.sqlgenerator.compositetype;

import com.datical.liquibase.ext.appdba.type.CompositeType;
import com.datical.liquibase.ext.appdba.type.TypeAttribute;
import com.datical.liquibase.ext.statement.compositetype.CreateCompositeTypeStatement;
import java.util.Iterator;
import liquibase.database.Database;
import liquibase.database.core.PostgresDatabase;
import liquibase.exception.ValidationErrors;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.AbstractSqlGenerator;
import liquibase.structure.DatabaseObject;
import org.apache.commons.lang3.StringUtils;

public class CreateCompositeTypeGenerator
extends AbstractSqlGenerator<CreateCompositeTypeStatement> {
    public boolean supports(CreateCompositeTypeStatement statement, Database database) {
        return database instanceof PostgresDatabase;
    }

    public int getPriority() {
        return 5;
    }

    public ValidationErrors validate(CreateCompositeTypeStatement statement, Database database, SqlGeneratorChain<CreateCompositeTypeStatement> sqlGeneratorChain) {
        ValidationErrors validationErrors = new ValidationErrors();
        validationErrors.checkRequiredField("typeName", (Object)statement.getName());
        validationErrors.checkRequiredField("typeAttributes", statement.getTypeAttributes());
        return validationErrors;
    }

    public Sql[] generateSql(CreateCompositeTypeStatement statement, Database database, SqlGeneratorChain<CreateCompositeTypeStatement> sqlGeneratorChain) {
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TYPE ").append(database.escapeObjectName(statement.getCatalogName(), statement.getSchemaName(), statement.getName(), CompositeType.class)).append(" AS (");
        Iterator<TypeAttribute> iterator = statement.getTypeAttributes().iterator();
        while (iterator.hasNext()) {
            TypeAttribute attribute = iterator.next();
            builder.append(database.escapeObjectName(attribute.getName(), TypeAttribute.class)).append(" ").append(attribute.getType());
            if (StringUtils.isNotEmpty((CharSequence)attribute.getCollation())) {
                builder.append(" COLLATE \"").append(attribute.getCollation()).append("\"");
            }
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return new Sql[]{new UnparsedSql(builder.toString(), new DatabaseObject[0])};
    }
}

