/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.tools;

import com.datical.liquibase.ext.appdba.sqlplus.change.exception.DaticalSpErrorLogException;
import com.datical.liquibase.ext.config.SqlplusConfiguration;
import com.datical.liquibase.ext.database.jvm.ProJdbcConnection;
import com.datical.liquibase.ext.tools.NativeExecutorRunner;
import com.datical.liquibase.ext.tools.NativeToolFileCreator;
import com.datical.liquibase.ext.util.NativeRunnerUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import liquibase.Scope;
import liquibase.changelog.ChangeSet;
import liquibase.configuration.ConfigurationDefinition;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.core.OracleDatabase;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.jvm.JdbcExecutor;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.Logger;
import liquibase.servicelocator.LiquibaseService;
import liquibase.sql.Sql;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.RawParameterizedSqlStatement;
import liquibase.util.StringUtil;

@LiquibaseService(skip=true)
public class SqlPlusRunner
extends NativeExecutorRunner {
    public static final String SYSDBA_STRING = "as sysdba";
    public static final String WHENEVER_SQLERROR_EXIT_SUCCESS_PATTERN = "(.*)WHENEVER\\s+SQLERROR\\s+EXIT\\s+SUCCESS;(.*)";
    private File outFile = null;
    private File spoolFile = null;
    private Boolean keepTempFile = false;
    private Boolean tempOverwrite = true;
    private List<String> args = new ArrayList<String>();
    private String tempName;
    private String tempPath;
    private Integer timeout;
    private String sqlerror;
    private Boolean createSpool = true;
    private File sqlPlusExec;
    private boolean ignoreSpErrorLog = false;
    private static final String DATICAL_SPERRORLOG = "DATICAL_SPERRORLOG";
    private boolean isSysdba;
    private String errorLoggingIdentifier;
    private static final String EXECUTABLE_NAME = "sqlplus";

    public int hashCode() {
        return super.hashCode();
    }

    public boolean equals(Object obj) {
        return super.equals(obj);
    }

    public SqlPlusRunner() {
    }

    @Override
    public String getIntegrationDisplayName() {
        return "SQL Plus";
    }

    public SqlPlusRunner(ChangeSet changeSet, Sql[] sqlStrings, boolean ignoreSpErrorLog) {
        this.changeSet = changeSet;
        this.sqlStrings = sqlStrings;
        this.setTimeout("1800");
        this.errorLoggingIdentifier = UUID.randomUUID().toString();
        this.ignoreSpErrorLog = ignoreSpErrorLog;
    }

    protected List<String> createFinalCommandArray(Database database) {
        this.loadSqlplusProperties();
        List commandArray = super.createFinalCommandArray(database);
        try {
            this.writeSql(database);
        }
        catch (Exception ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
        if (this.keepTempFile == null) {
            this.keepTempFile = (Boolean)SqlplusConfiguration.TEMP_KEEP.getCurrentValue();
        }
        if (!this.args.isEmpty()) {
            commandArray.addAll(Collections.unmodifiableList(this.args));
        }
        if (!commandArray.contains("-L")) {
            commandArray.add("-L");
        }
        String connectionString = this.buildConnectionString(database);
        commandArray.add(connectionString);
        if (this.isSysdba) {
            String[] parts = SYSDBA_STRING.split(" ");
            commandArray.addAll(Arrays.asList(parts));
        }
        if (this.outFile != null) {
            commandArray.add("@" + this.outFile.getAbsolutePath());
        }
        String commandLine = StringUtil.join((Collection)commandArray, (String)" ");
        commandLine = commandLine.replaceAll("^(.*?) (.*?)/\"(.*)\"@(.)", "$1 ******/******@$4");
        Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS command:\n" + commandLine);
        return commandArray;
    }

    protected void processResult(int returnCode, String errorStreamOut, String infoStreamOut, Database database) {
        try {
            Pattern p;
            Matcher m;
            List<?> daticalSpErrorLogResultList = this.processResultFromDaticalSpErrorLog(database);
            StringBuilder resultMessageBuilder = new StringBuilder();
            if (daticalSpErrorLogResultList == null || daticalSpErrorLogResultList.isEmpty()) {
                super.processResult(returnCode, errorStreamOut, infoStreamOut, database);
                return;
            }
            resultMessageBuilder.append("Error executing changeset '");
            resultMessageBuilder.append(this.changeSet.toString());
            resultMessageBuilder.append("'\n");
            for (Object daticalSpErrorLogResult : daticalSpErrorLogResultList) {
                resultMessageBuilder.append(daticalSpErrorLogResult.toString().concat("\n"));
            }
            if (this.sqlerror != null && (m = (p = Pattern.compile(WHENEVER_SQLERROR_EXIT_SUCCESS_PATTERN)).matcher(this.sqlerror)).matches() && returnCode == 0) {
                resultMessageBuilder = new StringBuilder("Ignoring ").append(resultMessageBuilder.toString().replace("Error executing", "error executing"));
                Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(resultMessageBuilder.toString());
                super.processResult(returnCode, errorStreamOut, infoStreamOut, database);
                return;
            }
            throw new DaticalSpErrorLogException(resultMessageBuilder.toString());
        }
        finally {
            this.dropDaticalSpErrorLog(database);
        }
    }

    public void executeCommand(Database database) throws Exception {
        try {
            this.createDaticalSpErrorLogIfNeeded(database);
        }
        catch (DaticalSpErrorLogException dspele) {
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(dspele.getMessage());
        }
        try {
            this.finalCommandArray = this.createFinalCommandArray(database);
            super.executeCommand(database);
        }
        catch (TimeoutException e) {
            try {
                SqlPlusRunner.releaseLocks(database);
            }
            catch (Exception e1) {
                String message = "exception occurred while releasing lock " + e1.getMessage();
                Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
                Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(message, (Throwable)e1);
            }
            this.ignoreSpErrorLog = true;
            try {
                Thread.sleep(10000L);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
            }
            this.processResult(0, null, null, database);
            String message = e.getMessage() + System.lineSeparator() + System.lineSeparator() + "The sqlplus executable failed to return a response within the configured timeout.\nPlease check liquibase.sqlcmd.timeout specified in liquibase.sqlplus.conf file, the LIQUIBASE_SQLPLUS_TIMEOUT Enviroment variable, or other config locations.\nLearn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sql-plus-integration.html." + System.lineSeparator();
            Scope.getCurrentScope().getUI().sendMessage("WARNING: " + message);
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(message);
            throw new LiquibaseException((Throwable)e);
        }
        catch (IllegalArgumentException iae) {
            throw iae;
        }
        catch (Exception e) {
            throw new LiquibaseException((Throwable)e);
        }
        finally {
            if (this.spoolFile != null) {
                try {
                    this.captureSpoolOutputInLog();
                }
                catch (IOException ioe) {
                    Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS was unable to read the spool file located at " + this.spoolFile.getAbsolutePath());
                }
            }
            if (this.outFile != null && this.outFile.exists() && this.keepTempFile != null && this.keepTempFile.booleanValue()) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("SQLPLUS run script can be located at: " + this.outFile.getAbsolutePath());
            }
        }
    }

    private static void releaseLocks(Database database) throws LockException {
        boolean wasInterrupted = Thread.interrupted();
        LockServiceFactory.getInstance().getLockService(database).releaseLock();
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        }
    }

    private void createDaticalSpErrorLogIfNeeded(Database database) {
        List daticalSpErrorLogResultList;
        if (this.ignoreSpErrorLog) {
            return;
        }
        String liquibaseCatalogName = this.getLiquibaseCatalogName(database);
        JdbcExecutor executor = new JdbcExecutor();
        executor.setDatabase(database);
        try {
            String sqlToCheckIfDaticalSpErrorLogExist = String.format("SELECT TABLE_NAME FROM ALL_TABLES WHERE OWNER='%s' AND TABLE_NAME='%s'", liquibaseCatalogName, DATICAL_SPERRORLOG);
            daticalSpErrorLogResultList = executor.queryForList((SqlStatement)new RawParameterizedSqlStatement(sqlToCheckIfDaticalSpErrorLogExist), String.class);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning(databaseException.getMessage());
            throw new DaticalSpErrorLogException(String.format("Can't check if table: %s exists due to an error", DATICAL_SPERRORLOG), databaseException);
        }
        if (daticalSpErrorLogResultList != null && !daticalSpErrorLogResultList.isEmpty()) {
            try {
                executor.execute((SqlStatement)new RawParameterizedSqlStatement(String.format("DELETE FROM %s.%s", liquibaseCatalogName, DATICAL_SPERRORLOG)));
            }
            catch (DatabaseException databaseException) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to clear rows from table: %s.%s due to an error. Table is locked or the user has insufficient privileges", liquibaseCatalogName, DATICAL_SPERRORLOG));
            }
        }
        try {
            String sqlToCreateDaticalSpErrorLog = String.format("CREATE TABLE %s.%s (username VARCHAR(256), timestamp TIMESTAMP, script VARCHAR(256), identifier VARCHAR(256), message CLOB, statement CLOB)", liquibaseCatalogName, DATICAL_SPERRORLOG);
            executor.execute((SqlStatement)new RawParameterizedSqlStatement(sqlToCreateDaticalSpErrorLog));
        }
        catch (DatabaseException databaseException) {
            if (databaseException.getMessage().contains("insufficient privileges")) {
                Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to create table: %s.%s due to an error. Insufficient privileges", liquibaseCatalogName, DATICAL_SPERRORLOG));
            }
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to create table: %s.%s due to an error. The table may already exist or you may not have privileges to create it.", liquibaseCatalogName, DATICAL_SPERRORLOG));
        }
    }

    private void dropDaticalSpErrorLog(Database database) {
        if (this.ignoreSpErrorLog) {
            return;
        }
        String liquibaseCatalogName = this.getLiquibaseCatalogName(database);
        JdbcExecutor executor = new JdbcExecutor();
        executor.setDatabase(database);
        try {
            executor.execute((SqlStatement)new RawParameterizedSqlStatement(String.format("DROP TABLE %s.%s", liquibaseCatalogName, DATICAL_SPERRORLOG)));
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to drop table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the DROP TABLE privilege. ", liquibaseCatalogName, DATICAL_SPERRORLOG));
        }
    }

    private String getLiquibaseCatalogName(Database database) {
        return "\"" + database.getLiquibaseCatalogName() + "\"";
    }

    private List<?> processResultFromDaticalSpErrorLog(Database database) {
        if (this.ignoreSpErrorLog) {
            return Collections.emptyList();
        }
        String liquibaseCatalogName = this.getLiquibaseCatalogName(database);
        JdbcExecutor executor = new JdbcExecutor();
        executor.setDatabase(database);
        List daticalSpErrorLogResultList = null;
        try {
            String formatString = "select CONCAT(CONCAT('Query: ', STATEMENT), CONCAT('>>> Has an error: ', MESSAGE)) as ERROR_MESSAGE from %s.%s WHERE IDENTIFIER='%s'";
            String sqlToFetchSpErrorLog = String.format(formatString, liquibaseCatalogName, DATICAL_SPERRORLOG, this.errorLoggingIdentifier);
            daticalSpErrorLogResultList = executor.queryForList((SqlStatement)new RawParameterizedSqlStatement(sqlToFetchSpErrorLog), String.class);
        }
        catch (DatabaseException databaseException) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).warning(String.format("Unable to query table: %s.%s  No action is required.To prevent this message in the future ensure that the user has the correct privileges. ", liquibaseCatalogName, DATICAL_SPERRORLOG));
        }
        return daticalSpErrorLogResultList;
    }

    private void loadSqlplusProperties() {
        this.setExecutable(NativeRunnerUtil.getExecutable(EXECUTABLE_NAME));
        Properties properties = this.getPropertiesFromConf(NativeExecutorRunner.ConfigFile.SQLPLUS);
        this.setupConfProperties(properties);
        this.assignPropertiesFromConfiguration();
        this.addPropertiesToMdc();
        this.handleSqlplusExecutable(this.sqlPlusExec);
        this.handleTimeout(this.timeout);
        this.logProperties();
    }

    private void addPropertiesToMdc() {
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusKeepTemp", String.valueOf(this.keepTempFile));
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusKeepTempPath", this.tempPath);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusKeepTempName", this.tempName);
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusTempOverwrite", String.valueOf(this.tempOverwrite));
    }

    private int determineTimeout(Properties properties) {
        String timeoutString = properties.getProperty("liquibase.sqlplus.timeout");
        if (timeoutString == null) {
            return -1;
        }
        try {
            return Integer.parseInt(timeoutString);
        }
        catch (Exception e) {
            throw new UnexpectedLiquibaseException("Invalid value '" + timeoutString + "' for property 'liquibase.sqlplus.timeout'. Must be a valid integer.  Learn more at https://docs.liquibase.com/concepts/changelogs/attributes/use-sql-plus-integration.html");
        }
    }

    private void logProperties() {
        if (this.keepTempFile != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file value of '" + this.keepTempFile + "'");
        }
        if (this.tempPath != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file path value of '" + this.tempPath + "'");
        }
        if (this.tempOverwrite != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file overwrite value of '" + this.tempOverwrite + "'");
        }
        if (this.tempName != null) {
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a keep temp file name value of '" + this.tempName + "'");
        }
    }

    private void handleArgs(String argsString) {
        if (argsString != null) {
            argsString = argsString.trim();
            Scope.getCurrentScope().addMdcValue("liquibaseSqlplusArgs", argsString);
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a extra arguments of '" + argsString + "'");
            this.args = StringUtil.splitAndTrim((String)argsString, (String)" ");
        }
    }

    private void handleTimeout(Integer timeout) {
        if (timeout != null) {
            Scope.getCurrentScope().addMdcValue("liquibaseSqlplusTimeout", String.valueOf(timeout));
            NativeRunnerUtil.validateTimeout(timeout);
            this.setTimeout(String.valueOf(timeout));
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Executing 'sqlplus' with a timeout of '" + timeout + "'");
        }
    }

    private void handleSqlplusExecutable(File sqlPlusExec) {
        if (sqlPlusExec == null) {
            return;
        }
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusPath", sqlPlusExec.toString());
        if (!sqlPlusExec.exists()) {
            throw new UnexpectedLiquibaseException("The executable for the native executor 'sqlplus' cannot be found at path '" + sqlPlusExec.getAbsolutePath() + "' as specified in the liquibase.sqlplus.conf file.\nPlease specify the correct path for the 'sqlplus' executable, or modify your PATH so that it can be located.  Learn more at http://docs.liquibase.com.");
        }
        if (!sqlPlusExec.canExecute()) {
            throw new UnexpectedLiquibaseException("The 'sqlplus' executable in the liquibase.sqlplus.conf file at " + sqlPlusExec.getAbsolutePath() + " cannot be executed");
        }
        try {
            this.setExecutable(sqlPlusExec.getCanonicalPath());
            Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass()).info("Using the 'sqlplus' executable located at:  '" + sqlPlusExec.getCanonicalPath() + "'");
        }
        catch (IOException ioe) {
            throw new UnexpectedLiquibaseException((Throwable)ioe);
        }
    }

    private void setupConfProperties(Properties properties) {
        if (properties.containsKey(SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp"))) {
            this.keepTempFile = NativeRunnerUtil.getBooleanFromProperties(properties, SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp"));
        }
        if (properties.containsKey(SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"))) {
            this.tempName = properties.getProperty(SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.name"));
        }
        if (properties.containsKey(SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"))) {
            this.tempOverwrite = NativeRunnerUtil.getBooleanFromProperties(properties, SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"));
        }
        if (properties.containsKey(SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"))) {
            this.tempPath = properties.getProperty(SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.path"));
        }
        if (properties.containsKey("liquibase.sqlplus.path")) {
            this.sqlPlusExec = new File(properties.getProperty("liquibase.sqlplus.path"));
        }
        if (properties.containsKey("liquibase.sqlplus.timeout")) {
            this.timeout = this.determineTimeout(properties);
        }
        if (properties.containsKey("liquibase.sqlplus.sqlerror")) {
            this.sqlerror = properties.getProperty(SqlplusConfiguration.ConfigurationKeys.getFullKey("sqlerror"));
        }
        if (properties.containsKey("liquibase.sqlplus.args")) {
            this.handleArgs(properties.getProperty("liquibase.sqlplus.args"));
        }
        if (properties.containsKey("liquibase.sqlplus.createSpool")) {
            String createSpoolProperty = properties.getProperty("liquibase.sqlplus.createSpool");
            if (!(createSpoolProperty = createSpoolProperty.toLowerCase()).equals("true") && !createSpoolProperty.equals("false")) {
                throw new IllegalArgumentException("Illegal value '" + createSpoolProperty + "' for createSpool. Valid values are 'TRUE' or 'FALSE'");
            }
            this.createSpool = Boolean.parseBoolean(createSpoolProperty);
        }
    }

    private void assignPropertiesFromConfiguration() {
        this.keepTempFile = SqlplusConfiguration.TEMP_KEEP.getCurrentValue() != null ? (Boolean)SqlplusConfiguration.TEMP_KEEP.getCurrentValue() : this.keepTempFile;
        this.tempName = SqlplusConfiguration.TEMP_NAME.getCurrentValue() != null ? (String)SqlplusConfiguration.TEMP_NAME.getCurrentValue() : this.tempName;
        this.tempPath = SqlplusConfiguration.TEMP_PATH.getCurrentValue() != null ? (String)SqlplusConfiguration.TEMP_PATH.getCurrentValue() : this.tempPath;
        this.tempOverwrite = SqlplusConfiguration.TEMP_OVERWRITE.getCurrentValue() != null ? (Boolean)SqlplusConfiguration.TEMP_OVERWRITE.getCurrentValue() : this.tempOverwrite;
        this.timeout = SqlplusConfiguration.TIMEOUT.getCurrentValue() != null ? (Integer)SqlplusConfiguration.TIMEOUT.getCurrentValue() : this.timeout;
        this.sqlerror = SqlplusConfiguration.SQLERROR.getCurrentValue() != null ? (String)SqlplusConfiguration.SQLERROR.getCurrentValue() : this.sqlerror;
        Boolean bl = this.createSpool = SqlplusConfiguration.CREATE_SPOOL.getCurrentValue() != null ? (Boolean)SqlplusConfiguration.CREATE_SPOOL.getCurrentValue() : this.createSpool;
        if (SqlplusConfiguration.PATH.getCurrentValue() != null) {
            this.sqlPlusExec = new File((String)SqlplusConfiguration.PATH.getCurrentValue());
        }
        if (SqlplusConfiguration.ARGS.getCurrentValue() != null) {
            this.handleArgs((String)SqlplusConfiguration.ARGS.getCurrentValue());
        }
    }

    private void writeSql(Database database) throws Exception {
        NativeToolFileCreator sqlPlusFileCreator;
        if (this.sqlStrings == null || this.sqlStrings.length == 0) {
            return;
        }
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        boolean allowAppendExtension = true;
        String spoolName = this.changeSet.getRunWithSpoolFile();
        if (spoolName == null) {
            spoolName = this.tempName;
        } else {
            Matcher m = NativeToolFileCreator.EXTENSION_PATTERN.matcher(spoolName);
            if (!m.matches()) {
                spoolName = spoolName + ".lst";
            }
            allowAppendExtension = false;
        }
        Scope.getCurrentScope().getLog(SqlPlusRunner.class).info("Using spool file name '" + spoolName + "'");
        log.info("Creating the SQL run script");
        Scope.getCurrentScope().getLog(SqlPlusRunner.class).info("Executing 'sqlplus' with a createSpool value of '" + this.createSpool + "'");
        Scope.getCurrentScope().addMdcValue("liquibaseSqlplusCreateSpool", this.createSpool.toString());
        if (Boolean.TRUE.equals(this.createSpool)) {
            try {
                sqlPlusFileCreator = new NativeToolFileCreator(this.changeSet, spoolName, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlplusConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlplusConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"));
                this.spoolFile = sqlPlusFileCreator.generateTemporaryFile(NativeToolFileCreator.FileTypeEnum.spool, allowAppendExtension);
                Scope.getCurrentScope().addMdcValue("liquibaseSqlplusSpoolFile", this.spoolFile.toString());
            }
            catch (IOException e) {
                throw new UnexpectedLiquibaseException((Throwable)e);
            }
            log.info("Using spool file name '" + this.spoolFile.toString() + "'");
        } else {
            log.info("Liquibase will not create spool files");
            this.spoolFile = null;
        }
        try {
            sqlPlusFileCreator = new NativeToolFileCreator(this.changeSet, this.tempName, this.tempPath, this.tempOverwrite == null ? ((Boolean)SqlplusConfiguration.TEMP_OVERWRITE.getDefaultValue()).booleanValue() : this.tempOverwrite.booleanValue(), this.keepTempFile == null ? ((Boolean)SqlplusConfiguration.TEMP_KEEP.getDefaultValue()).booleanValue() : this.keepTempFile.booleanValue(), this.getIntegrationDisplayName(), SqlplusConfiguration.ConfigurationKeys.getFullKey("keep.temp.overwrite"));
            this.outFile = sqlPlusFileCreator.generateTemporaryFile(NativeToolFileCreator.FileTypeEnum.sql);
        }
        catch (IOException e) {
            throw new UnexpectedLiquibaseException((Throwable)e);
        }
        boolean addWhenever = this.isAddWhenever();
        String liquibaseCatalogName = this.getLiquibaseCatalogName(database);
        Path path = Paths.get(this.outFile.getAbsolutePath(), new String[0]);
        try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
            writer.write("SET ECHO ON\n");
            writer.write("SET DEFINE OFF\n");
            writer.write(String.format("SET ERRORLOGGING ON TABLE %s.%s TRUNCATE IDENTIFIER '%s' %n", liquibaseCatalogName, DATICAL_SPERRORLOG, this.errorLoggingIdentifier));
            if (addWhenever) {
                if (StringUtil.isNotEmpty((String)this.sqlerror)) {
                    log.info("Adding WHENEVER SQLERROR CLAUSE of " + this.sqlerror);
                    if (!this.sqlerror.trim().endsWith(";")) {
                        this.sqlerror = this.sqlerror + ";";
                    }
                    writer.write(this.sqlerror + "\n");
                } else {
                    writer.write("WHENEVER SQLERROR EXIT FAILURE;\n");
                }
            }
            if (this.spoolFile != null) {
                writer.write("SPOOL \"" + this.spoolFile.getAbsolutePath() + "\"\n");
            }
            writer.write("SET SQLBLANKLINES ON\n\n");
            for (Sql sql : this.sqlStrings) {
                if (this.warnOnSpoolStatements(sql)) break;
            }
            if (database.getDefaultSchemaName() != null) {
                writer.write(String.format("ALTER SESSION SET CURRENT_SCHEMA=\"%s\";%n", database.getDefaultSchemaName()));
            }
            this.writeSqlStrings(writer);
            String endDelimiter = this.getEndDelimiter();
            if (endDelimiter != null) {
                if (endDelimiter.equals("\n/$")) {
                    writer.write("/\n");
                } else {
                    writer.write(endDelimiter + "\n");
                }
            }
            writer.write("EXIT;\n");
        }
    }

    private boolean warnOnSpoolStatements(Sql sql) {
        String[] lines;
        for (String line : lines = sql.toSql().split("\n")) {
            if (!line.toLowerCase().contains("spool")) continue;
            Scope.getCurrentScope().getLog(SqlPlusRunner.class).warning("SPOOL statements were detected in your script for changeset " + this.changeSet.getId() + "::" + this.changeSet.getAuthor() + ".\nThis may prevent sqlplus spool output from being included in the Liquibase logs");
            return true;
        }
        return false;
    }

    private boolean isAddWhenever() {
        boolean addWhenever = true;
        for (Sql sql : this.sqlStrings) {
            if (!sql.toSql().toLowerCase().startsWith("whenever")) continue;
            addWhenever = false;
            break;
        }
        return addWhenever;
    }

    private void captureSpoolOutputInLog() throws IOException {
        Logger log = Scope.getCurrentScope().getLog(((Object)((Object)this)).getClass());
        if (!this.spoolFile.exists()) {
            log.warning("Unable to locate spool output file " + this.spoolFile.getAbsolutePath());
            return;
        }
        log.info("Writing spool output to log");
        try (BufferedReader reader = Files.newBufferedReader(this.spoolFile.toPath());){
            String line;
            while ((line = reader.readLine()) != null) {
                log.info(line);
            }
        }
        log.info("\n");
        log.info("Spool output written to log");
    }

    protected String buildConnectionString(Database database) {
        String url;
        Matcher m;
        ProJdbcConnection proJdbcConnection;
        if (database == null) {
            return null;
        }
        DatabaseConnection connection = database.getConnection();
        String userName = this.getConfigValue(SqlplusConfiguration.USERNAME);
        String password = this.getConfigValue(SqlplusConfiguration.PASSWORD);
        if (!StringUtil.isEmpty((String)password)) {
            password = "\"" + password + "\"";
        }
        if (StringUtil.isEmpty((String)userName) && connection instanceof ProJdbcConnection) {
            proJdbcConnection = (ProJdbcConnection)connection;
            userName = proJdbcConnection.getUsername();
            if (userName == null) {
                userName = connection.getConnectionUserName();
            }
            userName = StringUtil.trimToEmpty((String)userName);
        }
        if (StringUtil.isEmpty((String)password) && connection instanceof ProJdbcConnection) {
            proJdbcConnection = (ProJdbcConnection)connection;
            password = StringUtil.trimToEmpty((String)proJdbcConnection.getPassword());
            if (password.equals("")) {
                userName = "";
            } else {
                password = "\"" + password + "\"";
            }
        }
        if ((m = OracleDatabase.PROXY_USER_PATTERN.matcher(url = connection.getURL())).matches()) {
            userName = userName + "[" + m.group(1) + "]";
        }
        String[] parts = url.split("jdbc:oracle:(.*)@");
        String rest = NativeRunnerUtil.handleLdapUrl(parts[1]);
        this.isSysdba = false;
        if (userName.toLowerCase().contains(SYSDBA_STRING)) {
            userName = userName.replaceAll("(?i) as sysdba", "");
            this.isSysdba = true;
        }
        return userName + "/" + password + "@" + rest;
    }

    private String getConfigValue(ConfigurationDefinition<String> configDef) {
        Properties properties = this.getPropertiesFromConf(NativeExecutorRunner.ConfigFile.SQLPLUS);
        String valueFromConfiguration = (String)configDef.getCurrentValue();
        AtomicReference<String> refValue = new AtomicReference<String>(valueFromConfiguration);
        HashMap<String, String> scopedValues = new HashMap<String, String>();
        if (properties.containsKey(configDef.getKey())) {
            scopedValues.put(configDef.getKey(), properties.getProperty(configDef.getKey()));
        }
        try {
            Scope.child(scopedValues, () -> refValue.set((String)configDef.getCurrentValue()));
            valueFromConfiguration = refValue.get();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return valueFromConfiguration;
    }
}

