/*
 * Decompiled with CFR 0.152.
 */
package liquibase;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Writer;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import liquibase.CatalogAndSchema;
import liquibase.Contexts;
import liquibase.RuntimeEnvironment;
import liquibase.change.CheckSum;
import liquibase.changelog.ChangeLogHistoryService;
import liquibase.changelog.ChangeLogHistoryServiceFactory;
import liquibase.changelog.ChangeLogIterator;
import liquibase.changelog.ChangeLogParameters;
import liquibase.changelog.ChangeSet;
import liquibase.changelog.ChangeSetStatus;
import liquibase.changelog.DatabaseChangeLog;
import liquibase.changelog.RanChangeSet;
import liquibase.changelog.filter.AfterTagChangeSetFilter;
import liquibase.changelog.filter.AlreadyRanChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilter;
import liquibase.changelog.filter.ChangeSetFilterResult;
import liquibase.changelog.filter.ContextChangeSetFilter;
import liquibase.changelog.filter.CountChangeSetFilter;
import liquibase.changelog.filter.DbmsChangeSetFilter;
import liquibase.changelog.filter.ExecutedAfterChangeSetFilter;
import liquibase.changelog.filter.NotRanChangeSetFilter;
import liquibase.changelog.filter.ShouldRunChangeSetFilter;
import liquibase.changelog.visitor.ChangeExecListener;
import liquibase.changelog.visitor.ChangeLogSyncListener;
import liquibase.changelog.visitor.ChangeLogSyncVisitor;
import liquibase.changelog.visitor.DBDocVisitor;
import liquibase.changelog.visitor.ExpectedChangesVisitor;
import liquibase.changelog.visitor.ListVisitor;
import liquibase.changelog.visitor.RollbackVisitor;
import liquibase.changelog.visitor.StatusVisitor;
import liquibase.changelog.visitor.UpdateVisitor;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.DatabaseFactory;
import liquibase.database.ObjectQuotingStrategy;
import liquibase.database.core.OracleDatabase;
import liquibase.diff.DiffGeneratorFactory;
import liquibase.diff.DiffResult;
import liquibase.diff.compare.CompareControl;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.exception.DatabaseException;
import liquibase.exception.LiquibaseException;
import liquibase.exception.LockException;
import liquibase.exception.UnexpectedLiquibaseException;
import liquibase.executor.Executor;
import liquibase.executor.ExecutorService;
import liquibase.executor.LoggingExecutor;
import liquibase.lockservice.DatabaseChangeLogLock;
import liquibase.lockservice.LockService;
import liquibase.lockservice.LockServiceFactory;
import liquibase.logging.LogFactory;
import liquibase.logging.Logger;
import liquibase.parser.ChangeLogParser;
import liquibase.parser.ChangeLogParserFactory;
import liquibase.resource.ResourceAccessor;
import liquibase.serializer.ChangeLogSerializer;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.snapshot.SnapshotControl;
import liquibase.snapshot.SnapshotGeneratorFactory;
import liquibase.statement.core.RawSqlStatement;
import liquibase.statement.core.UpdateStatement;
import liquibase.structure.DatabaseObject;
import liquibase.util.LiquibaseUtil;
import liquibase.util.StreamUtil;
import liquibase.util.StringUtils;

public class Liquibase {
    private DatabaseChangeLog databaseChangeLog;
    private String changeLogFile;
    private ResourceAccessor resourceAccessor;
    protected Database database;
    private Logger log = LogFactory.getLogger();
    private ChangeLogParameters changeLogParameters;
    private ChangeExecListener changeExecListener;
    private ChangeLogSyncListener changeLogSyncListener;
    private boolean ignoreClasspathPrefix = true;

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, DatabaseConnection conn) throws LiquibaseException {
        this(changeLogFile, resourceAccessor, DatabaseFactory.getInstance().findCorrectDatabaseImplementation(conn));
    }

    public Liquibase(String changeLogFile, ResourceAccessor resourceAccessor, Database database) throws LiquibaseException {
        if (changeLogFile != null) {
            this.changeLogFile = changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.changeLogParameters = new ChangeLogParameters(database);
        this.database = database;
    }

    public Liquibase(DatabaseChangeLog changeLog, ResourceAccessor resourceAccessor, Database database) {
        this.databaseChangeLog = changeLog;
        this.changeLogFile = changeLog.getPhysicalFilePath();
        if (this.changeLogFile != null) {
            this.changeLogFile = this.changeLogFile.replace('\\', '/');
        }
        this.resourceAccessor = resourceAccessor;
        this.database = database;
        this.changeLogParameters = new ChangeLogParameters(database);
    }

    public String getChangeLogFile() {
        return this.changeLogFile;
    }

    public Logger getLog() {
        return this.log;
    }

    public ChangeLogParameters getChangeLogParameters() {
        return this.changeLogParameters;
    }

    public Database getDatabase() {
        return this.database;
    }

    public ResourceAccessor getFileOpener() {
        return this.resourceAccessor;
    }

    public ResourceAccessor getResourceAccessor() {
        return this.resourceAccessor;
    }

    public void setCurrentDateTimeFunction(String currentDateTimeFunction) {
        this.database.setCurrentDateTimeFunction(currentDateTimeFunction);
    }

    public void update(String contexts) throws LiquibaseException {
        this.update(new Contexts(contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Contexts contexts) throws LiquibaseException {
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        this.changeLogParameters.setContexts(contexts);
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(true, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            ChangeLogIterator changeLogIterator = this.getStandardChangelogIterator(contexts, changeLog);
            changeLogIterator.run(this.createUpdateVisitor(), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            this.database.setObjectQuotingStrategy(ObjectQuotingStrategy.LEGACY);
            try {
                lockService.releaseLock();
            }
            catch (LockException e) {
                this.log.severe("Could not release lock", e);
            }
        }
    }

    public DatabaseChangeLog getDatabaseChangeLog() throws LiquibaseException {
        if (this.databaseChangeLog == null) {
            ChangeLogParser parser = ChangeLogParserFactory.getInstance().getParser(this.changeLogFile, this.resourceAccessor);
            this.databaseChangeLog = parser.parse(this.changeLogFile, this.changeLogParameters, this.resourceAccessor);
        }
        return this.databaseChangeLog;
    }

    protected UpdateVisitor createUpdateVisitor() {
        return new UpdateVisitor(this.database, this.changeExecListener);
    }

    protected ChangeLogIterator getStandardChangelogIterator(Contexts contexts, DatabaseChangeLog changeLog) throws DatabaseException {
        return new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(this.database, this.ignoreClasspathPrefix), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database));
    }

    public void update(String contexts, Writer output) throws LiquibaseException {
        this.update(new Contexts(contexts), output);
    }

    public void update(Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        LoggingExecutor loggingExecutor = new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database);
        ExecutorService.getInstance().setExecutor(this.database, loggingExecutor);
        this.outputHeader("Update Database Script");
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.update(contexts);
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        finally {
            lockService.releaseLock();
        }
        ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
    }

    public void update(int changesToApply, String contexts) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(int changesToApply, Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(true, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ShouldRunChangeSetFilter(this.database, this.ignoreClasspathPrefix), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(changesToApply));
            logIterator.run(this.createUpdateVisitor(), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            lockService.releaseLock();
        }
    }

    public void update(int changesToApply, String contexts, Writer output) throws LiquibaseException {
        this.update(changesToApply, new Contexts(contexts), output);
    }

    public void update(int changesToApply, Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        LoggingExecutor loggingExecutor = new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database);
        ExecutorService.getInstance().setExecutor(this.database, loggingExecutor);
        this.outputHeader("Update " + changesToApply + " Change Sets Database Script");
        this.update(changesToApply, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
    }

    private void outputHeader(String message) throws DatabaseException {
        Executor executor = ExecutorService.getInstance().getExecutor(this.database);
        executor.comment("*********************************************************************");
        executor.comment(message);
        executor.comment("*********************************************************************");
        executor.comment("Change Log: " + this.changeLogFile);
        executor.comment("Ran at: " + DateFormat.getDateTimeInstance(3, 3).format(new Date()));
        DatabaseConnection connection = this.getDatabase().getConnection();
        if (connection != null) {
            executor.comment("Against: " + connection.getConnectionUserName() + "@" + connection.getURL());
        }
        executor.comment("Liquibase version: " + LiquibaseUtil.getBuildVersion());
        executor.comment("*********************************************************************" + StreamUtil.getLineSeparator());
        if (this.database instanceof OracleDatabase) {
            executor.execute(new RawSqlStatement("SET DEFINE OFF;"));
        }
    }

    public void rollback(int changesToRollback, String contexts, Writer output) throws LiquibaseException {
        this.rollback(changesToRollback, new Contexts(contexts), output);
    }

    public void rollback(int changesToRollback, Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        ExecutorService.getInstance().setExecutor(this.database, new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database));
        this.outputHeader("Rollback " + changesToRollback + " Change(s) Script");
        this.rollback(changesToRollback, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
    }

    public void rollback(int changesToRollback, String contexts) throws LiquibaseException {
        this.rollback(changesToRollback, new Contexts(contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(int changesToRollback, Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(false, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            ChangeLogIterator logIterator = new ChangeLogIterator(this.database.getRanChangeSetList(), changeLog, new AlreadyRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(changesToRollback));
            logIterator.run(new RollbackVisitor(this.database), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            try {
                lockService.releaseLock();
            }
            catch (LockException e) {
                this.log.severe("Error releasing lock", e);
            }
        }
    }

    public void rollback(String tagToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(tagToRollBackTo, new Contexts(contexts), output);
    }

    public void rollback(String tagToRollBackTo, Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        ExecutorService.getInstance().setExecutor(this.database, new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database));
        this.outputHeader("Rollback to '" + tagToRollBackTo + "' Script");
        this.rollback(tagToRollBackTo, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
    }

    public void rollback(String tagToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(tagToRollBackTo, new Contexts(contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(String tagToRollBackTo, Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(false, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            List<RanChangeSet> ranChangeSetList = this.database.getRanChangeSetList();
            ChangeLogIterator logIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new AfterTagChangeSetFilter(tagToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database));
            logIterator.run(new RollbackVisitor(this.database), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            lockService.releaseLock();
        }
    }

    public void rollback(Date dateToRollBackTo, String contexts, Writer output) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts), output);
    }

    public void rollback(Date dateToRollBackTo, Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        ExecutorService.getInstance().setExecutor(this.database, new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database));
        this.outputHeader("Rollback to " + dateToRollBackTo + " Script");
        this.rollback(dateToRollBackTo, contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
    }

    public void rollback(Date dateToRollBackTo, String contexts) throws LiquibaseException {
        this.rollback(dateToRollBackTo, new Contexts(contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback(Date dateToRollBackTo, Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(false, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            List<RanChangeSet> ranChangeSetList = this.database.getRanChangeSetList();
            ChangeLogIterator logIterator = new ChangeLogIterator(ranChangeSetList, changeLog, new ExecutedAfterChangeSetFilter(dateToRollBackTo, ranChangeSetList), new AlreadyRanChangeSetFilter(ranChangeSetList), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database));
            logIterator.run(new RollbackVisitor(this.database), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            lockService.releaseLock();
        }
    }

    public void changeLogSync(String contexts, Writer output) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts), output);
    }

    public void changeLogSync(Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LoggingExecutor outputTemplate = new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        ExecutorService.getInstance().setExecutor(this.database, outputTemplate);
        this.outputHeader("SQL to add all changesets to database history table");
        this.changeLogSync(contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
    }

    public void changeLogSync(String contexts) throws LiquibaseException {
        this.changeLogSync(new Contexts(contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeLogSync(Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(true, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database));
            logIterator.run(new ChangeLogSyncVisitor(this.database, this.changeLogSyncListener), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            lockService.releaseLock();
        }
    }

    public void markNextChangeSetRan(String contexts, Writer output) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts), output);
    }

    public void markNextChangeSetRan(Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LoggingExecutor outputTemplate = new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        ExecutorService.getInstance().setExecutor(this.database, outputTemplate);
        this.outputHeader("SQL to add all changesets to database history table");
        this.markNextChangeSetRan(contexts);
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
    }

    public void markNextChangeSetRan(String contexts) throws LiquibaseException {
        this.markNextChangeSetRan(new Contexts(contexts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void markNextChangeSetRan(Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(false, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(1));
            logIterator.run(new ChangeLogSyncVisitor(this.database), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            lockService.releaseLock();
        }
    }

    public void futureRollbackSQL(String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(null, contexts, output);
    }

    public void futureRollbackSQL(Integer count, String contexts, Writer output) throws LiquibaseException {
        this.futureRollbackSQL(count, new Contexts(contexts), output);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void futureRollbackSQL(Integer count, Contexts contexts, Writer output) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        LoggingExecutor outputTemplate = new LoggingExecutor(ExecutorService.getInstance().getExecutor(this.database), output, this.database);
        Executor oldTemplate = ExecutorService.getInstance().getExecutor(this.database);
        ExecutorService.getInstance().setExecutor(this.database, outputTemplate);
        this.outputHeader("SQL to roll back currently unexecuted changes");
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            ChangeLogIterator logIterator;
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(false, changeLog, contexts);
            changeLog.validate(this.database, contexts);
            if (count == null) {
                logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database));
            } else {
                ChangeLogIterator forwardIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database), new CountChangeSetFilter(count));
                final ListVisitor listVisitor = new ListVisitor();
                forwardIterator.run(listVisitor, new RuntimeEnvironment(this.database, contexts));
                logIterator = new ChangeLogIterator(changeLog, new NotRanChangeSetFilter(this.database.getRanChangeSetList()), new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database), new ChangeSetFilter(){

                    @Override
                    public ChangeSetFilterResult accepts(ChangeSet changeSet) {
                        return new ChangeSetFilterResult(listVisitor.getSeenChangeSets().contains(changeSet), null, null);
                    }
                });
            }
            logIterator.run(new RollbackVisitor(this.database), new RuntimeEnvironment(this.database, contexts));
        }
        finally {
            lockService.releaseLock();
            ExecutorService.getInstance().setExecutor(this.database, oldTemplate);
        }
        try {
            output.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public final void dropAll() throws DatabaseException, LockException {
        this.dropAll(new CatalogAndSchema(this.getDatabase().getDefaultCatalogName(), this.getDatabase().getDefaultSchemaName()));
    }

    public final void dropAll(CatalogAndSchema ... schemas) throws DatabaseException {
        try {
            LockServiceFactory.getInstance().getLockService(this.database).waitForLock();
            for (CatalogAndSchema schema : schemas) {
                this.log.info("Dropping Database Objects in schema: " + schema);
                this.checkLiquibaseTables(false, null, new Contexts());
                this.getDatabase().dropDatabaseObjects(schema);
            }
        }
        catch (DatabaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DatabaseException(e);
        }
        finally {
            try {
                LockServiceFactory.getInstance().getLockService(this.database).releaseLock();
            }
            catch (LockException e) {
                this.log.severe("Unable to release lock: " + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tag(String tagString) throws LiquibaseException {
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, null, new Contexts());
            this.getDatabase().tag(tagString);
        }
        finally {
            lockService.releaseLock();
        }
    }

    public void updateTestingRollback(String contexts) throws LiquibaseException {
        this.updateTestingRollback(new Contexts(contexts));
    }

    public void updateTestingRollback(Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        Date baseDate = new Date();
        this.update(contexts);
        this.rollback(baseDate, contexts);
        this.update(contexts);
    }

    public void checkLiquibaseTables(boolean updateExistingNullChecksums, DatabaseChangeLog databaseChangeLog, Contexts contexts) throws LiquibaseException {
        ChangeLogHistoryService changeLogHistoryService = ChangeLogHistoryServiceFactory.getInstance().getChangeLogService(this.getDatabase());
        changeLogHistoryService.init();
        if (updateExistingNullChecksums) {
            changeLogHistoryService.upgradeChecksums(databaseChangeLog, contexts);
        }
        LockServiceFactory.getInstance().getLockService(this.getDatabase()).init();
    }

    public boolean isSafeToRunUpdate() throws DatabaseException {
        return this.getDatabase().isSafeToRunUpdate();
    }

    public DatabaseChangeLogLock[] listLocks() throws LiquibaseException {
        this.checkLiquibaseTables(false, null, new Contexts());
        return LockServiceFactory.getInstance().getLockService(this.database).listLocks();
    }

    public void reportLocks(PrintStream out) throws LiquibaseException {
        DatabaseChangeLogLock[] locks = this.listLocks();
        out.println("Database change log locks for " + this.getDatabase().getConnection().getConnectionUserName() + "@" + this.getDatabase().getConnection().getURL());
        if (locks.length == 0) {
            out.println(" - No locks");
        }
        for (DatabaseChangeLogLock lock : locks) {
            out.println(" - " + lock.getLockedBy() + " at " + DateFormat.getDateTimeInstance().format(lock.getLockGranted()));
        }
    }

    public void forceReleaseLocks() throws LiquibaseException {
        this.checkLiquibaseTables(false, null, new Contexts());
        LockServiceFactory.getInstance().getLockService(this.database).forceReleaseLock();
    }

    public List<ChangeSet> listUnrunChangeSets(String contexts) throws LiquibaseException {
        return this.listUnrunChangeSets(new Contexts(contexts));
    }

    public List<ChangeSet> listUnrunChangeSets(Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
        this.checkLiquibaseTables(true, changeLog, contexts);
        changeLog.validate(this.database, contexts);
        ChangeLogIterator logIterator = this.getStandardChangelogIterator(contexts, changeLog);
        ListVisitor visitor = new ListVisitor();
        logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts));
        return visitor.getSeenChangeSets();
    }

    public List<ChangeSetStatus> getChangeSetStatuses(Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
        this.checkLiquibaseTables(true, changeLog, contexts);
        changeLog.validate(this.database, contexts);
        ChangeLogIterator logIterator = this.getStandardChangelogIterator(contexts, changeLog);
        StatusVisitor visitor = new StatusVisitor(this.database);
        logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts));
        return visitor.getStatuses();
    }

    public void reportStatus(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportStatus(verbose, new Contexts(contexts), out);
    }

    public void reportStatus(boolean verbose, Contexts contexts, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        try {
            List<ChangeSet> unrunChangeSets = this.listUnrunChangeSets(contexts);
            if (unrunChangeSets.size() == 0) {
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(" is up to date");
                out.append(StreamUtil.getLineSeparator());
            } else {
                out.append(String.valueOf(unrunChangeSets.size()));
                out.append(" change sets have not been applied to ");
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(StreamUtil.getLineSeparator());
                if (verbose) {
                    for (ChangeSet changeSet : unrunChangeSets) {
                        out.append("     ").append(changeSet.toString(false)).append(StreamUtil.getLineSeparator());
                    }
                }
            }
            out.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(String contexts) throws LiquibaseException {
        return this.listUnexpectedChangeSets(new Contexts(contexts));
    }

    public Collection<RanChangeSet> listUnexpectedChangeSets(Contexts contexts) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
        changeLog.validate(this.database, contexts);
        ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new ContextChangeSetFilter(contexts), new DbmsChangeSetFilter(this.database));
        ExpectedChangesVisitor visitor = new ExpectedChangesVisitor(this.database.getRanChangeSetList());
        logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts));
        return visitor.getUnexpectedChangeSets();
    }

    public void reportUnexpectedChangeSets(boolean verbose, String contexts, Writer out) throws LiquibaseException {
        this.reportUnexpectedChangeSets(verbose, new Contexts(contexts), out);
    }

    public void reportUnexpectedChangeSets(boolean verbose, Contexts contexts, Writer out) throws LiquibaseException {
        this.changeLogParameters.setContexts(contexts);
        try {
            Collection<RanChangeSet> unexpectedChangeSets = this.listUnexpectedChangeSets(contexts);
            if (unexpectedChangeSets.size() == 0) {
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(" contains no unexpected changes!");
                out.append(StreamUtil.getLineSeparator());
            } else {
                out.append(String.valueOf(unexpectedChangeSets.size()));
                out.append(" unexpected changes were found in ");
                out.append(this.getDatabase().getConnection().getConnectionUserName());
                out.append("@");
                out.append(this.getDatabase().getConnection().getURL());
                out.append(StreamUtil.getLineSeparator());
                if (verbose) {
                    for (RanChangeSet ranChangeSet : unexpectedChangeSets) {
                        out.append("     ").append(ranChangeSet.toString()).append(StreamUtil.getLineSeparator());
                    }
                }
            }
            out.flush();
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCheckSums() throws LiquibaseException {
        this.log.info("Clearing database change log checksums");
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            this.checkLiquibaseTables(false, null, new Contexts());
            UpdateStatement updateStatement = new UpdateStatement(this.getDatabase().getLiquibaseCatalogName(), this.getDatabase().getLiquibaseSchemaName(), this.getDatabase().getDatabaseChangeLogTableName());
            updateStatement.addNewColumnValue("MD5SUM", null);
            ExecutorService.getInstance().getExecutor(this.database).execute(updateStatement);
            this.getDatabase().commit();
        }
        finally {
            lockService.releaseLock();
        }
    }

    public final CheckSum calculateCheckSum(String changeSetIdentifier) throws LiquibaseException {
        if (changeSetIdentifier == null) {
            throw new LiquibaseException(new IllegalArgumentException("changeSetIdentifier"));
        }
        List<String> parts = StringUtils.splitAndTrim(changeSetIdentifier, "::");
        if (parts == null || parts.size() < 3) {
            throw new LiquibaseException(new IllegalArgumentException("Invalid changeSet identifier: " + changeSetIdentifier));
        }
        return this.calculateCheckSum(parts.get(0), parts.get(1), parts.get(2));
    }

    public CheckSum calculateCheckSum(String filename, String id, String author) throws LiquibaseException {
        this.log.info(String.format("Calculating checksum for changeset %s::%s::%s", filename, id, author));
        ChangeLogParameters changeLogParameters = this.getChangeLogParameters();
        ResourceAccessor resourceAccessor = this.getResourceAccessor();
        DatabaseChangeLog changeLog = ChangeLogParserFactory.getInstance().getParser(this.changeLogFile, resourceAccessor).parse(this.changeLogFile, changeLogParameters, resourceAccessor);
        ChangeSet changeSet = changeLog.getChangeSet(filename, author, id);
        if (changeSet == null) {
            throw new LiquibaseException(new IllegalArgumentException("No such changeSet: " + filename + "::" + id + "::" + author));
        }
        return changeSet.generateCheckSum();
    }

    public void generateDocumentation(String outputDirectory) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts());
    }

    public void generateDocumentation(String outputDirectory, String contexts) throws LiquibaseException {
        this.generateDocumentation(outputDirectory, new Contexts(contexts));
    }

    public void generateDocumentation(String outputDirectory, Contexts contexts) throws LiquibaseException {
        this.log.info("Generating Database Documentation");
        this.changeLogParameters.setContexts(contexts);
        LockService lockService = LockServiceFactory.getInstance().getLockService(this.database);
        lockService.waitForLock();
        try {
            DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
            this.checkLiquibaseTables(false, changeLog, new Contexts());
            changeLog.validate(this.database, contexts);
            ChangeLogIterator logIterator = new ChangeLogIterator(changeLog, new DbmsChangeSetFilter(this.database));
            DBDocVisitor visitor = new DBDocVisitor(this.database);
            logIterator.run(visitor, new RuntimeEnvironment(this.database, contexts));
            visitor.writeHTML(new File(outputDirectory), this.resourceAccessor);
        }
        catch (IOException e) {
            throw new LiquibaseException(e);
        }
        finally {
            lockService.releaseLock();
        }
    }

    public DiffResult diff(Database referenceDatabase, Database targetDatabase, CompareControl compareControl) throws LiquibaseException {
        return DiffGeneratorFactory.getInstance().compare(referenceDatabase, targetDatabase, compareControl);
    }

    public void validate() throws LiquibaseException {
        DatabaseChangeLog changeLog = this.getDatabaseChangeLog();
        changeLog.validate(this.database, new String[0]);
    }

    public void setChangeLogParameter(String key, Object value) {
        this.changeLogParameters.set(key, value);
    }

    private void setDatabasePropertiesAsChangelogParameters(Database database) throws DatabaseException {
        this.setChangeLogParameter("database.autoIncrementClause", database.getAutoIncrementClause(null, null));
        this.setChangeLogParameter("database.currentDateTimeFunction", database.getCurrentDateTimeFunction());
        this.setChangeLogParameter("database.databaseChangeLogLockTableName", database.getDatabaseChangeLogLockTableName());
        this.setChangeLogParameter("database.databaseChangeLogTableName", database.getDatabaseChangeLogTableName());
        this.setChangeLogParameter("database.databaseMajorVersion", database.getDatabaseMajorVersion());
        this.setChangeLogParameter("database.databaseMinorVersion", database.getDatabaseMinorVersion());
        this.setChangeLogParameter("database.databaseProductName", database.getDatabaseProductName());
        this.setChangeLogParameter("database.databaseProductVersion", database.getDatabaseProductVersion());
        this.setChangeLogParameter("database.defaultCatalogName", database.getDefaultCatalogName());
        this.setChangeLogParameter("database.defaultSchemaName", database.getDefaultSchemaName());
        this.setChangeLogParameter("database.defaultSchemaNamePrefix", StringUtils.trimToNull(database.getDefaultSchemaName()) == null ? "" : "." + database.getDefaultSchemaName());
        this.setChangeLogParameter("database.lineComment", database.getLineComment());
        this.setChangeLogParameter("database.liquibaseSchemaName", database.getLiquibaseSchemaName());
        this.setChangeLogParameter("database.liquibaseTablespaceName", database.getLiquibaseTablespaceName());
        this.setChangeLogParameter("database.typeName", database.getShortName());
        this.setChangeLogParameter("database.isSafeToRunUpdate", database.isSafeToRunUpdate());
        this.setChangeLogParameter("database.requiresPassword", database.requiresPassword());
        this.setChangeLogParameter("database.requiresUsername", database.requiresUsername());
        this.setChangeLogParameter("database.supportsForeignKeyDisable", database.supportsForeignKeyDisable());
        this.setChangeLogParameter("database.supportsInitiallyDeferrableColumns", database.supportsInitiallyDeferrableColumns());
        this.setChangeLogParameter("database.supportsRestrictForeignKeys", database.supportsRestrictForeignKeys());
        this.setChangeLogParameter("database.supportsSchemas", database.supportsSchemas());
        this.setChangeLogParameter("database.supportsSequences", database.supportsSequences());
        this.setChangeLogParameter("database.supportsTablespaces", database.supportsTablespaces());
    }

    private LockService getLockService() {
        return LockServiceFactory.getInstance().getLockService(this.database);
    }

    public void setChangeExecListener(ChangeExecListener listener) {
        this.changeExecListener = listener;
    }

    public void setChangeLogSyncListener(ChangeLogSyncListener changeLogSyncListener) {
        this.changeLogSyncListener = changeLogSyncListener;
    }

    public void setIgnoreClasspathPrefix(boolean ignoreClasspathPrefix) {
        this.ignoreClasspathPrefix = ignoreClasspathPrefix;
    }

    public boolean isIgnoreClasspathPrefix() {
        return this.ignoreClasspathPrefix;
    }

    public void generateChangeLog(CatalogAndSchema catalogAndSchema, DiffToChangeLog changeLogWriter, PrintStream outputStream, Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, IOException, ParserConfigurationException {
        this.generateChangeLog(catalogAndSchema, changeLogWriter, outputStream, (ChangeLogSerializer)null, snapshotTypes);
    }

    public void generateChangeLog(CatalogAndSchema catalogAndSchema, DiffToChangeLog changeLogWriter, PrintStream outputStream, ChangeLogSerializer changeLogSerializer, Class<? extends DatabaseObject> ... snapshotTypes) throws DatabaseException, IOException, ParserConfigurationException {
        HashSet<Class<? extends DatabaseObject>> finalCompareTypes = null;
        if (snapshotTypes != null && snapshotTypes.length > 0) {
            finalCompareTypes = new HashSet<Class<? extends DatabaseObject>>(Arrays.asList(snapshotTypes));
        }
        SnapshotControl snapshotControl = new SnapshotControl(this.getDatabase(), snapshotTypes);
        CompareControl compareControl = new CompareControl(new CompareControl.SchemaComparison[]{new CompareControl.SchemaComparison(catalogAndSchema, catalogAndSchema)}, finalCompareTypes);
        DatabaseSnapshot originalDatabaseSnapshot = null;
        try {
            originalDatabaseSnapshot = SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), this.getDatabase(), snapshotControl);
            DiffResult diffResult = DiffGeneratorFactory.getInstance().compare(originalDatabaseSnapshot, SnapshotGeneratorFactory.getInstance().createSnapshot(compareControl.getSchemas(CompareControl.DatabaseRole.REFERENCE), null, snapshotControl), compareControl);
            changeLogWriter.setDiffResult(diffResult);
            if (changeLogSerializer != null) {
                changeLogWriter.print(outputStream, changeLogSerializer);
            } else {
                changeLogWriter.print(outputStream);
            }
        }
        catch (InvalidExampleException e) {
            throw new UnexpectedLiquibaseException(e);
        }
    }
}

