/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core.supplier;

import java.util.ArrayList;
import junit.framework.Assert;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateTableChange;
import liquibase.diff.DiffResult;
import liquibase.exception.DatabaseException;
import liquibase.sdk.supplier.change.AbstractChangeSupplier;
import liquibase.structure.core.Index;
import liquibase.util.StringUtils;

public class CreateIndexChangeSupplier
extends AbstractChangeSupplier<CreateIndexChange> {
    public CreateIndexChangeSupplier() {
        super(CreateIndexChange.class);
    }

    @Override
    public Change[] prepareDatabase(CreateIndexChange change) throws DatabaseException {
        CreateTableChange createTableChange = new CreateTableChange();
        createTableChange.setCatalogName(change.getCatalogName());
        createTableChange.setSchemaName(change.getSchemaName());
        createTableChange.setTableName(change.getTableName());
        for (AddColumnConfig column : change.getColumns()) {
            createTableChange.addColumn(column);
        }
        return new Change[]{createTableChange};
    }

    @Override
    public void checkDiffResult(DiffResult diffResult, CreateIndexChange change) {
        Index example = new Index(change.getIndexName(), change.getCatalogName(), change.getSchemaName(), change.getTableName(), new String[0]);
        ArrayList<String> columns = null;
        if (change.getColumns() != null) {
            columns = new ArrayList<String>();
            for (AddColumnConfig col : change.getColumns()) {
                columns.add(col.getName());
            }
            example.setColumns(StringUtils.join(columns, ","));
        }
        Assert.assertNotNull((Object)diffResult.getUnexpectedObject(example));
    }
}

