/*
 * Decompiled with CFR 0.152.
 */
package liquibase.sqlgenerator.core;

import java.util.Iterator;
import java.util.LinkedList;
import liquibase.database.Database;
import liquibase.database.core.InformixDatabase;
import liquibase.logging.LogFactory;
import liquibase.sql.Sql;
import liquibase.sql.UnparsedSql;
import liquibase.sqlgenerator.SqlGeneratorChain;
import liquibase.sqlgenerator.core.CreateTableGenerator;
import liquibase.statement.AutoIncrementConstraint;
import liquibase.statement.ForeignKeyConstraint;
import liquibase.statement.UniqueConstraint;
import liquibase.statement.core.CreateTableStatement;
import liquibase.structure.core.Schema;
import liquibase.structure.core.Table;
import liquibase.util.StringUtils;

public class CreateTableGeneratorInformix
extends CreateTableGenerator {
    @Override
    public boolean supports(CreateTableStatement statement, Database database) {
        return database instanceof InformixDatabase;
    }

    @Override
    public int getPriority() {
        return 5;
    }

    @Override
    public Sql[] generateSql(CreateTableStatement statement, Database database, SqlGeneratorChain sqlGeneratorChain) {
        StringBuilder buffer = new StringBuilder();
        buffer.append("CREATE TABLE ").append(database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName())).append(" ");
        buffer.append("(");
        boolean isSinglePrimaryKeyColumn = statement.getPrimaryKeyConstraint() != null && statement.getPrimaryKeyConstraint().getColumns().size() == 1;
        boolean isPrimaryKeyAutoIncrement = false;
        Iterator<String> columnIterator = statement.getColumns().iterator();
        LinkedList<String> primaryKeyColumns = new LinkedList<String>();
        while (columnIterator.hasNext()) {
            String column = columnIterator.next();
            buffer.append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), column));
            buffer.append(" ").append(statement.getColumnTypes().get(column).toDatabaseDataType(database).toSql());
            AutoIncrementConstraint autoIncrementConstraint = null;
            for (AutoIncrementConstraint currentAutoIncrementConstraint : statement.getAutoIncrementConstraints()) {
                if (!column.equals(currentAutoIncrementConstraint.getColumnName())) continue;
                autoIncrementConstraint = currentAutoIncrementConstraint;
                break;
            }
            boolean isAutoIncrementColumn = autoIncrementConstraint != null;
            boolean isPrimaryKeyColumn = statement.getPrimaryKeyConstraint() != null && statement.getPrimaryKeyConstraint().getColumns().contains(column);
            boolean bl = isPrimaryKeyAutoIncrement = isPrimaryKeyAutoIncrement || isPrimaryKeyColumn && isAutoIncrementColumn;
            if (isPrimaryKeyColumn) {
                primaryKeyColumns.add(column);
            }
            if (statement.getDefaultValue(column) != null) {
                Object defaultValue = statement.getDefaultValue(column);
                buffer.append(" DEFAULT ");
                buffer.append(statement.getColumnTypes().get(column).objectToSql(defaultValue, database));
            }
            if (isAutoIncrementColumn) {
                if (database.supportsAutoIncrement()) {
                    String autoIncrementClause = database.getAutoIncrementClause(autoIncrementConstraint.getStartWith(), autoIncrementConstraint.getIncrementBy());
                    if (autoIncrementClause.length() > 0) {
                        buffer.append(" ").append(autoIncrementClause);
                    }
                } else {
                    LogFactory.getLogger().warning(database.getShortName() + " does not support autoincrement columns as requested for " + database.escapeTableName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName()));
                }
            }
            if (statement.getNotNullColumns().contains(column)) {
                buffer.append(" NOT NULL");
            }
            if (!columnIterator.hasNext()) continue;
            buffer.append(", ");
        }
        buffer.append(",");
        if (!(isSinglePrimaryKeyColumn && isPrimaryKeyAutoIncrement && isSinglePrimaryKeyColumn || statement.getPrimaryKeyConstraint() == null || statement.getPrimaryKeyConstraint().getColumns().size() <= 0)) {
            buffer.append(" PRIMARY KEY (");
            buffer.append(StringUtils.join(primaryKeyColumns, ", "));
            buffer.append(")");
            buffer.append(",");
        }
        for (ForeignKeyConstraint fkConstraint : statement.getForeignKeyConstraints()) {
            String referencesString = fkConstraint.getReferences();
            if (!referencesString.contains(".") && database.getDefaultSchemaName() != null) {
                referencesString = database.getDefaultSchemaName() + "." + referencesString;
            }
            buffer.append(" FOREIGN KEY (").append(database.escapeColumnName(statement.getCatalogName(), statement.getSchemaName(), statement.getTableName(), fkConstraint.getColumn())).append(") REFERENCES ").append(referencesString);
            if (fkConstraint.isDeleteCascade()) {
                buffer.append(" ON DELETE CASCADE");
            }
            buffer.append(" CONSTRAINT ");
            buffer.append(database.escapeConstraintName(fkConstraint.getForeignKeyName()));
            if (fkConstraint.isInitiallyDeferred()) {
                buffer.append(" INITIALLY DEFERRED");
            }
            if (fkConstraint.isDeferrable()) {
                buffer.append(" DEFERRABLE");
            }
            buffer.append(",");
        }
        for (UniqueConstraint uniqueConstraint : statement.getUniqueConstraints()) {
            if (uniqueConstraint.getConstraintName() != null && !this.constraintNameAfterUnique(database)) {
                buffer.append(" CONSTRAINT ");
                buffer.append(database.escapeConstraintName(uniqueConstraint.getConstraintName()));
            }
            buffer.append(" UNIQUE (");
            buffer.append(database.escapeColumnNameList(StringUtils.join(uniqueConstraint.getColumns(), ", ")));
            buffer.append(")");
            if (uniqueConstraint.getConstraintName() != null && this.constraintNameAfterUnique(database)) {
                buffer.append(" CONSTRAINT ");
                buffer.append(database.escapeConstraintName(uniqueConstraint.getConstraintName()));
            }
            buffer.append(",");
        }
        String sql = buffer.toString().replaceFirst(",\\s*$", "") + ")";
        if (statement.getTablespace() != null && database.supportsTablespaces()) {
            sql = sql + " IN " + statement.getTablespace();
        }
        return new Sql[]{new UnparsedSql(sql, new Table().setName(statement.getTableName()).setSchema(new Schema(statement.getCatalogName(), statement.getSchemaName())))};
    }

    private boolean constraintNameAfterUnique(Database database) {
        return true;
    }
}

