/*
 * Decompiled with CFR 0.152.
 */
package com.datical.liquibase.ext.checks.config.model;

import com.datical.liquibase.ext.checks.config.DynamicRuleParameterEnum;
import com.datical.liquibase.ext.checks.config.model.AbstractConfigurableRule;
import com.datical.liquibase.ext.checks.config.model.DynamicRuleParameter;
import com.datical.liquibase.ext.rules.api.SeverityEnum;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import liquibase.util.StringUtil;

public class DynamicRule
extends AbstractConfigurableRule {
    private String shortName;
    private String name;
    private String description;
    private UUID parentRuleId;
    private List<DynamicRuleParameter> parameters;

    public DynamicRule() {
    }

    public DynamicRule(boolean bl2, SeverityEnum severityEnum, UUID uUID, String string, String string2, String string3, UUID uUID2, List<DynamicRuleParameter> list) {
        super(bl2, severityEnum, uUID);
        this.shortName = string;
        this.name = string2;
        this.description = string3;
        this.parentRuleId = uUID2;
        this.parameters = list;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void setShortName(String string) {
        this.shortName = string;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public UUID getParentRuleId() {
        return this.parentRuleId;
    }

    public void setParentRuleId(UUID uUID) {
        this.parentRuleId = uUID;
    }

    public List<DynamicRuleParameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<DynamicRuleParameter> list) {
        this.parameters = list;
    }

    public DynamicRuleParameter getParameter(DynamicRuleParameterEnum dynamicRuleParameterEnum) {
        for (DynamicRuleParameter dynamicRuleParameter : this.getParameters()) {
            if (!dynamicRuleParameter.getParameter().equals((Object)dynamicRuleParameterEnum)) continue;
            return dynamicRuleParameter;
        }
        return null;
    }

    public String prettyPrintParameters() {
        if (this.parameters != null && !this.parameters.isEmpty()) {
            return StringUtil.join(this.parameters.stream().map(dynamicRuleParameter -> dynamicRuleParameter.getParameter().toString() + " = " + dynamicRuleParameter.getValue()).collect(Collectors.toList()), System.lineSeparator());
        }
        return "<None>";
    }

    public boolean isCopy() {
        return this.getParentRuleId() != null;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        if (!super.equals(object)) {
            return false;
        }
        object = (DynamicRule)object;
        return this.shortName.equals(((DynamicRule)object).shortName) && this.name.equals(((DynamicRule)object).name) && this.description.equals(((DynamicRule)object).description) && Objects.equals(this.parentRuleId, ((DynamicRule)object).parentRuleId) && Objects.equals(this.parameters, ((DynamicRule)object).parameters);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.shortName, this.name, this.description, this.parentRuleId, this.parameters);
    }
}

