/*
 * Decompiled with CFR 0.152.
 */
package org.liquibase.maven.plugins;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import liquibase.Contexts;
import liquibase.LabelExpression;
import liquibase.Liquibase;
import liquibase.database.Database;
import liquibase.exception.LiquibaseException;
import liquibase.util.StringUtil;
import org.apache.maven.plugin.MojoExecutionException;
import org.liquibase.maven.plugins.AbstractLiquibaseUpdateMojo;
import org.liquibase.maven.property.PropertyElement;

public class LiquibaseUpdateSQL
extends AbstractLiquibaseUpdateMojo {
    @PropertyElement
    protected File migrationSqlOutputFile;
    private Writer outputWriter;

    @Override
    protected void doUpdate(Liquibase liquibase) throws LiquibaseException {
        if (this.changesToApply > 0) {
            liquibase.updateCountSql(this.changesToApply, new Contexts(this.contexts), new LabelExpression(this.getLabelFilter()), this.outputWriter);
        } else if (StringUtil.isNotEmpty((String)this.toTag)) {
            liquibase.updateToTagSql(this.toTag, new Contexts(this.contexts), new LabelExpression(this.getLabelFilter()), this.outputWriter);
        } else {
            liquibase.updateSql(new Contexts(this.contexts), new LabelExpression(this.getLabelFilter()), this.outputWriter);
        }
    }

    @Override
    protected Liquibase createLiquibase(Database db) throws MojoExecutionException {
        Liquibase liquibase = super.createLiquibase(db);
        try {
            if (!this.migrationSqlOutputFile.exists()) {
                this.migrationSqlOutputFile.getParentFile().mkdirs();
                if (!this.migrationSqlOutputFile.createNewFile()) {
                    throw new MojoExecutionException("Cannot create the migration SQL file; " + this.migrationSqlOutputFile.getAbsolutePath());
                }
            }
            this.outputWriter = this.getOutputWriter(this.migrationSqlOutputFile);
        }
        catch (IOException e) {
            this.getLog().error((Throwable)e);
            throw new MojoExecutionException("Failed to create SQL output writer", (Exception)e);
        }
        this.getLog().info((CharSequence)("Output SQL Migration File: " + this.migrationSqlOutputFile.getAbsolutePath()));
        return liquibase;
    }

    @Override
    protected void printSettings(String indent) {
        super.printSettings(indent);
        this.getLog().info((CharSequence)(indent + "migrationSQLOutputFile: " + this.migrationSqlOutputFile));
    }

    @Override
    protected void cleanup(Database db) {
        super.cleanup(db);
        if (this.outputWriter != null) {
            try {
                this.outputWriter.close();
            }
            catch (IOException e) {
                this.getLog().error((Throwable)e);
            }
        }
    }
}

