/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.TypeName;
import java.io.IOException;
import java.io.Writer;
import java.time.Clock;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.mapstruct.extensions.spring.SpringMapperConfig;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterDescriptor;
import org.mapstruct.extensions.spring.converter.ConversionServiceAdapterGenerator;

@SupportedAnnotationTypes(value={"org.mapstruct.Mapper", "org.mapstruct.extensions.spring.SpringMapperConfig"})
public class ConverterMapperProcessor
extends AbstractProcessor {
    protected static final String MAPPER = "org.mapstruct.Mapper";
    protected static final String SPRING_MAPPER_CONFIG = "org.mapstruct.extensions.spring.SpringMapperConfig";
    protected static final String SPRING_CONVERTER_FULL_NAME = "org.springframework.core.convert.converter.Converter";
    private final ConversionServiceAdapterGenerator adapterGenerator;

    public ConverterMapperProcessor() {
        this(new ConversionServiceAdapterGenerator(Clock.systemUTC()));
    }

    ConverterMapperProcessor(ConversionServiceAdapterGenerator adapterGenerator) {
        this.adapterGenerator = adapterGenerator;
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ConversionServiceAdapterDescriptor descriptor = new ConversionServiceAdapterDescriptor();
        Pair<String, String> adapterPackageAndClass = this.getAdapterPackageAndClassName(annotations, roundEnv);
        descriptor.setAdapterClassName(ClassName.get((String)((String)adapterPackageAndClass.getLeft()), (String)((String)adapterPackageAndClass.getRight()), (String[])new String[0]));
        descriptor.setConversionServiceBeanName(this.getConversionServiceName(annotations, roundEnv));
        descriptor.setLazyAnnotatedConversionServiceBean(this.getLazyAnnotatedConversionServiceBean(annotations, roundEnv));
        annotations.stream().filter(this::isMapperAnnotation).forEach(annotation -> this.processMapperAnnotation(roundEnv, descriptor, adapterPackageAndClass, (TypeElement)annotation));
        return false;
    }

    private boolean isMapperAnnotation(TypeElement annotation) {
        return MAPPER.contentEquals(annotation.getQualifiedName());
    }

    private void processMapperAnnotation(RoundEnvironment roundEnv, ConversionServiceAdapterDescriptor descriptor, Pair<String, String> adapterPackageAndClass, TypeElement annotation) {
        List<Pair<TypeName, TypeName>> fromToMappings = roundEnv.getElementsAnnotatedWith(annotation).stream().filter(this::isKindDeclared).filter(this::hasConverterSupertype).map(this::toConvertMethod).filter(Objects::nonNull).map(ExecutableElement.class::cast).map(this::toFromToMapping).collect(Collectors.toList());
        descriptor.setFromToMappings(fromToMappings);
        this.writeAdapterClassFile(descriptor, adapterPackageAndClass);
    }

    private boolean hasConverterSupertype(Element mapper) {
        return this.getConverterSupertype(mapper).isPresent();
    }

    private boolean isKindDeclared(Element mapper) {
        return mapper.asType().getKind() == TypeKind.DECLARED;
    }

    private Pair<TypeName, TypeName> toFromToMapping(ExecutableElement convert) {
        return Pair.of((Object)convert.getParameters().stream().map(Element::asType).map(TypeName::get).findFirst().orElseThrow(NoSuchElementException::new), (Object)TypeName.get((TypeMirror)convert.getReturnType()));
    }

    private Element toConvertMethod(Element mapper) {
        return mapper.getEnclosedElements().stream().filter(element -> element.getKind() == ElementKind.METHOD).filter(method -> method.getModifiers().contains((Object)Modifier.PUBLIC)).filter(method -> method.getSimpleName().contentEquals("convert")).filter(convert -> ((ExecutableElement)convert).getParameters().size() == 1).filter(convert -> this.processingEnv.getTypeUtils().isSameType(ConverterMapperProcessor.getFirstParameterType((ExecutableElement)convert), ConverterMapperProcessor.getFirstTypeArgument(this.getConverterSupertype(mapper).get()))).findFirst().orElse(null);
    }

    private void writeAdapterClassFile(ConversionServiceAdapterDescriptor descriptor, Pair<String, String> adapterPackageAndClass) {
        try (Writer outputWriter = this.processingEnv.getFiler().createSourceFile((String)adapterPackageAndClass.getLeft() + "." + (String)adapterPackageAndClass.getRight(), new Element[0]).openWriter();){
            this.adapterGenerator.writeConversionServiceAdapter(descriptor, outputWriter);
        }
        catch (IOException e) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Error while opening " + (String)adapterPackageAndClass.getRight() + " output file: " + e.getMessage());
        }
    }

    private Pair<String, String> getAdapterPackageAndClassName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        MutablePair packageAndClass = MutablePair.of((Object)ConverterMapperProcessor.class.getPackage().getName(), (Object)"ConversionServiceAdapter");
        for (TypeElement typeElement : annotations) {
            if (!SPRING_MAPPER_CONFIG.contentEquals(typeElement.getQualifiedName())) continue;
            roundEnv.getElementsAnnotatedWith(typeElement).forEach(element -> this.updateFromDeclaration((Element)element, (MutablePair<String, String>)packageAndClass));
        }
        return packageAndClass;
    }

    private void updateFromDeclaration(Element element, MutablePair<String, String> adapterPackageAndClass) {
        SpringMapperConfig springMapperConfig = element.getAnnotation(SpringMapperConfig.class);
        adapterPackageAndClass.setLeft((Object)Optional.of(springMapperConfig.conversionServiceAdapterPackage()).filter(StringUtils::isNotBlank).orElse(String.valueOf(this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName())));
        adapterPackageAndClass.setRight((Object)springMapperConfig.conversionServiceAdapterClassName());
    }

    private String getConversionServiceName(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(annotation -> SPRING_MAPPER_CONFIG.contentEquals(annotation.getQualifiedName())).findFirst().flatMap(annotation -> this.findFirstElementAnnotatedWith(roundEnv, (TypeElement)annotation)).map(this::toSpringMapperConfig).map(SpringMapperConfig::conversionServiceBeanName).orElse(null);
    }

    private Optional<? extends Element> findFirstElementAnnotatedWith(RoundEnvironment roundEnv, TypeElement annotation) {
        return roundEnv.getElementsAnnotatedWith(annotation).stream().findFirst();
    }

    private SpringMapperConfig toSpringMapperConfig(Element element) {
        return element.getAnnotation(SpringMapperConfig.class);
    }

    private boolean getLazyAnnotatedConversionServiceBean(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        return annotations.stream().filter(annotation -> SPRING_MAPPER_CONFIG.contentEquals(annotation.getQualifiedName())).findFirst().flatMap(annotation -> this.findFirstElementAnnotatedWith(roundEnv, (TypeElement)annotation)).map(this::toSpringMapperConfig).map(SpringMapperConfig::lazyAnnotatedConversionServiceBean).orElse(Boolean.TRUE);
    }

    private Optional<? extends TypeMirror> getConverterSupertype(Element mapper) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        return typeUtils.directSupertypes(mapper.asType()).stream().filter(supertype -> typeUtils.erasure((TypeMirror)supertype).toString().equals(SPRING_CONVERTER_FULL_NAME)).findFirst();
    }

    private static TypeMirror getFirstParameterType(ExecutableElement convert) {
        return convert.getParameters().stream().findFirst().map(Element::asType).orElse(null);
    }

    private static TypeMirror getFirstTypeArgument(TypeMirror converterSupertype) {
        return ((DeclaredType)converterSupertype).getTypeArguments().stream().findFirst().orElse(null);
    }
}

