/*
 * Decompiled with CFR 0.152.
 */
package org.mapstruct.extensions.spring.converter;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.Writer;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.time.Clock;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.SourceVersion;
import org.mapstruct.extensions.spring.converter.TypeNameUtils;

public abstract class Generator {
    protected static final String GENERATED_ANNOTATION_CLASS_NAME_STRING = "Generated";
    protected static final String PRE_JAVA_9_ANNOTATION_GENERATED_PACKAGE = "javax.annotation";
    protected static final String JAVA_9_PLUS_ANNOTATION_GENERATED_PACKAGE = "javax.annotation.processing";
    protected static final AnnotationSpec TARGET_TYPE_ANNOTATION_SPEC = AnnotationSpec.builder(Target.class).addMember("value", "$L", new Object[]{ElementType.TYPE}).build();
    protected static final AnnotationSpec RETENTION_RUNTIME_ANNOTATION_SPEC = AnnotationSpec.builder(Retention.class).addMember("value", "$L", new Object[]{RetentionPolicy.RUNTIME}).build();
    protected static final String SPRING_CONTEXT_ANNOTATION_PACKAGE_NAME = "org.springframework.context.annotation";
    protected static final ClassName CONVERTER_CLASSNAME = ClassName.get((String)"org.springframework.core.convert.converter", (String)"Converter", (String[])new String[0]);
    private static final String PRE_JAVA_9_ANNOTATION_GENERATED = String.format("%s.%s", "javax.annotation", "Generated");
    private static final String JAVA_9_PLUS_ANNOTATION_GENERATED = String.format("%s.%s", "javax.annotation.processing", "Generated");
    private static final ClassName PRE_JAVA_9_ANNOTATION_GENERATED_CLASS_NAME = ClassName.get((String)"javax.annotation", (String)"Generated", (String[])new String[0]);
    private static final ClassName JAVA_9_PLUS_ANNOTATION_GENERATED_CLASS_NAME = ClassName.get((String)"javax.annotation.processing", (String)"Generated", (String[])new String[0]);
    private static final String SUPPRESS_GENERATOR_TIMESTAMP = "mapstruct.suppressGeneratorTimestamp";
    private final Clock clock;
    private final AtomicReference<ProcessingEnvironment> processingEnvironment;

    protected Generator(Clock clock) {
        this.clock = clock;
        this.processingEnvironment = new AtomicReference();
    }

    protected final ProcessingEnvironment getProcessingEnvironment() {
        return this.processingEnvironment.get();
    }

    public final void init(ProcessingEnvironment processingEnv) {
        if (!this.processingEnvironment.compareAndSet(null, processingEnv)) {
            throw new IllegalStateException("ProcessingEnvironment already set.");
        }
    }

    protected final Clock getClock() {
        return this.clock;
    }

    protected final boolean isPreJava9GeneratedAvailable() {
        return this.isTypeAvailable(PRE_JAVA_9_ANNOTATION_GENERATED);
    }

    protected final boolean isJava9PlusGeneratedAvailable() {
        return this.isSourceVersionAtLeast9() && this.isTypeAvailable(JAVA_9_PLUS_ANNOTATION_GENERATED);
    }

    private boolean isSourceVersionAtLeast9() {
        return this.getProcessingEnvironment().getSourceVersion().compareTo(SourceVersion.RELEASE_8) > 0;
    }

    protected boolean isTypeAvailable(String name) {
        return this.getProcessingEnvironment().getElementUtils().getTypeElement(name) != null;
    }

    protected final AnnotationSpec buildGeneratedAnnotationSpec() {
        return Optional.ofNullable(this.baseGeneratedAnnotationSpecBuilder()).map(build -> build.addMember("value", "$S", new Object[]{this.getClass().getName()})).map(this::addDateIfNotSuppressed).map(AnnotationSpec.Builder::build).orElse(null);
    }

    private AnnotationSpec.Builder addDateIfNotSuppressed(AnnotationSpec.Builder generatedAnnotationSpecBuilder) {
        return Boolean.parseBoolean(this.getProcessingEnvironment().getOptions().get(SUPPRESS_GENERATOR_TIMESTAMP)) ? generatedAnnotationSpecBuilder : generatedAnnotationSpecBuilder.addMember("date", "$S", new Object[]{DateTimeFormatter.ISO_INSTANT.format(ZonedDateTime.now(this.getClock()))});
    }

    private AnnotationSpec.Builder baseGeneratedAnnotationSpecBuilder() {
        Object builder = this.isJava9PlusGeneratedAvailable() ? AnnotationSpec.builder((ClassName)JAVA_9_PLUS_ANNOTATION_GENERATED_CLASS_NAME) : (this.isPreJava9GeneratedAvailable() ? AnnotationSpec.builder((ClassName)PRE_JAVA_9_ANNOTATION_GENERATED_CLASS_NAME) : null);
        return builder;
    }

    protected JavaFile.Builder modifyDefaultFileBuilder(JavaFile.Builder javaFileBuilder) {
        return javaFileBuilder;
    }

    protected final void writeGeneratedCodeToOutput(Supplier<String> packageNameSupplier, Supplier<TypeSpec> mainTypeSpecSupplier, Writer out) {
        try {
            JavaFile.Builder javaFileBuilder = JavaFile.builder((String)packageNameSupplier.get(), (TypeSpec)mainTypeSpecSupplier.get()).skipJavaLangImports(true);
            this.modifyDefaultFileBuilder(javaFileBuilder).build().writeTo((Appendable)out);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    protected final boolean isCollectionWithGenericParameter(ParameterizedTypeName parameterizedTypeName) {
        return TypeNameUtils.isCollectionWithGenericParameter(this.getProcessingEnvironment(), parameterizedTypeName);
    }

    protected final String collectionOfNameIfApplicable(TypeName typeName) {
        return TypeNameUtils.collectionOfNameIfApplicable(this.getProcessingEnvironment(), typeName);
    }
}

