package org.mapstruct.ap.internal.gem;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.AbstractAnnotationValueVisitor8;
import javax.lang.model.util.ElementFilter;
import org.mapstruct.tools.gem.Gem;
import org.mapstruct.tools.gem.GemValue;

import javax.lang.model.type.TypeMirror;

public class SubclassMappingGem implements Gem {

    private final GemValue<TypeMirror> source;
    private final GemValue<TypeMirror> target;
    private final GemValue<List<TypeMirror>> qualifiedBy;
    private final GemValue<List<String>> qualifiedByName;
    private final boolean isValid;
    private final AnnotationMirror mirror;

    private SubclassMappingGem( BuilderImpl builder ) {
        this.source = builder.source;
        this.target = builder.target;
        this.qualifiedBy = builder.qualifiedBy;
        this.qualifiedByName = builder.qualifiedByName;
        isValid = ( this.source != null ? this.source.isValid() : false )
               && ( this.target != null ? this.target.isValid() : false )
               && ( this.qualifiedBy != null ? this.qualifiedBy.isValid() : false )
               && ( this.qualifiedByName != null ? this.qualifiedByName.isValid() : false );
        mirror = builder.mirror;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link SubclassMappingGem#source}
    */
    public GemValue<TypeMirror> source( ) {
        return source;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link SubclassMappingGem#target}
    */
    public GemValue<TypeMirror> target( ) {
        return target;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link SubclassMappingGem#qualifiedBy}
    */
    public GemValue<List<TypeMirror>> qualifiedBy( ) {
        return qualifiedBy;
    }

    /**
    * accessor
    *
    * @return the {@link GemValue} for {@link SubclassMappingGem#qualifiedByName}
    */
    public GemValue<List<String>> qualifiedByName( ) {
        return qualifiedByName;
    }

    @Override
    public AnnotationMirror mirror( ) {
        return mirror;
    }

    @Override
    public boolean isValid( ) {
        return isValid;
    }

    public static SubclassMappingGem  instanceOn(Element element) {
        return build( element, new BuilderImpl() );
    }

    public static SubclassMappingGem instanceOn(AnnotationMirror mirror ) {
        return build( mirror, new BuilderImpl() );
    }

    public static  <T> T  build(Element element, Builder<T> builder) {
        AnnotationMirror mirror = element.getAnnotationMirrors().stream()
            .filter( a ->  "org.mapstruct.SubclassMapping".contentEquals( ( ( TypeElement )a.getAnnotationType().asElement() ).getQualifiedName() ) )
            .findAny()
            .orElse( null );
        return build( mirror, builder );
    }

    public static <T> T build(AnnotationMirror mirror, Builder<T> builder ) {

        // return fast
        if ( mirror == null || builder == null ) {
            return null;
        }

        // fetch defaults from all defined values in the annotation type
        List<ExecutableElement> enclosed = ElementFilter.methodsIn( mirror.getAnnotationType().asElement().getEnclosedElements() );
        Map<String, AnnotationValue> defaultValues = new HashMap<>( enclosed.size() );
        enclosed.forEach( e -> defaultValues.put( e.getSimpleName().toString(), e.getDefaultValue() ) );

        // fetch all explicitely set annotation values in the annotation instance
        Map<String, AnnotationValue> values = new HashMap<>( enclosed.size() );
        mirror.getElementValues().entrySet().forEach( e -> values.put( e.getKey().getSimpleName().toString(), e.getValue() ) );

        // iterate and populate builder
        for ( String methodName : defaultValues.keySet() ) {

            if ( "source".equals( methodName ) ) {
                builder.setSource( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "target".equals( methodName ) ) {
                builder.setTarget( GemValue.create( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "qualifiedBy".equals( methodName ) ) {
                builder.setQualifiedby( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), TypeMirror.class ) );
            }
            else if ( "qualifiedByName".equals( methodName ) ) {
                builder.setQualifiedbyname( GemValue.createArray( values.get( methodName ), defaultValues.get( methodName ), String.class ) );
            }
        }
        builder.setMirror( mirror );
        return builder.build();
    }

    /**
     * A builder that can be implemented by the user to define custom logic e.g. in the
     * build method, prior to creating the annotation gem.
     */
    public interface Builder<T> {

       /**
        * Sets the {@link GemValue} for {@link SubclassMappingGem#source}
        *
        * @return the {@link Builder} for this gem, representing {@link SubclassMappingGem}
        */
        Builder setSource(GemValue<TypeMirror> methodName );

       /**
        * Sets the {@link GemValue} for {@link SubclassMappingGem#target}
        *
        * @return the {@link Builder} for this gem, representing {@link SubclassMappingGem}
        */
        Builder setTarget(GemValue<TypeMirror> methodName );

       /**
        * Sets the {@link GemValue} for {@link SubclassMappingGem#qualifiedBy}
        *
        * @return the {@link Builder} for this gem, representing {@link SubclassMappingGem}
        */
        Builder setQualifiedby(GemValue<List<TypeMirror>> methodName );

       /**
        * Sets the {@link GemValue} for {@link SubclassMappingGem#qualifiedByName}
        *
        * @return the {@link Builder} for this gem, representing {@link SubclassMappingGem}
        */
        Builder setQualifiedbyname(GemValue<List<String>> methodName );

        /**
         * Sets the annotation mirror
         *
         * @param mirror the mirror which this gem represents
         *
         * @return the {@link Builder} for this gem, representing {@link SubclassMappingGem}
         */
          Builder setMirror( AnnotationMirror mirror );

        /**
         * The build method can be overriden in a custom custom implementation, which allows
         * the user to define his own custom validation on the annotation.
         *
         * @return the representation of the annotation
         */
        T build();
    }

    private static class BuilderImpl implements Builder<SubclassMappingGem> {

        private GemValue<TypeMirror> source;
        private GemValue<TypeMirror> target;
        private GemValue<List<TypeMirror>> qualifiedBy;
        private GemValue<List<String>> qualifiedByName;
        private AnnotationMirror mirror;

        public Builder setSource(GemValue<TypeMirror> source ) {
            this.source = source;
            return this;
        }

        public Builder setTarget(GemValue<TypeMirror> target ) {
            this.target = target;
            return this;
        }

        public Builder setQualifiedby(GemValue<List<TypeMirror>> qualifiedBy ) {
            this.qualifiedBy = qualifiedBy;
            return this;
        }

        public Builder setQualifiedbyname(GemValue<List<String>> qualifiedByName ) {
            this.qualifiedByName = qualifiedByName;
            return this;
        }

        public Builder  setMirror( AnnotationMirror mirror ) {
            this.mirror = mirror;
            return this;
        }

        public SubclassMappingGem build() {
            return new SubclassMappingGem( this );
        }
    }

}
