/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.packet.result;

import java.nio.ByteBuffer;

public abstract class AbstractResultPacket {
    ByteBuffer byteBuffer;

    public AbstractResultPacket(ByteBuffer byteBuffer) {
        this.byteBuffer = byteBuffer;
    }

    public abstract ResultType getResultType();

    public long getLengthEncodedBinary() {
        int type = this.byteBuffer.get() & 0xFF;
        switch (type) {
            case 252: {
                return 0xFFFFL & (long)this.byteBuffer.getShort();
            }
            case 253: {
                return 0xFFFFFF & this.read24bitword();
            }
            case 254: {
                return this.byteBuffer.getLong();
            }
            case 255: {
                return -1L;
            }
        }
        return type;
    }

    public byte[] getLengthEncodedBytes() {
        if (this.byteBuffer.remaining() == 0) {
            return new byte[0];
        }
        long encLength = this.getLengthEncodedBinary();
        if (encLength == -1L) {
            return null;
        }
        byte[] tmpBuf = new byte[(int)encLength];
        this.byteBuffer.get(tmpBuf);
        return tmpBuf;
    }

    public String getStringLengthEncodedBytes() {
        if (this.byteBuffer.remaining() == 0) {
            return null;
        }
        long encLength = this.getLengthEncodedBinary();
        if (encLength == 0L) {
            return "";
        }
        if (encLength != -1L) {
            byte[] tmpBuf = new byte[(int)encLength];
            this.byteBuffer.get(tmpBuf);
            return new String(tmpBuf);
        }
        return null;
    }

    public short readShort() {
        return this.byteBuffer.getShort();
    }

    public int read24bitword() {
        byte[] tmpArr = new byte[3];
        this.byteBuffer.get(tmpArr);
        return (tmpArr[0] & 0xFF) + ((tmpArr[1] & 0xFF) << 8) + ((tmpArr[2] & 0xFF) << 16);
    }

    public long readLong() {
        return this.byteBuffer.getLong();
    }

    public static enum ResultType {
        OK,
        ERROR,
        EOF,
        RESULTSET,
        LOCALINFILE,
        FIELD;

    }
}

