/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.jdbc.internal.util;

import com.sun.jna.Library;
import com.sun.jna.Native;
import com.sun.jna.Platform;
import com.sun.jna.platform.win32.Kernel32;

public class PidFactory {
    private static PidRequestInter pidRequest = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PidRequestInter getInstance() {
        if (pidRequest != null) return pidRequest;
        Class<PidFactory> clazz = PidFactory.class;
        synchronized (PidFactory.class) {
            if (pidRequest != null) return pidRequest;
            try {
                if (Platform.isLinux()) {
                    pidRequest = new PidRequestInter(){

                        @Override
                        public String getPid() {
                            return String.valueOf(CLibrary.INSTANCE.getpid());
                        }
                    };
                } else if (Platform.isWindows()) {
                    pidRequest = new PidRequestInter(){

                        @Override
                        public String getPid() {
                            try {
                                return String.valueOf(Kernel32.INSTANCE.GetCurrentProcessId());
                            }
                            catch (Throwable throwable) {
                                return null;
                            }
                        }
                    };
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            if (pidRequest != null) return pidRequest;
            pidRequest = new PidRequestInter(){

                @Override
                public String getPid() {
                    return null;
                }
            };
            // ** MonitorExit[var0] (shouldn't be in output)
            return pidRequest;
        }
    }

    private static interface CLibrary
    extends Library {
        public static final CLibrary INSTANCE = (CLibrary)Native.loadLibrary((String)"c", CLibrary.class);

        public int getpid();
    }

    public static interface PidRequestInter {
        public String getPid();
    }
}

