/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

import io.netty.handler.ssl.SslContextBuilder;
import io.r2dbc.spi.ConnectionFactoryOptions;
import io.r2dbc.spi.IsolationLevel;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.mariadb.r2dbc.HaMode;
import org.mariadb.r2dbc.MariadbConnectionFactoryProvider;
import org.mariadb.r2dbc.SslMode;
import org.mariadb.r2dbc.util.Assert;
import org.mariadb.r2dbc.util.HostAddress;
import org.mariadb.r2dbc.util.SslConfig;
import reactor.netty.resources.LoopResources;
import reactor.netty.tcp.TcpResources;
import reactor.util.annotation.Nullable;

public final class MariadbConnectionConfiguration {
    public static final int DEFAULT_PORT = 3306;
    private final String database;
    private final List<HostAddress> hostAddresses;
    private final HaMode haMode;
    private final Duration connectTimeout;
    private final boolean tcpKeepAlive;
    private final boolean tcpAbortiveClose;
    private final boolean transactionReplay;
    private final CharSequence password;
    private final CharSequence[] pamOtherPwd;
    private final int port;
    private final int prepareCacheSize;
    private final String socket;
    private final String username;
    private final boolean allowMultiQueries;
    private final boolean allowPipelining;
    private final Map<String, String> connectionAttributes;
    private final Map<String, String> sessionVariables;
    private final SslConfig sslConfig;
    private final String rsaPublicKey;
    private final String cachingRsaPublicKey;
    private final boolean allowPublicKeyRetrieval;
    private IsolationLevel isolationLevel;
    private final boolean useServerPrepStmts;
    private final boolean autocommit;
    private final boolean tinyInt1isBit;
    private final String[] restrictedAuth;
    private final LoopResources loopResources;
    private final UnaryOperator<SslContextBuilder> sslContextBuilderCustomizer;

    private MariadbConnectionConfiguration(String haMode, @Nullable Duration connectTimeout, @Nullable Boolean tcpKeepAlive, @Nullable Boolean tcpAbortiveClose, @Nullable Boolean transactionReplay, @Nullable String database, @Nullable String host, @Nullable Map<String, String> connectionAttributes, @Nullable Map<String, String> sessionVariables, @Nullable CharSequence password, int port, @Nullable List<HostAddress> hostAddresses, @Nullable String socket, @Nullable String username, boolean allowMultiQueries, boolean allowPipelining, @Nullable List<String> tlsProtocol, @Nullable String serverSslCert, @Nullable String clientSslCert, @Nullable String clientSslKey, @Nullable CharSequence clientSslPassword, SslMode sslMode, @Nullable String rsaPublicKey, @Nullable String cachingRsaPublicKey, boolean allowPublicKeyRetrieval, boolean useServerPrepStmts, IsolationLevel isolationLevel, boolean autocommit, @Nullable Integer prepareCacheSize, @Nullable CharSequence[] pamOtherPwd, boolean tinyInt1isBit, String restrictedAuth, @Nullable LoopResources loopResources, @Nullable UnaryOperator<SslContextBuilder> sslContextBuilderCustomizer, boolean sslTunnelDisableHostVerification) {
        this.haMode = haMode == null ? HaMode.NONE : HaMode.from(haMode);
        this.connectTimeout = connectTimeout == null ? Duration.ofSeconds(10L) : connectTimeout;
        this.tcpKeepAlive = tcpKeepAlive == null ? Boolean.FALSE : tcpKeepAlive;
        this.tcpAbortiveClose = tcpAbortiveClose == null ? Boolean.FALSE : tcpAbortiveClose;
        this.transactionReplay = transactionReplay == null ? Boolean.FALSE : transactionReplay;
        this.database = database != null && !database.isEmpty() ? database : null;
        this.isolationLevel = isolationLevel;
        this.restrictedAuth = restrictedAuth != null ? restrictedAuth.split(",") : null;
        this.hostAddresses = hostAddresses != null ? hostAddresses : HostAddress.parse(host, port);
        this.connectionAttributes = connectionAttributes;
        this.sessionVariables = sessionVariables;
        this.password = password != null && !password.toString().isEmpty() ? password : null;
        this.port = port;
        this.socket = socket;
        this.username = username;
        this.allowMultiQueries = allowMultiQueries;
        this.allowPipelining = allowPipelining;
        this.sslConfig = sslMode == SslMode.DISABLE ? SslConfig.DISABLE_INSTANCE : new SslConfig(sslMode, serverSslCert, clientSslCert, clientSslKey, clientSslPassword, tlsProtocol, sslTunnelDisableHostVerification, sslContextBuilderCustomizer);
        this.rsaPublicKey = rsaPublicKey;
        this.cachingRsaPublicKey = cachingRsaPublicKey;
        this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
        this.prepareCacheSize = prepareCacheSize == null ? 250 : prepareCacheSize;
        this.pamOtherPwd = pamOtherPwd;
        this.autocommit = autocommit;
        this.tinyInt1isBit = tinyInt1isBit;
        this.loopResources = loopResources != null ? loopResources : TcpResources.get();
        this.useServerPrepStmts = !this.allowMultiQueries && useServerPrepStmts;
        this.sslContextBuilderCustomizer = sslContextBuilderCustomizer;
    }

    static boolean boolValue(Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return Boolean.parseBoolean(value.toString()) || "1".equals(value);
    }

    static Duration durationValue(Object value) {
        if (value instanceof Duration) {
            return (Duration)value;
        }
        return Duration.parse(value.toString());
    }

    static int intValue(Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        return Integer.parseInt(value.toString());
    }

    public static Builder fromOptions(ConnectionFactoryOptions connectionFactoryOptions) {
        Builder builder = new Builder();
        builder.database((String)connectionFactoryOptions.getValue(ConnectionFactoryOptions.DATABASE));
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SOCKET)) {
            builder.socket((String)connectionFactoryOptions.getRequiredValue(MariadbConnectionFactoryProvider.SOCKET));
        } else {
            builder.host((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.HOST));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.ALLOW_MULTI_QUERIES)) {
            builder.allowMultiQueries(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.ALLOW_MULTI_QUERIES)));
        }
        if (connectionFactoryOptions.hasOption(ConnectionFactoryOptions.CONNECT_TIMEOUT)) {
            builder.connectTimeout(MariadbConnectionConfiguration.durationValue(connectionFactoryOptions.getValue(ConnectionFactoryOptions.CONNECT_TIMEOUT)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TCP_KEEP_ALIVE)) {
            builder.tcpKeepAlive(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TCP_KEEP_ALIVE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.ALLOW_PUBLIC_KEY_RETRIEVAL)) {
            builder.allowPublicKeyRetrieval(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.ALLOW_PUBLIC_KEY_RETRIEVAL)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.CACHING_RSA_PUBLIC_KEY)) {
            builder.cachingRsaPublicKey((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CACHING_RSA_PUBLIC_KEY));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.RSA_PUBLIC_KEY)) {
            builder.rsaPublicKey((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.RSA_PUBLIC_KEY));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TCP_ABORTIVE_CLOSE)) {
            builder.tcpAbortiveClose(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TCP_ABORTIVE_CLOSE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TRANSACTION_REPLAY)) {
            builder.transactionReplay(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TRANSACTION_REPLAY)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SESSION_VARIABLES)) {
            String sessionVarString = (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SESSION_VARIABLES);
            builder.sessionVariables(MariadbConnectionConfiguration.getMapFromString(sessionVarString));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.HAMODE)) {
            String haMode = (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.HAMODE);
            builder.haMode(haMode);
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.ALLOW_PIPELINING)) {
            builder.allowPipelining(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.ALLOW_PIPELINING)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.USE_SERVER_PREPARE)) {
            builder.useServerPrepStmts(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.USE_SERVER_PREPARE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.ISOLATION_LEVEL)) {
            String isolationLvl = (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.ISOLATION_LEVEL);
            builder.isolationLevel(isolationLvl == null ? null : IsolationLevel.valueOf((String)isolationLvl.replace("-", " ")));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.AUTO_COMMIT)) {
            builder.autocommit(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.AUTO_COMMIT)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TINY_IS_BIT)) {
            builder.tinyInt1isBit(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TINY_IS_BIT)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.CONNECTION_ATTRIBUTES)) {
            String connAttributes = (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CONNECTION_ATTRIBUTES);
            builder.connectionAttributes(MariadbConnectionConfiguration.getMapFromString(connAttributes));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.PREPARE_CACHE_SIZE)) {
            builder.prepareCacheSize(MariadbConnectionConfiguration.intValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.PREPARE_CACHE_SIZE)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SSL_MODE)) {
            builder.sslMode(SslMode.from((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SSL_MODE)));
        }
        builder.serverSslCert((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SERVER_SSL_CERT));
        builder.clientSslCert((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CLIENT_SSL_CERT));
        builder.clientSslKey((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CLIENT_SSL_KEY));
        builder.clientSslPassword((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.CLIENT_SSL_PWD));
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.TLS_PROTOCOL)) {
            String[] protocols = ((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.TLS_PROTOCOL)).split("[,;\\s]+");
            builder.tlsProtocol(protocols);
        }
        builder.password((CharSequence)connectionFactoryOptions.getValue(ConnectionFactoryOptions.PASSWORD));
        builder.username((String)connectionFactoryOptions.getRequiredValue(ConnectionFactoryOptions.USER));
        if (connectionFactoryOptions.hasOption(ConnectionFactoryOptions.PORT)) {
            builder.port(MariadbConnectionConfiguration.intValue(connectionFactoryOptions.getValue(ConnectionFactoryOptions.PORT)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.PAM_OTHER_PASSWORD)) {
            String s = (String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.PAM_OTHER_PASSWORD);
            CharSequence[] pairs = s.split(",");
            try {
                for (int i = 0; i < pairs.length; ++i) {
                    pairs[i] = URLDecoder.decode((String)pairs[i], StandardCharsets.UTF_8.toString());
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
            builder.pamOtherPwd(pairs);
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.RESTRICTED_AUTH)) {
            builder.restrictedAuth((String)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.RESTRICTED_AUTH));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.LOOP_RESOURCES)) {
            LoopResources loopResources = (LoopResources)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.LOOP_RESOURCES);
            builder.loopResources(loopResources);
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SSL_TUNNEL_DISABLE_HOST_VERIFICATION)) {
            builder.sslTunnelDisableHostVerification(MariadbConnectionConfiguration.boolValue(connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SSL_TUNNEL_DISABLE_HOST_VERIFICATION)));
        }
        if (connectionFactoryOptions.hasOption(MariadbConnectionFactoryProvider.SSL_CONTEXT_BUILDER_CUSTOMIZER)) {
            builder.sslContextBuilderCustomizer((UnaryOperator)connectionFactoryOptions.getValue(MariadbConnectionFactoryProvider.SSL_CONTEXT_BUILDER_CUSTOMIZER));
        }
        return builder;
    }

    private static Map<String, String> getMapFromString(String s) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (s != null && !s.isEmpty()) {
            String[] pairs = s.split(",");
            for (int i = 0; i < pairs.length; ++i) {
                String pair = pairs[i];
                String[] keyValue = pair.split("=");
                map.put(keyValue[0], keyValue.length > 1 ? keyValue[1] : "");
            }
        }
        return map;
    }

    public static Builder builder() {
        return new Builder();
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    private void setIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    @Nullable
    public Duration getConnectTimeout() {
        return this.connectTimeout;
    }

    public CharSequence[] getPamOtherPwd() {
        return this.pamOtherPwd;
    }

    @Nullable
    public String getDatabase() {
        return this.database;
    }

    public HaMode getHaMode() {
        return this.haMode;
    }

    @Nullable
    public List<HostAddress> getHostAddresses() {
        return this.hostAddresses;
    }

    @Nullable
    public Map<String, String> getConnectionAttributes() {
        return this.connectionAttributes;
    }

    @Nullable
    public Map<String, String> getSessionVariables() {
        return this.sessionVariables;
    }

    @Nullable
    public CharSequence getPassword() {
        return this.password;
    }

    public int getPort() {
        return this.port;
    }

    @Nullable
    public String getSocket() {
        return this.socket;
    }

    public String getUsername() {
        return this.username;
    }

    public boolean allowMultiQueries() {
        return this.allowMultiQueries;
    }

    public boolean allowPipelining() {
        return this.allowPipelining;
    }

    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    public String getRsaPublicKey() {
        return this.rsaPublicKey;
    }

    public String getCachingRsaPublicKey() {
        return this.cachingRsaPublicKey;
    }

    public boolean allowPublicKeyRetrieval() {
        return this.allowPublicKeyRetrieval;
    }

    public boolean useServerPrepStmts() {
        return this.useServerPrepStmts;
    }

    public boolean autocommit() {
        return this.autocommit;
    }

    public boolean tinyInt1isBit() {
        return this.tinyInt1isBit;
    }

    public int getPrepareCacheSize() {
        return this.prepareCacheSize;
    }

    public boolean isTcpKeepAlive() {
        return this.tcpKeepAlive;
    }

    public boolean isTcpAbortiveClose() {
        return this.tcpAbortiveClose;
    }

    public boolean isTransactionReplay() {
        return this.transactionReplay;
    }

    public String[] getRestrictedAuth() {
        return this.restrictedAuth;
    }

    public LoopResources loopResources() {
        return this.loopResources;
    }

    public String toString() {
        StringBuilder hiddenPwd = new StringBuilder();
        if (this.password != null) {
            hiddenPwd.append("*");
        }
        StringBuilder hiddenPamPwd = new StringBuilder();
        if (this.pamOtherPwd != null) {
            for (CharSequence s : this.pamOtherPwd) {
                hiddenPamPwd.append("*");
                hiddenPamPwd.append(",");
            }
            hiddenPamPwd.deleteCharAt(hiddenPamPwd.length() - 1);
        }
        return "MariadbConnectionConfiguration{database='" + this.database + '\'' + ", hosts={" + (this.hostAddresses == null ? "" : Arrays.toString(this.hostAddresses.toArray())) + '}' + ", connectTimeout=" + this.connectTimeout + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpAbortiveClose=" + this.tcpAbortiveClose + ", transactionReplay=" + this.transactionReplay + ", password=" + hiddenPwd + ", prepareCacheSize=" + this.prepareCacheSize + ", socket='" + this.socket + '\'' + ", username='" + this.username + '\'' + ", allowMultiQueries=" + this.allowMultiQueries + ", allowPipelining=" + this.allowPipelining + ", connectionAttributes=" + this.connectionAttributes + ", sessionVariables=" + this.sessionVariables + ", sslConfig=" + this.sslConfig + ", rsaPublicKey='" + this.rsaPublicKey + '\'' + ", cachingRsaPublicKey='" + this.cachingRsaPublicKey + '\'' + ", allowPublicKeyRetrieval=" + this.allowPublicKeyRetrieval + ", isolationLevel=" + this.isolationLevel + ", useServerPrepStmts=" + this.useServerPrepStmts + ", autocommit=" + this.autocommit + ", tinyInt1isBit=" + this.tinyInt1isBit + ", pamOtherPwd=" + hiddenPamPwd + ", restrictedAuth=" + (this.restrictedAuth == null ? "" : Arrays.toString(this.restrictedAuth)) + '}';
    }

    public static final class Builder
    implements Cloneable {
        @Nullable
        private String haMode;
        @Nullable
        private String rsaPublicKey;
        @Nullable
        private String cachingRsaPublicKey;
        private boolean allowPublicKeyRetrieval;
        @Nullable
        private String username;
        @Nullable
        private Duration connectTimeout;
        @Nullable
        private Boolean tcpKeepAlive;
        @Nullable
        private Boolean tcpAbortiveClose;
        @Nullable
        private Boolean transactionReplay;
        @Nullable
        private String database;
        @Nullable
        private List<HostAddress> hostAddresses;
        @Nullable
        private String host;
        @Nullable
        private Map<String, String> sessionVariables;
        @Nullable
        private Map<String, String> connectionAttributes;
        @Nullable
        private CharSequence password;
        private int port = 3306;
        @Nullable
        private String socket;
        private boolean allowMultiQueries = false;
        private boolean allowPipelining = true;
        private boolean useServerPrepStmts = false;
        private IsolationLevel isolationLevel = null;
        private boolean autocommit = true;
        private boolean tinyInt1isBit = true;
        @Nullable
        Integer prepareCacheSize;
        @Nullable
        private List<String> tlsProtocol;
        @Nullable
        private String serverSslCert;
        @Nullable
        private String clientSslCert;
        @Nullable
        private String clientSslKey;
        @Nullable
        private CharSequence clientSslPassword;
        private SslMode sslMode = SslMode.DISABLE;
        private CharSequence[] pamOtherPwd;
        private String restrictedAuth;
        @Nullable
        private LoopResources loopResources;
        @Nullable
        private UnaryOperator<SslContextBuilder> sslContextBuilderCustomizer;
        private boolean sslTunnelDisableHostVerification;

        private Builder() {
        }

        public MariadbConnectionConfiguration build() {
            if (this.host == null && this.socket == null) {
                throw new IllegalArgumentException("host or socket must not be null");
            }
            if (this.host != null && this.socket != null) {
                throw new IllegalArgumentException("Connection must be configured for either host/port or socket usage but not both");
            }
            if (this.username == null) {
                throw new IllegalArgumentException("username must not be null");
            }
            return new MariadbConnectionConfiguration(this.haMode, this.connectTimeout, this.tcpKeepAlive, this.tcpAbortiveClose, this.transactionReplay, this.database, this.host, this.connectionAttributes, this.sessionVariables, this.password, this.port, this.hostAddresses, this.socket, this.username, this.allowMultiQueries, this.allowPipelining, this.tlsProtocol, this.serverSslCert, this.clientSslCert, this.clientSslKey, this.clientSslPassword, this.sslMode, this.rsaPublicKey, this.cachingRsaPublicKey, this.allowPublicKeyRetrieval, this.useServerPrepStmts, this.isolationLevel, this.autocommit, this.prepareCacheSize, this.pamOtherPwd, this.tinyInt1isBit, this.restrictedAuth, this.loopResources, this.sslContextBuilderCustomizer, this.sslTunnelDisableHostVerification);
        }

        public Builder connectTimeout(@Nullable Duration connectTimeout) {
            this.connectTimeout = connectTimeout;
            return this;
        }

        public Builder haMode(@Nullable String haMode) {
            this.haMode = haMode;
            return this;
        }

        public Builder hostAddresses(@Nullable List<HostAddress> hostAddresses) {
            this.hostAddresses = hostAddresses;
            return this;
        }

        public Builder restrictedAuth(@Nullable String restrictedAuth) {
            this.restrictedAuth = restrictedAuth;
            return this;
        }

        public Builder tcpKeepAlive(@Nullable Boolean tcpKeepAlive) {
            this.tcpKeepAlive = tcpKeepAlive;
            return this;
        }

        public Builder tcpAbortiveClose(@Nullable Boolean tcpAbortiveClose) {
            this.tcpAbortiveClose = tcpAbortiveClose;
            return this;
        }

        public Builder transactionReplay(@Nullable Boolean transactionReplay) {
            this.transactionReplay = transactionReplay;
            return this;
        }

        public Builder connectionAttributes(@Nullable Map<String, String> connectionAttributes) {
            this.connectionAttributes = connectionAttributes;
            return this;
        }

        public Builder sessionVariables(@Nullable Map<String, String> sessionVariables) {
            this.sessionVariables = sessionVariables;
            return this;
        }

        public Builder pamOtherPwd(@Nullable CharSequence[] pamOtherPwd) {
            this.pamOtherPwd = pamOtherPwd;
            return this;
        }

        public Builder database(@Nullable String database) {
            this.database = database;
            return this;
        }

        public Builder host(String host) {
            this.host = Assert.requireNonNull(host, "host must not be null");
            return this;
        }

        public Builder password(@Nullable CharSequence password) {
            this.password = password;
            return this;
        }

        public Builder tlsProtocol(String ... tlsProtocol) {
            if (tlsProtocol == null) {
                this.tlsProtocol = null;
                return this;
            }
            ArrayList<String> tmp = new ArrayList<String>();
            for (String protocol : tlsProtocol) {
                if (protocol == null) continue;
                tmp.add(protocol);
            }
            if (!tmp.isEmpty()) {
                this.tlsProtocol = tmp;
            }
            return this;
        }

        public Builder serverSslCert(String serverSslCert) {
            this.serverSslCert = serverSslCert;
            return this;
        }

        public Builder prepareCacheSize(Integer prepareCacheSize) {
            this.prepareCacheSize = prepareCacheSize;
            return this;
        }

        public Builder clientSslCert(String clientSslCert) {
            this.clientSslCert = clientSslCert;
            return this;
        }

        public Builder clientSslKey(String clientSslKey) {
            this.clientSslKey = clientSslKey;
            return this;
        }

        public Builder clientSslPassword(CharSequence clientSslPassword) {
            this.clientSslPassword = clientSslPassword;
            return this;
        }

        public Builder sslMode(SslMode sslMode) {
            this.sslMode = sslMode;
            if (sslMode == null) {
                this.sslMode = SslMode.DISABLE;
            }
            return this;
        }

        public Builder rsaPublicKey(String rsaPublicKey) {
            this.rsaPublicKey = rsaPublicKey;
            return this;
        }

        public Builder cachingRsaPublicKey(String cachingRsaPublicKey) {
            this.cachingRsaPublicKey = cachingRsaPublicKey;
            return this;
        }

        public Builder allowPublicKeyRetrieval(boolean allowPublicKeyRetrieval) {
            this.allowPublicKeyRetrieval = allowPublicKeyRetrieval;
            return this;
        }

        public Builder useServerPrepStmts(boolean useServerPrepStmts) {
            this.useServerPrepStmts = useServerPrepStmts;
            return this;
        }

        public Builder isolationLevel(IsolationLevel isolationLevel) {
            this.isolationLevel = isolationLevel;
            return this;
        }

        public Builder autocommit(boolean autocommit) {
            this.autocommit = autocommit;
            return this;
        }

        public Builder tinyInt1isBit(boolean tinyInt1isBit) {
            this.tinyInt1isBit = tinyInt1isBit;
            return this;
        }

        public Builder allowPipelining(boolean allowPipelining) {
            this.allowPipelining = allowPipelining;
            return this;
        }

        public Builder port(int port) {
            this.port = port;
            return this;
        }

        public Builder allowMultiQueries(boolean allowMultiQueries) {
            this.allowMultiQueries = allowMultiQueries;
            return this;
        }

        public Builder socket(String socket) {
            this.socket = Assert.requireNonNull(socket, "host must not be null");
            return this;
        }

        public Builder username(String username) {
            this.username = Assert.requireNonNull(username, "username must not be null");
            return this;
        }

        public Builder loopResources(LoopResources loopResources) {
            this.loopResources = Assert.requireNonNull(loopResources, "loopResources must not be null");
            return this;
        }

        public Builder sslContextBuilderCustomizer(UnaryOperator<SslContextBuilder> sslContextBuilderCustomizer) {
            this.sslContextBuilderCustomizer = sslContextBuilderCustomizer;
            return this;
        }

        public Builder sslTunnelDisableHostVerification(boolean sslTunnelDisableHostVerification) {
            this.sslTunnelDisableHostVerification = sslTunnelDisableHostVerification;
            return this;
        }

        public Builder clone() throws CloneNotSupportedException {
            return (Builder)super.clone();
        }

        public String toString() {
            StringBuilder hiddenPwd = new StringBuilder();
            if (this.password != null) {
                hiddenPwd.append("*");
            }
            StringBuilder hiddenPamPwd = new StringBuilder();
            if (this.pamOtherPwd != null) {
                for (CharSequence s : this.pamOtherPwd) {
                    hiddenPamPwd.append("*");
                    hiddenPamPwd.append(",");
                }
                hiddenPamPwd.deleteCharAt(hiddenPamPwd.length() - 1);
            }
            return "Builder{rsaPublicKey=" + this.rsaPublicKey + ", cachingRsaPublicKey=" + this.cachingRsaPublicKey + ", allowPublicKeyRetrieval=" + this.allowPublicKeyRetrieval + ", username=" + this.username + ", connectTimeout=" + this.connectTimeout + ", tcpKeepAlive=" + this.tcpKeepAlive + ", tcpAbortiveClose=" + this.tcpAbortiveClose + ", transactionReplay=" + this.transactionReplay + ", database=" + this.database + ", host=" + this.host + ", sessionVariables=" + this.sessionVariables + ", connectionAttributes=" + this.connectionAttributes + ", password=" + hiddenPwd + ", restrictedAuth=" + this.restrictedAuth + ", port=" + this.port + ", hosts={" + (this.hostAddresses == null ? "" : Arrays.toString(this.hostAddresses.toArray())) + '}' + ", socket=" + this.socket + ", allowMultiQueries=" + this.allowMultiQueries + ", allowPipelining=" + this.allowPipelining + ", useServerPrepStmts=" + this.useServerPrepStmts + ", prepareCacheSize=" + this.isolationLevel + ", isolationLevel=" + this.prepareCacheSize + ", tlsProtocol=" + this.tlsProtocol + ", serverSslCert=" + this.serverSslCert + ", clientSslCert=" + this.clientSslCert + ", clientSslKey=" + this.clientSslKey + ", clientSslPassword=" + this.clientSslPassword + ", sslMode=" + (Object)((Object)this.sslMode) + ", sslTunnelDisableHostVerification=" + this.sslTunnelDisableHostVerification + ", pamOtherPwd=" + hiddenPamPwd + ", tinyInt1isBit=" + this.tinyInt1isBit + ", autoCommit=" + this.autocommit + '}';
        }
    }
}

