/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc;

public enum SslMode {
    DISABLE("disable", new String[]{"DISABLED", "0", "false"}),
    TRUST("trust", new String[]{"REQUIRED", "ENABLE_TRUST"}),
    VERIFY_CA("verify-ca", new String[]{"VERIFY_CA", "ENABLE_WITHOUT_HOSTNAME_VERIFICATION"}),
    VERIFY_FULL("verify-full", new String[]{"VERIFY_IDENTITY", "1", "true", "enable"}),
    TUNNEL("tunnel", new String[]{"TUNNEL"});

    public final String value;
    private final String[] aliases;

    private SslMode(String value, String[] aliases) {
        this.value = value;
        this.aliases = aliases;
    }

    public static SslMode from(String value) {
        for (SslMode sslMode : SslMode.values()) {
            if (sslMode.value.equalsIgnoreCase(value) || sslMode.name().equalsIgnoreCase(value)) {
                return sslMode;
            }
            for (String alias : sslMode.aliases) {
                if (!alias.equalsIgnoreCase(value)) continue;
                return sslMode;
            }
        }
        throw new IllegalArgumentException(String.format("Wrong argument value '%s' for SslMode", value));
    }
}

