/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.r2dbc.spi.OutParameterMetadata;
import io.r2dbc.spi.OutParametersMetadata;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.Assert;

public final class MariadbOutParametersMetadata
implements OutParametersMetadata {
    private final List<ColumnDefinitionPacket> metadataList;
    private volatile Collection<String> columnNames;
    private Map<String, Integer> mapper = null;

    MariadbOutParametersMetadata(List<ColumnDefinitionPacket> metadataList) {
        this.metadataList = metadataList;
    }

    public ColumnDefinitionPacket getParameterMetadata(int index) {
        if (index < 0 || index >= this.metadataList.size()) {
            throw new IllegalArgumentException(String.format("Column index %d is not in permit range[0,%s]", index, this.metadataList.size() - 1));
        }
        return this.metadataList.get(index);
    }

    public ColumnDefinitionPacket getParameterMetadata(String name) {
        return this.metadataList.get(this.getIndex(name));
    }

    public List<? extends OutParameterMetadata> getParameterMetadatas() {
        return Collections.unmodifiableList(this.metadataList);
    }

    int getIndex(String name) throws NoSuchElementException {
        Integer ind;
        Assert.requireNonNull(name, "name must not be null");
        if (this.mapper == null) {
            HashMap<String, Integer> tmpmapper = new HashMap<String, Integer>();
            for (int i = 0; i < this.metadataList.size(); ++i) {
                ColumnDefinitionPacket ci = this.metadataList.get(i);
                String columnAlias = ci.getName();
                if (columnAlias == null || columnAlias.isEmpty()) {
                    String columnName = ci.getColumn();
                    if (columnName == null || columnName.isEmpty()) continue;
                    columnName = columnName.toLowerCase(Locale.ROOT);
                    tmpmapper.putIfAbsent(columnName, i);
                    continue;
                }
                tmpmapper.putIfAbsent(columnAlias.toLowerCase(Locale.ROOT), i);
            }
            this.mapper = tmpmapper;
        }
        if ((ind = this.mapper.get(name.toLowerCase(Locale.ROOT))) == null) {
            throw new NoSuchElementException(String.format("Column name '%s' does not exist in column names %s", name, Collections.unmodifiableCollection(this.mapper.keySet())));
        }
        return ind;
    }
}

