/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBuf;
import io.r2dbc.spi.R2dbcTransientResourceException;
import org.mariadb.r2dbc.ExceptionFactory;
import org.mariadb.r2dbc.client.MariadbRow;
import org.mariadb.r2dbc.client.MariadbRowMetadata;
import org.mariadb.r2dbc.codec.Codec;
import org.mariadb.r2dbc.codec.Codecs;
import org.mariadb.r2dbc.message.server.ColumnDefinitionPacket;
import org.mariadb.r2dbc.util.Assert;
import reactor.util.annotation.Nullable;

public class MariadbRowText
extends MariadbRow
implements org.mariadb.r2dbc.api.MariadbRow {
    public MariadbRowText(ByteBuf buf, MariadbRowMetadata meta, ExceptionFactory factory) {
        super(buf, meta, factory);
        this.buf.markReaderIndex();
    }

    @Override
    public MariadbRowMetadata getMetadata() {
        return this.meta;
    }

    @Override
    @Nullable
    public <T> T get(int index, Class<T> type) {
        ColumnDefinitionPacket column = this.meta.getColumnMetadata(index);
        this.setPosition(index);
        if (this.length == -1) {
            if (type.isPrimitive()) {
                throw new R2dbcTransientResourceException(String.format("Cannot return null for primitive %s", type.getName()));
            }
            return null;
        }
        if (Object.class == type || type == null) {
            Codec<?> defaultCodec = column.getType().getDefaultCodec();
            return (T)defaultCodec.decodeText(this.buf, this.length, column, type, this.factory);
        }
        Codec<T> defaultCodec = Codecs.typeMapper.get(type);
        if (defaultCodec != null) {
            if (!defaultCodec.canDecode(column, type)) {
                this.buf.skipBytes(this.length);
                throw MariadbRow.noDecoderException(column, type);
            }
            return (T)defaultCodec.decodeText(this.buf, this.length, column, type, this.factory);
        }
        for (Codec<T> codec : Codecs.LIST) {
            if (!codec.canDecode(column, type)) continue;
            return (T)codec.decodeText(this.buf, this.length, column, type, this.factory);
        }
        this.buf.skipBytes(this.length);
        throw MariadbRow.noDecoderException(column, type);
    }

    @Override
    @Nullable
    public <T> T get(String name, Class<T> type) {
        Assert.requireNonNull(name, "name must not be null");
        return this.get(this.meta.getIndex(name), type);
    }

    public void setPosition(int newIndex) {
        short type;
        if (this.index >= newIndex) {
            this.index = -1;
            this.buf.resetReaderIndex();
        }
        ++this.index;
        while (this.index < newIndex) {
            type = this.buf.readUnsignedByte();
            switch (type) {
                case 252: {
                    this.buf.skipBytes(this.buf.readUnsignedShortLE());
                    break;
                }
                case 253: {
                    this.buf.skipBytes(this.buf.readUnsignedMediumLE());
                    break;
                }
                case 254: {
                    this.buf.skipBytes((int)this.buf.readLongLE());
                    break;
                }
                case 251: {
                    break;
                }
                default: {
                    this.buf.skipBytes((int)type);
                }
            }
            ++this.index;
        }
        type = this.buf.readUnsignedByte();
        switch (type) {
            case 251: {
                this.length = -1;
                break;
            }
            case 252: {
                this.length = this.buf.readUnsignedShortLE();
                break;
            }
            case 253: {
                this.length = this.buf.readUnsignedMediumLE();
                break;
            }
            case 254: {
                this.length = (int)this.buf.readLongLE();
                break;
            }
            default: {
                this.length = type;
            }
        }
    }
}

