/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.client;

import io.netty.buffer.ByteBufAllocator;
import io.r2dbc.spi.IsolationLevel;
import org.mariadb.r2dbc.client.ServerVersion;
import org.mariadb.r2dbc.message.Context;

public class SimpleContext
implements Context {
    private final long threadId;
    private final long serverCapabilities;
    private final long clientCapabilities;
    private final ServerVersion version;
    private final ByteBufAllocator byteBufAllocator;
    private String redirectValue;
    private short serverStatus;
    private IsolationLevel isolationLevel;
    private String database;

    public SimpleContext(String serverVersion, long threadId, long capabilities, short serverStatus, boolean mariaDBServer, long clientCapabilities, String database, ByteBufAllocator byteBufAllocator, IsolationLevel isolationLevel) {
        this.threadId = threadId;
        this.serverCapabilities = capabilities;
        this.clientCapabilities = clientCapabilities;
        this.serverStatus = serverStatus;
        this.version = new ServerVersion(serverVersion, mariaDBServer);
        this.isolationLevel = isolationLevel;
        this.database = database;
        this.byteBufAllocator = byteBufAllocator;
        this.redirectValue = null;
    }

    @Override
    public long getThreadId() {
        return this.threadId;
    }

    @Override
    public long getServerCapabilities() {
        return this.serverCapabilities;
    }

    @Override
    public long getClientCapabilities() {
        return this.clientCapabilities;
    }

    @Override
    public short getServerStatus() {
        return this.serverStatus;
    }

    @Override
    public void setServerStatus(short serverStatus) {
        this.serverStatus = serverStatus;
    }

    @Override
    public String getDatabase() {
        return this.database;
    }

    @Override
    public void setDatabase(String database) {
        this.database = database;
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    @Override
    public void setIsolationLevel(IsolationLevel isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    @Override
    public ServerVersion getVersion() {
        return this.version;
    }

    @Override
    public ByteBufAllocator getByteBufAllocator() {
        return this.byteBufAllocator;
    }

    @Override
    public void setRedirect(String redirectValue) {
        this.redirectValue = redirectValue;
    }

    @Override
    public String getRedirectValue() {
        return this.redirectValue;
    }

    public String toString() {
        return "ConnectionContext{threadId=" + this.threadId + ", version=" + this.version + '}';
    }
}

