/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.codec;

public enum DataType {
    OLDDECIMAL(0),
    TINYINT(1),
    SMALLINT(2),
    INTEGER(3),
    FLOAT(4),
    DOUBLE(5),
    NULL(6),
    TIMESTAMP(7),
    BIGINT(8),
    MEDIUMINT(9),
    DATE(10),
    TIME(11),
    DATETIME(12),
    YEAR(13),
    NEWDATE(14),
    TEXT(15),
    BIT(16),
    JSON(245),
    DECIMAL(246),
    ENUM(247),
    SET(248),
    TINYBLOB(249),
    MEDIUMBLOB(250),
    LONGBLOB(251),
    BLOB(252),
    VARSTRING(253),
    STRING(254),
    GEOMETRY(255);

    static final DataType[] typeMap;
    private final short mariadbType;

    private DataType(int mariadbType) {
        this.mariadbType = (short)mariadbType;
    }

    public static DataType fromServer(int typeValue, int charsetNumber) {
        DataType dataType = typeMap[typeValue];
        if (charsetNumber != 63 && typeValue >= 249 && typeValue <= 252) {
            return TEXT;
        }
        return dataType;
    }

    public short get() {
        return this.mariadbType;
    }

    static {
        typeMap = new DataType[256];
        DataType[] dataTypeArray = DataType.values();
        int n = dataTypeArray.length;
        for (int i = 0; i < n; ++i) {
            DataType v;
            DataType.typeMap[v.mariadbType] = v = dataTypeArray[i];
        }
    }
}

