/*
 * Decompiled with CFR 0.152.
 */
package org.mariadb.r2dbc.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.mariadb.r2dbc.util.PrepareResult;

public final class ClientParser
implements PrepareResult {
    private final String sql;
    private final byte[] query;
    private final List<Integer> paramPositions;
    private final List<String> paramNameList;
    private final int paramCount;
    private final Boolean isReturning;
    private final Boolean supportAddingReturning;

    private ClientParser(String sql, byte[] query, Boolean isReturning, Boolean supportAddingReturning, List<Integer> paramPositions, List<String> paramNameList) {
        this.sql = sql;
        this.query = query;
        this.paramPositions = paramPositions;
        this.paramNameList = paramNameList;
        this.paramCount = paramPositions.size() / 2;
        this.isReturning = isReturning;
        this.supportAddingReturning = supportAddingReturning;
    }

    public static ClientParser parameterPartsCheckReturning(String queryString, boolean noBackslashEscapes) {
        ArrayList<Integer> paramPositions = new ArrayList<Integer>();
        ArrayList<String> paramNameList = new ArrayList<String>();
        LexState state = LexState.Normal;
        byte lastChar = 0;
        boolean singleQuotes = false;
        boolean returning = false;
        boolean supportAddingReturning = false;
        byte[] query = queryString.getBytes(StandardCharsets.UTF_8);
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            byte car = query[i];
            if (!(state != LexState.Escape || car == 39 && singleQuotes || car == 34 && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case 42: {
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case 47: {
                    if (state == LexState.SlashStarComment && lastChar == 42) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 35: {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 45: {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 10: {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case 34: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 39: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 58: {
                    if (state != LexState.Normal) break;
                    int beginPos = i;
                    while (++i < queryLength && (car = query[i]) != 32 && (car >= 48 && car <= 57 || car >= 65 && car <= 90 || car >= 97 && car <= 122 || car == 45 || car == 95)) {
                    }
                    if (beginPos + 1 == i) break;
                    paramNameList.add(new String(query, beginPos + 1, i - (beginPos + 1)));
                    paramPositions.add(beginPos);
                    paramPositions.add(i);
                    break;
                }
                case 92: {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case 63: {
                    if (state != LexState.Normal) break;
                    paramPositions.add(i);
                    paramPositions.add(i + 1);
                    break;
                }
                case 96: {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                    break;
                }
                case 82: 
                case 114: {
                    if (state != LexState.Normal || returning || queryLength <= i + 8 || query[i + 1] != 101 && query[i + 1] != 69 || query[i + 2] != 116 && query[i + 2] != 84 || query[i + 3] != 117 && query[i + 3] != 85 || query[i + 4] != 114 && query[i + 4] != 82 || query[i + 5] != 110 && query[i + 5] != 78 || query[i + 6] != 105 && query[i + 6] != 73 || query[i + 7] != 110 && query[i + 7] != 78 || query[i + 8] != 103 && query[i + 8] != 71 || i > 0 && query[i - 1] > 32 && "();><=-+,".indexOf(query[i - 1]) == -1 || i + 9 < queryLength && query[i + 9] > 32 && "();><=-+,".indexOf(query[i + 9]) == -1) break;
                    returning = true;
                    supportAddingReturning = false;
                    i += 8;
                    break;
                }
                case 73: 
                case 105: {
                    if (state != LexState.Normal || returning || queryLength <= i + 6 || query[i + 1] != 110 && query[i + 1] != 78 || query[i + 2] != 115 && query[i + 2] != 83 || query[i + 3] != 101 && query[i + 3] != 69 || query[i + 4] != 114 && query[i + 4] != 82 || query[i + 5] != 116 && query[i + 5] != 84) break;
                    if (i > 0 && query[i - 1] > 32 && "();><=-+,".indexOf(query[i - 1]) == -1) {
                        i += 6;
                        break;
                    }
                    if (query[i + 6] > 32 && "();><=-+,".indexOf(query[i + 6]) == -1) {
                        i += 6;
                        break;
                    }
                    supportAddingReturning = true;
                    i += 6;
                    break;
                }
                case 85: 
                case 117: {
                    if (state != LexState.Normal || returning || queryLength <= i + 6 || query[i + 1] != 112 && query[i + 1] != 80 || query[i + 2] != 100 && query[i + 2] != 68 || query[i + 3] != 97 && query[i + 3] != 65 || query[i + 4] != 116 && query[i + 4] != 84 || query[i + 5] != 101 && query[i + 5] != 69) break;
                    if (i > 0 && query[i - 1] > 32 && "();><=-+,".indexOf(query[i - 1]) == -1) {
                        i += 6;
                        break;
                    }
                    if (query[i + 6] > 32 && "();><=-+,".indexOf(query[i + 6]) == -1) {
                        i += 6;
                        break;
                    }
                    supportAddingReturning = true;
                    i += 6;
                    break;
                }
                case 68: 
                case 100: {
                    if (state != LexState.Normal || returning || queryLength <= i + 6 || query[i + 1] != 101 && query[i + 1] != 69 || query[i + 2] != 108 && query[i + 2] != 76 || query[i + 3] != 101 && query[i + 3] != 69 || query[i + 4] != 116 && query[i + 4] != 84 || query[i + 5] != 101 && query[i + 5] != 69) break;
                    if (i > 0 && query[i - 1] > 32 && "();><=-+,".indexOf(query[i - 1]) == -1) {
                        i += 6;
                        break;
                    }
                    if (query[i + 6] > 32 && "();><=-+,".indexOf(query[i + 6]) == -1) {
                        i += 6;
                        break;
                    }
                    supportAddingReturning = true;
                    i += 6;
                }
            }
            lastChar = car;
        }
        return new ClientParser(queryString, query, returning, supportAddingReturning, paramPositions, paramNameList);
    }

    public static ClientParser parameterParts(String queryString, boolean noBackslashEscapes) {
        ArrayList<Integer> paramPositions = new ArrayList<Integer>();
        ArrayList<String> paramNameList = new ArrayList<String>();
        LexState state = LexState.Normal;
        byte lastChar = 0;
        boolean singleQuotes = false;
        byte[] query = queryString.getBytes(StandardCharsets.UTF_8);
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            byte car = query[i];
            if (!(state != LexState.Escape || car == 39 && singleQuotes || car == 34 && !singleQuotes)) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case 42: {
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case 47: {
                    if (state == LexState.SlashStarComment && lastChar == 42) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != 47) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 35: {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 45: {
                    if (state != LexState.Normal || lastChar != 45) break;
                    state = LexState.EOLComment;
                    break;
                }
                case 10: {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case 34: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state == LexState.String && !singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 39: {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state == LexState.String && singleQuotes) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Escape) break;
                    state = LexState.String;
                    break;
                }
                case 58: {
                    if (state != LexState.Normal) break;
                    int beginPos = i;
                    while (++i < queryLength && (car = query[i]) != 32 && (car >= 48 && car <= 57 || car >= 65 && car <= 90 || car >= 97 && car <= 122 || car == 45 || car == 95)) {
                    }
                    if (beginPos + 1 == i) break;
                    paramNameList.add(new String(query, beginPos + 1, i - (beginPos + 1)));
                    paramPositions.add(beginPos);
                    paramPositions.add(i);
                    break;
                }
                case 92: {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case 63: {
                    if (state != LexState.Normal) break;
                    paramPositions.add(i);
                    paramPositions.add(i + 1);
                    break;
                }
                case 96: {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = car;
        }
        return new ClientParser(queryString, query, null, null, paramPositions, paramNameList);
    }

    public static boolean hasParameter(String queryString, boolean noBackslashEscapes) {
        LexState state = LexState.Normal;
        char lastChar = '\u0000';
        boolean singleQuotes = false;
        char[] query = queryString.toCharArray();
        int queryLength = query.length;
        for (int i = 0; i < queryLength; ++i) {
            char car = query[i];
            if (state == LexState.Escape) {
                state = LexState.String;
                lastChar = car;
                continue;
            }
            switch (car) {
                case '*': {
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.SlashStarComment;
                    break;
                }
                case '/': {
                    if (state == LexState.SlashStarComment && lastChar == '*') {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal || lastChar != '/') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '#': {
                    if (state != LexState.Normal) break;
                    state = LexState.EOLComment;
                    break;
                }
                case '-': {
                    if (state != LexState.Normal || lastChar != '-') break;
                    state = LexState.EOLComment;
                    break;
                }
                case '\n': {
                    if (state != LexState.EOLComment) break;
                    state = LexState.Normal;
                    break;
                }
                case '\"': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = false;
                        break;
                    }
                    if (state != LexState.String || singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\'': {
                    if (state == LexState.Normal) {
                        state = LexState.String;
                        singleQuotes = true;
                        break;
                    }
                    if (state != LexState.String || !singleQuotes) break;
                    state = LexState.Normal;
                    break;
                }
                case '\\': {
                    if (noBackslashEscapes || state != LexState.String) break;
                    state = LexState.Escape;
                    break;
                }
                case '?': {
                    if (state != LexState.Normal) break;
                    return true;
                }
                case ':': {
                    if (state != LexState.Normal) break;
                    int beginPos = i;
                    while (++i < queryLength && (car = query[i]) != ' ' && (car >= '0' && car <= '9' || car >= 'A' && car <= 'Z' || car >= 'a' && car <= 'z' || car == '-' || car == '_')) {
                    }
                    if (beginPos + 1 == i) break;
                    return true;
                }
                case '`': {
                    if (state == LexState.Backtick) {
                        state = LexState.Normal;
                        break;
                    }
                    if (state != LexState.Normal) break;
                    state = LexState.Backtick;
                }
            }
            lastChar = car;
        }
        return false;
    }

    public String getSql() {
        return this.sql;
    }

    public byte[] getQuery() {
        return this.query;
    }

    public List<Integer> getParamPositions() {
        return this.paramPositions;
    }

    public List<String> getParamNameList() {
        return this.paramNameList;
    }

    @Override
    public int getParamCount() {
        return this.paramCount;
    }

    public boolean isReturning() {
        return this.isReturning;
    }

    public Boolean supportAddingReturning() {
        return this.supportAddingReturning;
    }

    public void validateAddingReturning() {
        if (this.isReturning.booleanValue()) {
            throw new IllegalStateException("Statement already includes RETURNING clause");
        }
        if (!this.supportAddingReturning.booleanValue()) {
            throw new IllegalStateException("Cannot add RETURNING clause to query");
        }
    }

    static enum LexState {
        Normal,
        String,
        SlashStarComment,
        Escape,
        EOLComment,
        Backtick;

    }
}

