/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.commons.jexl;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl.ExpressionFactory;
import org.apache.commons.jexl.JexlContext;
import org.apache.commons.jexl.JexlHelper;
import org.metawidget.inspector.commons.jexl.JexlXmlInspectorConfig;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspector;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.ThreadUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JexlXmlInspector
extends BaseXmlInspector {
    private static final ThreadLocal<Object> LOCAL_TOINSPECT = ThreadUtils.newThreadLocal();
    private static final ThreadLocal<JexlContext> LOCAL_CONTEXT = ThreadUtils.newThreadLocal();
    private static final Pattern PATTERN_BINDING = Pattern.compile("^\\$\\{(.*)\\}$");

    public JexlXmlInspector(JexlXmlInspectorConfig jexlXmlInspectorConfig) {
        super(jexlXmlInspectorConfig);
    }

    @Override
    public String inspect(Object object, String string, String ... stringArray) {
        LOCAL_TOINSPECT.set(object);
        String string2 = super.inspect(object, string, stringArray);
        LOCAL_CONTEXT.remove();
        LOCAL_TOINSPECT.remove();
        return string2;
    }

    @Override
    protected String getExtendsAttribute() {
        return "extends";
    }

    @Override
    protected Map<String, String> inspectProperty(Element element) {
        if ("property".equals(element.getNodeName())) {
            return this.inspect(element);
        }
        return null;
    }

    @Override
    protected Map<String, String> inspectAction(Element element) {
        if ("action".equals(element.getNodeName())) {
            return this.inspect(element);
        }
        return null;
    }

    protected JexlContext getContext() {
        JexlContext jexlContext = LOCAL_CONTEXT.get();
        if (jexlContext == null) {
            jexlContext = this.createContext(LOCAL_TOINSPECT.get());
            LOCAL_CONTEXT.set(jexlContext);
        }
        return jexlContext;
    }

    protected JexlContext createContext(Object object) {
        JexlContext jexlContext = JexlHelper.createContext();
        Map map = jexlContext.getVars();
        if (object != null) {
            map.put("this", object);
        }
        return jexlContext;
    }

    private Map<String, String> inspect(Element element) {
        Map<String, String> map = XmlUtils.getAttributesAsMap(element);
        for (Map.Entry<String, String> entry : CollectionUtils.newArrayList(map.entrySet())) {
            String string = entry.getValue();
            Matcher matcher = PATTERN_BINDING.matcher(string);
            if (!matcher.matches()) continue;
            try {
                string = StringUtils.quietValueOf(ExpressionFactory.createExpression((String)matcher.group(1)).evaluate(this.getContext()));
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
            map.put(entry.getKey(), string);
        }
        return map;
    }
}

