/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.hibernate.validator;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.validator.Length;
import org.hibernate.validator.Max;
import org.hibernate.validator.Min;
import org.hibernate.validator.NotEmpty;
import org.hibernate.validator.NotNull;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateValidatorInspector
extends BaseObjectInspector {
    public HibernateValidatorInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public HibernateValidatorInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        Length length;
        Object object;
        Min min;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        try {
            min = Class.forName("org.hibernate.validator.Digits");
            object = property.getAnnotation(min);
            if (object != null) {
                int n;
                int n2 = (Integer)min.getMethod("integerDigits", new Class[0]).invoke(object, new Object[0]);
                if (n2 > 0) {
                    hashMap.put("maximum-integer-digits", String.valueOf(n2));
                }
                if ((n = ((Integer)min.getMethod("fractionalDigits", new Class[0]).invoke(object, new Object[0])).intValue()) > 0) {
                    hashMap.put("maximum-fractional-digits", String.valueOf(n));
                }
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        if (property.isAnnotationPresent(NotNull.class)) {
            hashMap.put("required", "true");
        }
        if (property.isAnnotationPresent(NotEmpty.class)) {
            hashMap.put("required", "true");
        }
        if ((min = property.getAnnotation(Min.class)) != null) {
            hashMap.put("minimum-value", String.valueOf(min.value()));
        }
        if ((object = property.getAnnotation(Max.class)) != null) {
            hashMap.put("maximum-value", String.valueOf(object.value()));
        }
        if ((length = property.getAnnotation(Length.class)) != null) {
            if (length.min() > 0) {
                hashMap.put("minimum-length", String.valueOf(length.min()));
            }
            if (length.max() > 0) {
                hashMap.put("maximum-length", String.valueOf(length.max()));
            }
        }
        return hashMap;
    }
}

