/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.io.InputStream;
import java.util.HashSet;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseXmlInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.PropertyStyle;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.LogUtils;
import org.metawidget.util.XmlUtils;
import org.metawidget.util.simple.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseXmlInspector
implements Inspector {
    protected LogUtils.Log mLog = LogUtils.getLog(this.getClass());
    protected Element mRoot;
    private final PropertyStyle mRestrictAgainstObject;

    protected BaseXmlInspector(BaseXmlInspectorConfig baseXmlInspectorConfig) {
        try {
            DocumentBuilder documentBuilder = this.newDocumentBuilder(baseXmlInspectorConfig);
            documentBuilder.setEntityResolver(new XmlUtils.NopEntityResolver());
            InputStream[] inputStreamArray = baseXmlInspectorConfig.getInputStreams();
            if (inputStreamArray != null && inputStreamArray.length > 0) {
                this.mRoot = this.getDocumentElement(documentBuilder, baseXmlInspectorConfig.getResourceResolver(), baseXmlInspectorConfig.getInputStreams());
            }
            if (this.mRoot == null) {
                throw InspectorException.newException("No XML input file specified");
            }
            if (this.mLog.isTraceEnabled()) {
                this.mLog.trace(XmlUtils.documentToString(this.mRoot.getOwnerDocument(), false));
            }
            this.mRestrictAgainstObject = baseXmlInspectorConfig.getRestrictAgainstObject();
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    @Override
    public String inspect(Object object, String string, String[] stringArray) {
        if (string == null) {
            return null;
        }
        if (this.mRestrictAgainstObject != null && this.isRestrictedAgainstObject(object, string, stringArray)) {
            return null;
        }
        try {
            Object object2;
            Node node;
            Element element = null;
            Map<String, String> map = null;
            if (stringArray != null && stringArray.length > 0) {
                node = this.traverse(string, true, stringArray);
                if (node == null) {
                    return null;
                }
                map = this.inspectProperty((Element)node);
                object2 = this.getTypeAttribute();
                if (!node.hasAttribute((String)object2)) {
                    throw InspectorException.newException(new StringBuffer().append("Property ").append(stringArray[stringArray.length - 1]).append(" has no @").append((String)object2).append(" attribute, so cannot navigate to ").append(string).append(ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_DOT, true, false)).toString());
                }
                element = this.traverse(node.getAttribute((String)object2), false, new String[0]);
            } else {
                element = this.traverse(string, false, stringArray);
                if (element == null) {
                    return null;
                }
            }
            node = XmlUtils.newDocumentBuilder().newDocument();
            object2 = node.createElementNS("http://metawidget.org/inspection-result", "entity");
            this.inspect(element, (Element)object2);
            if (!object2.hasChildNodes() && (map == null || map.isEmpty())) {
                return null;
            }
            Element element2 = node.createElementNS("http://metawidget.org/inspection-result", "inspection-result");
            element2.setAttribute("version", "1.0");
            node.appendChild(element2);
            element2.appendChild((Node)object2);
            if (map == null) {
                object2.setAttribute("type", string);
            } else {
                XmlUtils.setMapAsAttributes((Element)object2, map);
            }
            return XmlUtils.documentToString((Document)node, false);
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    protected DocumentBuilder newDocumentBuilder(BaseXmlInspectorConfig baseXmlInspectorConfig) throws Exception {
        return XmlUtils.newDocumentBuilder();
    }

    protected Element getDocumentElement(DocumentBuilder documentBuilder, ResourceResolver resourceResolver, InputStream[] inputStreamArray) throws Exception {
        Document document = null;
        for (InputStream inputStream : inputStreamArray) {
            Document document2 = documentBuilder.parse(inputStream);
            if (!document2.hasChildNodes()) continue;
            this.preprocessDocument(document2);
            if (document == null || !document.hasChildNodes()) {
                document = document2;
                continue;
            }
            XmlUtils.combineElements(document.getDocumentElement(), document2.getDocumentElement(), this.getTopLevelTypeAttribute(), this.getNameAttribute());
        }
        if (document == null) {
            return null;
        }
        return document.getDocumentElement();
    }

    protected void preprocessDocument(Document document) {
    }

    protected void inspect(Element element, Element element2) {
        if (element == null) {
            return;
        }
        Document document = element2.getOwnerDocument();
        String string = this.getExtendsAttribute();
        if (string != null && element.hasAttribute(string)) {
            this.inspect(this.traverse(element.getAttribute(string), false, new String[0]), element2);
        }
        Element element3 = document.createElementNS("http://metawidget.org/inspection-result", "entity");
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element4;
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || (element4 = this.inspect(document, (Element)node)) == null) continue;
            element3.appendChild(element4);
        }
        XmlUtils.combineElements(element2, element3, "name", "name");
    }

    protected Element inspect(Document document, Element element) {
        Map<String, String> map = this.inspectProperty(element);
        if (map != null && !map.isEmpty()) {
            Element element2 = document.createElementNS("http://metawidget.org/inspection-result", "property");
            XmlUtils.setMapAsAttributes(element2, map);
            return element2;
        }
        Map<String, String> map2 = this.inspectAction(element);
        if (map2 != null && !map2.isEmpty()) {
            if (map != null) {
                throw InspectorException.newException(new StringBuffer().append("Ambigious match: ").append(element.getNodeName()).append(" matches as both a property and an action").toString());
            }
            Element element3 = document.createElementNS("http://metawidget.org/inspection-result", "action");
            XmlUtils.setMapAsAttributes(element3, map2);
            return element3;
        }
        return null;
    }

    protected Map<String, String> inspectProperty(Element element) {
        return null;
    }

    protected Map<String, String> inspectAction(Element element) {
        return null;
    }

    protected Element traverse(String string, boolean bl, String[] stringArray) {
        String string2 = this.getTopLevelTypeAttribute();
        Element element = XmlUtils.getChildWithAttributeValue(this.mRoot, string2, string);
        if (element == null) {
            return null;
        }
        if (stringArray == null) {
            return element;
        }
        int n = stringArray.length;
        if (n == 0) {
            return element;
        }
        String string3 = this.getExtendsAttribute();
        String string4 = this.getNameAttribute();
        String string5 = this.getTypeAttribute();
        for (int i = 0; i < n; ++i) {
            String string6;
            String string7 = stringArray[i];
            Element element2 = XmlUtils.getChildWithAttributeValue(element, string4, string7);
            if (element2 == null) {
                if (string3 == null) {
                    return null;
                }
                do {
                    if (!element.hasAttribute(string3)) {
                        return null;
                    }
                    string6 = element.getAttribute(string3);
                    if ((element = XmlUtils.getChildWithAttributeValue(this.mRoot, string2, string6)) != null) continue;
                    return null;
                } while ((element2 = XmlUtils.getChildWithAttributeValue(element, string4, string7)) == null);
                if (element2 == null) {
                    return null;
                }
            }
            if (bl && i >= n - 1) {
                return element2;
            }
            if (!element2.hasAttribute(string5)) {
                throw InspectorException.newException(new StringBuffer().append("Property ").append(string7).append(" in entity ").append(element.getAttribute(string5)).append(" has no @").append(string5).append(" attribute, so cannot navigate to ").append(string).append(ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_DOT, true, false)).toString());
            }
            string6 = element2.getAttribute(string5);
            element = XmlUtils.getChildWithAttributeValue(this.mRoot, string2, string6);
            if (element == null) break;
        }
        return element;
    }

    protected String getTopLevelTypeAttribute() {
        return "type";
    }

    protected String getNameAttribute() {
        return "name";
    }

    protected String getTypeAttribute() {
        return "type";
    }

    protected String getExtendsAttribute() {
        return null;
    }

    private boolean isRestrictedAgainstObject(Object object, String string, String[] stringArray) {
        if (object == null) {
            if (stringArray != null && stringArray.length > 0) {
                return true;
            }
            Class<?> clazz = ClassUtils.niceForName(string);
            if (clazz == null) {
                return false;
            }
            return false;
        }
        Class<?> clazz = ClassUtils.niceForName(string, object.getClass().getClassLoader());
        if (clazz == null || !clazz.isAssignableFrom(object.getClass())) {
            return false;
        }
        Object object2 = object;
        if (stringArray != null && stringArray.length > 0) {
            HashSet hashSet = CollectionUtils.newHashSet();
            hashSet.add(object2);
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String string2 = stringArray[i];
                Property property = this.mRestrictAgainstObject.getProperties(object2.getClass()).get(string2);
                if (property == null || !property.isReadable()) {
                    return true;
                }
                if (!hashSet.add(object2 = property.read(object2))) {
                    this.mLog.trace(new StringBuffer().append(ClassUtils.getSimpleName(this.getClass())).append(" prevented infinite recursion on ").append(string).append(ArrayUtils.toString(stringArray, StringUtils.SEPARATOR_FORWARD_SLASH, true, false)).append(". Consider marking ").append(string2).append(" as hidden='true'").toString());
                    return true;
                }
                if (object2 == null) {
                    return true;
                }
                clazz = property.getType();
            }
        }
        return false;
    }
}

