/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.groovy;

import groovy.lang.GroovySystem;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.codehaus.groovy.reflection.CachedField;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.BaseProperty;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyle;
import org.metawidget.inspector.impl.propertystyle.BasePropertyStyleConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyPropertyStyle
extends BasePropertyStyle {
    public GroovyPropertyStyle() {
        this(new BasePropertyStyleConfig());
    }

    public GroovyPropertyStyle(BasePropertyStyleConfig basePropertyStyleConfig) {
        super(basePropertyStyleConfig);
    }

    @Override
    protected Map<String, Property> inspectProperties(Class<?> clazz) {
        TreeMap<String, Property> treeMap = CollectionUtils.newTreeMap();
        List list = GroovySystem.getMetaClassRegistry().getMetaClass(clazz).getProperties();
        for (MetaProperty metaProperty : list) {
            Class<?> clazz2;
            if (!(metaProperty instanceof MetaBeanProperty)) continue;
            MetaBeanProperty metaBeanProperty = (MetaBeanProperty)metaProperty;
            String string = metaBeanProperty.getName();
            Class clazz3 = metaBeanProperty.getType();
            if (!Modifier.isPublic(metaBeanProperty.getModifiers()) || this.isExcluded(clazz2 = metaBeanProperty.getGetter() != null ? ClassUtils.niceForName(metaBeanProperty.getGetter().getDeclaringClass().getName()) : (metaBeanProperty.getSetter() != null ? ClassUtils.niceForName(metaBeanProperty.getSetter().getDeclaringClass().getName()) : clazz), string, clazz3)) continue;
            treeMap.put(string, new GroovyProperty((MetaBeanProperty)metaProperty, clazz));
        }
        return treeMap;
    }

    @Override
    protected boolean isExcludedBaseType(Class<?> clazz) {
        if (clazz == null) {
            return false;
        }
        String string = clazz.getName();
        if (string.startsWith("org.groovy.")) {
            return true;
        }
        return super.isExcludedBaseType(clazz);
    }

    @Override
    protected boolean isExcludedName(String string) {
        if ("metaClass".equals(string)) {
            return true;
        }
        return super.isExcludedName(string);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GroovyProperty
    extends BaseProperty {
        private MetaBeanProperty mProperty;
        private Field mField;
        private Method mGetterMethod;
        private Method mSetterMethod;

        public GroovyProperty(MetaBeanProperty metaBeanProperty, Class<?> clazz) {
            super(metaBeanProperty.getName(), metaBeanProperty.getType());
            this.mProperty = metaBeanProperty;
            try {
                MetaMethod metaMethod;
                MetaMethod metaMethod2;
                CachedField cachedField = this.mProperty.getField();
                if (cachedField != null) {
                    this.mField = cachedField.field;
                }
                if ((metaMethod2 = this.mProperty.getGetter()) != null) {
                    this.mGetterMethod = clazz.getMethod(metaMethod2.getName(), new Class[0]);
                }
                if ((metaMethod = this.mProperty.getSetter()) != null) {
                    this.mSetterMethod = clazz.getMethod(metaMethod.getName(), metaMethod.getNativeParameterTypes());
                }
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public boolean isReadable() {
            return this.mProperty.getGetter() != null;
        }

        @Override
        public Object read(Object object) {
            try {
                return this.mProperty.getProperty(object);
            }
            catch (Exception exception) {
                throw InspectorException.newException(exception);
            }
        }

        @Override
        public boolean isWritable() {
            return this.mProperty.getSetter() != null;
        }

        @Override
        public <T extends Annotation> T getAnnotation(Class<T> clazz) {
            if (this.mField != null) {
                return this.mField.getAnnotation(clazz);
            }
            if (this.mGetterMethod != null) {
                return this.mGetterMethod.getAnnotation(clazz);
            }
            if (this.mSetterMethod != null) {
                return this.mSetterMethod.getAnnotation(clazz);
            }
            throw InspectorException.newException(new StringBuffer().append("Don't know how to getAnnotation from ").append(this.getName()).toString());
        }

        @Override
        public Type getGenericType() {
            if (this.mField != null) {
                return this.mField.getGenericType();
            }
            if (this.mGetterMethod != null) {
                return this.mGetterMethod.getGenericReturnType();
            }
            if (this.mSetterMethod != null) {
                return this.mSetterMethod.getGenericParameterTypes()[0];
            }
            throw InspectorException.newException(new StringBuffer().append("Don't know how to getGenericType from ").append(this.getName()).toString());
        }
    }
}

