/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl.propertystyle.javassist;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.MethodInfo;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.impl.propertystyle.javabean.JavaBeanPropertyStyle;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistPropertyStyle
extends JavaBeanPropertyStyle {
    @Override
    protected Map<String, Property> inspectProperties(Class<?>[] classArray) {
        LinkedHashMap<String, Property> linkedHashMap = CollectionUtils.newLinkedHashMap();
        for (Class<?> clazz : classArray) {
            Map<String, Property> map = this.getCachedProperties(clazz);
            if (map == null) {
                map = this.inspectProperties(clazz);
                this.cacheProperties(clazz, map);
            }
            linkedHashMap.putAll(map);
        }
        return linkedHashMap;
    }

    @Override
    protected Map<String, Property> inspectProperties(Class<?> clazz) {
        try {
            TreeMap<ClassAndLineNumberAndName, Property> treeMap = CollectionUtils.newTreeMap();
            ClassPool classPool = ClassPool.getDefault();
            CtClass ctClass = classPool.get(clazz.getName());
            Map<String, Property> map = super.inspectProperties(clazz);
            for (Property object : map.values()) {
                JavaBeanPropertyStyle.FieldProperty fieldProperty;
                Object object2 = object.getName();
                if (object instanceof JavaBeanPropertyStyle.JavaBeanProperty) {
                    fieldProperty = null;
                    JavaBeanPropertyStyle.JavaBeanProperty javaBeanProperty = (JavaBeanPropertyStyle.JavaBeanProperty)object;
                    Method method = javaBeanProperty.getReadMethod();
                    if (method != null) {
                        fieldProperty = this.getCtMethod(ctClass, method, new CtClass[0]);
                    } else {
                        method = javaBeanProperty.getWriteMethod();
                        fieldProperty = this.getCtMethod(ctClass, method, new CtClass[]{classPool.get(object.getType().getName())});
                    }
                    MethodInfo methodInfo = fieldProperty.getMethodInfo();
                    int n = methodInfo.getLineNumber(0);
                    if (n == -1 && !ctClass.isInterface()) {
                        throw InspectorException.newException(new StringBuffer().append("Line number information for ").append(clazz).append(" not available. Did you compile without debug info?").toString());
                    }
                    treeMap.put(new ClassAndLineNumberAndName(method.getDeclaringClass(), n, (String)object2), object);
                    continue;
                }
                if (object instanceof JavaBeanPropertyStyle.FieldProperty) {
                    fieldProperty = (JavaBeanPropertyStyle.FieldProperty)object;
                    treeMap.put(new ClassAndLineNumberAndName(fieldProperty.getField().getDeclaringClass(), 0, (String)object2), object);
                    continue;
                }
                throw InspectorException.newException(new StringBuffer().append("Unknown property type ").append(object.getClass()).toString());
            }
            LinkedHashMap linkedHashMap = CollectionUtils.newLinkedHashMap();
            for (Object object2 : treeMap.values()) {
                linkedHashMap.put(object2.getName(), object2);
            }
            return linkedHashMap;
        }
        catch (Exception exception) {
            throw InspectorException.newException(exception);
        }
    }

    private CtMethod getCtMethod(CtClass ctClass, Method method, CtClass[] ctClassArray) throws NotFoundException {
        CtClass ctClass2 = ctClass;
        while (true) {
            try {
                return ctClass2.getDeclaredMethod(method.getName(), ctClassArray);
            }
            catch (NotFoundException notFoundException) {
                ctClass2 = ctClass2.getSuperclass();
                continue;
            }
            break;
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ClassAndLineNumberAndName
    implements Comparable<ClassAndLineNumberAndName> {
        private Class<?> mClass;
        private int mLineNumber;
        private String mName;

        public ClassAndLineNumberAndName(Class<?> clazz, int n, String string) {
            this.mClass = clazz;
            this.mLineNumber = n;
            this.mName = string;
        }

        @Override
        public int compareTo(ClassAndLineNumberAndName classAndLineNumberAndName) {
            if (!this.mClass.equals(classAndLineNumberAndName.mClass)) {
                if (this.mClass.isAssignableFrom(classAndLineNumberAndName.mClass)) {
                    return -1;
                }
                return 1;
            }
            if (this.mLineNumber != classAndLineNumberAndName.mLineNumber) {
                return this.mLineNumber - classAndLineNumberAndName.mLineNumber;
            }
            return this.mName.compareTo(classAndLineNumberAndName.mName);
        }

        @Override
        public /* synthetic */ int compareTo(Object object) {
            return this.compareTo((ClassAndLineNumberAndName)object);
        }
    }
}

