/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.jpa;

import java.util.HashMap;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.jpa.JpaInspectorConfig;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JpaInspector
extends BaseObjectInspector {
    private final boolean mHideIds;

    public JpaInspector() {
        this(new JpaInspectorConfig());
    }

    public JpaInspector(JpaInspectorConfig jpaInspectorConfig) {
        super(jpaInspectorConfig);
        this.mHideIds = jpaInspectorConfig.isHideIds();
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        ManyToOne manyToOne;
        Column column;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(Lob.class)) {
            hashMap.put("large", "true");
        }
        if ((column = property.getAnnotation(Column.class)) != null) {
            if (!column.nullable()) {
                hashMap.put("required", "true");
            }
            if (column.length() != 255) {
                hashMap.put("maximum-length", String.valueOf(column.length()));
            }
        }
        if ((manyToOne = property.getAnnotation(ManyToOne.class)) != null && !manyToOne.optional()) {
            hashMap.put("required", "true");
        }
        if (this.mHideIds && property.isAnnotationPresent(Id.class)) {
            hashMap.put("hidden", "true");
        }
        return hashMap;
    }
}

