/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.jsp;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.PageContext;
import javax.servlet.jsp.el.ExpressionEvaluator;
import javax.servlet.jsp.el.VariableResolver;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.Trait;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.inspector.jsp.UiJspAttribute;
import org.metawidget.inspector.jsp.UiJspAttributes;
import org.metawidget.inspector.jsp.UiJspLookup;
import org.metawidget.jsp.JspUtils;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.ThreadUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JspAnnotationInspector
extends BaseObjectInspector {
    private static final ThreadLocal<PageContext> LOCAL_PAGE_CONTEXT = ThreadUtils.newThreadLocal();

    public static void setThreadLocalPageContext(PageContext pageContext) {
        LOCAL_PAGE_CONTEXT.set(pageContext);
    }

    public JspAnnotationInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public JspAnnotationInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    @Override
    protected Map<String, String> inspectTrait(Trait trait) throws Exception {
        ExpressionEvaluator expressionEvaluator;
        UiJspAttributes uiJspAttributes = trait.getAnnotation(UiJspAttributes.class);
        UiJspAttribute uiJspAttribute = trait.getAnnotation(UiJspAttribute.class);
        if (uiJspAttributes == null && uiJspAttribute == null) {
            return null;
        }
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        PageContext pageContext = LOCAL_PAGE_CONTEXT.get();
        if (pageContext == null) {
            throw InspectorException.newException("ThreadLocalPageContext not set");
        }
        try {
            expressionEvaluator = pageContext.getExpressionEvaluator();
        }
        catch (Throwable throwable) {
            throw InspectorException.newException("ExpressionEvaluator requires JSP 2.0");
        }
        VariableResolver variableResolver = pageContext.getVariableResolver();
        if (uiJspAttribute != null) {
            this.putJspAttribute(expressionEvaluator, variableResolver, hashMap, uiJspAttribute);
        }
        if (uiJspAttributes != null) {
            for (UiJspAttribute uiJspAttribute2 : uiJspAttributes.value()) {
                this.putJspAttribute(expressionEvaluator, variableResolver, hashMap, uiJspAttribute2);
            }
        }
        return hashMap;
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        UiJspLookup uiJspLookup = property.getAnnotation(UiJspLookup.class);
        if (uiJspLookup != null) {
            hashMap.put("jsp-lookup", uiJspLookup.value());
        }
        return hashMap;
    }

    protected void putJspAttribute(ExpressionEvaluator expressionEvaluator, VariableResolver variableResolver, Map<String, String> map, UiJspAttribute uiJspAttribute) throws Exception {
        String string = uiJspAttribute.expression();
        if (!JspUtils.isExpression(string)) {
            throw InspectorException.newException("Expression '" + string + "' is not of the form ${...}");
        }
        Object object = expressionEvaluator.evaluate(string, Object.class, variableResolver, null);
        if (object == null) {
            return;
        }
        if (object instanceof Collection) {
            map.put(uiJspAttribute.name(), CollectionUtils.toString((Collection)object));
        } else if (object instanceof Object[]) {
            map.put(uiJspAttribute.name(), ArrayUtils.toString((Object[])object));
        } else {
            map.put(uiJspAttribute.name(), StringUtils.quietValueOf(object));
        }
    }
}

