/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.oval;

import java.util.HashMap;
import java.util.Map;
import net.sf.oval.constraint.Length;
import net.sf.oval.constraint.Max;
import net.sf.oval.constraint.MaxLength;
import net.sf.oval.constraint.Min;
import net.sf.oval.constraint.MinLength;
import net.sf.oval.constraint.NotBlank;
import net.sf.oval.constraint.NotEmpty;
import net.sf.oval.constraint.NotNull;
import net.sf.oval.constraint.Range;
import org.metawidget.inspector.impl.BaseObjectInspector;
import org.metawidget.inspector.impl.BaseObjectInspectorConfig;
import org.metawidget.inspector.impl.propertystyle.Property;
import org.metawidget.util.CollectionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OvalInspector
extends BaseObjectInspector {
    public OvalInspector() {
        this(new BaseObjectInspectorConfig());
    }

    public OvalInspector(BaseObjectInspectorConfig baseObjectInspectorConfig) {
        super(baseObjectInspectorConfig);
    }

    @Override
    protected Map<String, String> inspectProperty(Property property) throws Exception {
        MaxLength maxLength;
        MinLength minLength;
        Length length;
        Max max;
        Min min;
        Range range;
        HashMap<String, String> hashMap = CollectionUtils.newHashMap();
        if (property.isAnnotationPresent(NotNull.class)) {
            hashMap.put("required", "true");
        }
        if (property.isAnnotationPresent(NotEmpty.class)) {
            hashMap.put("required", "true");
        }
        if (property.isAnnotationPresent(NotBlank.class)) {
            hashMap.put("required", "true");
        }
        if ((range = property.getAnnotation(Range.class)) != null) {
            hashMap.put("maximum-value", this.niceValueOf(range.max()));
            hashMap.put("minimum-value", this.niceValueOf(range.min()));
        }
        if ((min = property.getAnnotation(Min.class)) != null) {
            hashMap.put("minimum-value", this.niceValueOf(min.value()));
        }
        if ((max = property.getAnnotation(Max.class)) != null) {
            hashMap.put("maximum-value", this.niceValueOf(max.value()));
        }
        if ((length = property.getAnnotation(Length.class)) != null) {
            if (length.min() > 0) {
                hashMap.put("minimum-length", String.valueOf(length.min()));
            }
            if (length.max() > 0) {
                hashMap.put("maximum-length", String.valueOf(length.max()));
            }
        }
        if ((minLength = property.getAnnotation(MinLength.class)) != null) {
            hashMap.put("minimum-length", String.valueOf(minLength.value()));
        }
        if ((maxLength = property.getAnnotation(MaxLength.class)) != null) {
            hashMap.put("maximum-length", String.valueOf(maxLength.value()));
        }
        return hashMap;
    }

    private String niceValueOf(double d) {
        if (d % 1.0 == 0.0) {
            return String.valueOf(Double.valueOf(d).intValue());
        }
        return String.valueOf(d);
    }
}

