/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.seam;

import java.io.InputStream;
import org.metawidget.config.NeedsResourceResolver;
import org.metawidget.config.ResourceResolver;
import org.metawidget.inspector.iface.InspectorException;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.simple.ObjectUtils;

public class SeamInspectorConfig
implements NeedsResourceResolver {
    private ResourceResolver mResourceResolver;
    private InputStream mComponentsInputStream;

    public InputStream getComponentsInputStream() {
        if (this.mComponentsInputStream != null) {
            return this.mComponentsInputStream;
        }
        return this.getResourceResolver().openResource("components.xml");
    }

    public SeamInspectorConfig setComponentsInputStream(InputStream inputStream) {
        this.mComponentsInputStream = inputStream;
        return this;
    }

    public ResourceResolver getResourceResolver() {
        if (this.mResourceResolver == null) {
            return new ResourceResolver(){

                public InputStream openResource(String string) {
                    try {
                        return ClassUtils.openResource(string);
                    }
                    catch (Exception exception) {
                        throw InspectorException.newException(exception);
                    }
                }
            };
        }
        return this.mResourceResolver;
    }

    public void setResourceResolver(ResourceResolver resourceResolver) {
        this.mResourceResolver = resourceResolver;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mResourceResolver, ((SeamInspectorConfig)object).mResourceResolver)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mComponentsInputStream, ((SeamInspectorConfig)object).mComponentsInputStream);
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mResourceResolver);
        n = 31 * n + ObjectUtils.nullSafeHashCode(this.mComponentsInputStream);
        return n;
    }
}

