/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.jsp.tagext.html.layout;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.BodyTag;
import javax.servlet.jsp.tagext.Tag;
import org.metawidget.jsp.JspUtils;
import org.metawidget.jsp.tagext.FacetTag;
import org.metawidget.jsp.tagext.MetawidgetTag;
import org.metawidget.jsp.tagext.StubTag;
import org.metawidget.jsp.tagext.html.layout.HtmlTableLayoutConfig;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.layout.iface.LayoutException;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.SimpleLayoutUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HtmlTableLayout
implements AdvancedLayout<Tag, BodyTag, MetawidgetTag> {
    private static final String TABLE_PREFIX = "table-";
    private static final String ROW_SUFFIX = "-row";
    private static final String CELL_SUFFIX = "-cell";
    private static final int JUST_COMPONENT_AND_REQUIRED = 2;
    private static final int LABEL_AND_COMPONENT_AND_REQUIRED = 3;
    private final int mNumberOfColumns;
    private final String mTableStyle;
    private final String mTableStyleClass;
    private final String[] mColumnStyleClasses;
    private final String mFooterStyle;
    private final String mFooterStyleClass;
    static /* synthetic */ Class class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout;

    public HtmlTableLayout() {
        this(new HtmlTableLayoutConfig());
    }

    public HtmlTableLayout(HtmlTableLayoutConfig htmlTableLayoutConfig) {
        this.mNumberOfColumns = htmlTableLayoutConfig.getNumberOfColumns();
        this.mTableStyle = htmlTableLayoutConfig.getTableStyle();
        this.mTableStyleClass = htmlTableLayoutConfig.getTableStyleClass();
        this.mColumnStyleClasses = htmlTableLayoutConfig.getColumnStyleClasses();
        this.mFooterStyle = htmlTableLayoutConfig.getFooterStyle();
        this.mFooterStyleClass = htmlTableLayoutConfig.getFooterStyleClass();
    }

    @Override
    public void onStartBuild(MetawidgetTag metawidgetTag) {
        metawidgetTag.putClientProperty(class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout == null ? (class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout = HtmlTableLayout.class$("org.metawidget.jsp.tagext.html.layout.HtmlTableLayout")) : class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout, null);
    }

    @Override
    public void startContainerLayout(BodyTag bodyTag, MetawidgetTag metawidgetTag) {
        State state = this.getState(metawidgetTag);
        try {
            JspWriter jspWriter = metawidgetTag.getPageContext().getOut();
            jspWriter.write("<table");
            jspWriter.write(" id=\"");
            jspWriter.write(TABLE_PREFIX);
            state.tableType = StringUtils.camelCase(metawidgetTag.getPath(), '.');
            jspWriter.write(state.tableType);
            jspWriter.write("\"");
            if (this.mTableStyle != null) {
                jspWriter.write(" style=\"");
                jspWriter.write(this.mTableStyle);
                jspWriter.write("\"");
            }
            if (this.mTableStyleClass != null) {
                jspWriter.write(" class=\"");
                jspWriter.write(this.mTableStyleClass);
                jspWriter.write("\"");
            }
            jspWriter.write(">");
            FacetTag facetTag = metawidgetTag.getFacet("footer");
            if (facetTag != null) {
                jspWriter.write("\r\n<tfoot>");
                jspWriter.write("<tr>");
                jspWriter.write("<td colspan=\"");
                int n = Math.max(2, this.mNumberOfColumns * 3);
                jspWriter.write(String.valueOf(n));
                jspWriter.write("\"");
                if (this.mFooterStyle != null) {
                    jspWriter.write(" style=\"");
                    jspWriter.write(this.mFooterStyle);
                    jspWriter.write("\"");
                }
                if (this.mFooterStyleClass != null) {
                    jspWriter.write(" class=\"");
                    jspWriter.write(this.mFooterStyleClass);
                    jspWriter.write("\"");
                }
                jspWriter.write(">");
                jspWriter.write(facetTag.getSavedBodyContent());
                jspWriter.write("</td>");
                jspWriter.write("</tr>");
                jspWriter.write("</tfoot>");
            }
            jspWriter.write("<tbody>");
        }
        catch (Exception exception) {
            throw LayoutException.newException(exception);
        }
    }

    @Override
    public void layoutWidget(Tag tag, String string, Map<String, String> map, BodyTag bodyTag, MetawidgetTag metawidgetTag) {
        try {
            String string2 = null;
            if (tag instanceof StubTag) {
                string2 = ((StubTag)tag).getSavedBodyContent();
                if (string2 == null || string2.length() == 0) {
                    return;
                }
            } else {
                string2 = JspUtils.writeTag(metawidgetTag.getPageContext(), tag, (Tag)bodyTag, null);
            }
            if (JspUtils.isJustHiddenFields(string2)) {
                State state = this.getState(metawidgetTag);
                if (state.hiddenFields == null) {
                    state.hiddenFields = CollectionUtils.newHashSet();
                }
                state.hiddenFields.add(string2);
                return;
            }
            JspWriter jspWriter = metawidgetTag.getPageContext().getOut();
            this.layoutBeforeChild(tag, string, map, metawidgetTag);
            jspWriter.write(string2);
            this.layoutAfterChild(map, metawidgetTag);
        }
        catch (Exception exception) {
            throw LayoutException.newException(exception);
        }
    }

    @Override
    public void endContainerLayout(BodyTag bodyTag, MetawidgetTag metawidgetTag) {
    }

    @Override
    public void onEndBuild(MetawidgetTag metawidgetTag) {
        try {
            JspWriter jspWriter = metawidgetTag.getPageContext().getOut();
            jspWriter.write("</tbody>");
            jspWriter.write("</table>");
            State state = this.getState(metawidgetTag);
            if (state.hiddenFields != null) {
                for (String string : state.hiddenFields) {
                    jspWriter.write("\r\n");
                    jspWriter.write(string);
                }
            }
        }
        catch (IOException iOException) {
            throw LayoutException.newException(iOException);
        }
    }

    protected void layoutBeforeChild(Tag tag, String string, Map<String, String> map, MetawidgetTag metawidgetTag) {
        State state = this.getState(metawidgetTag);
        ++state.currentColumn;
        try {
            int n;
            JspWriter jspWriter = metawidgetTag.getPageContext().getOut();
            String string2 = null;
            if (map != null) {
                string2 = map.get("name");
                if (string2 != null) {
                    string2 = StringUtils.uppercaseFirstLetter(StringUtils.camelCase(string2));
                }
                if (SimpleLayoutUtils.isSpanAllColumns(map) && state.currentColumn != 1) {
                    jspWriter.write("</tr>");
                    state.currentColumn = 1;
                }
            }
            if (state.currentColumn == 1 || state.currentColumn > this.mNumberOfColumns) {
                state.currentColumn = 1;
                jspWriter.write("\r\n<tr");
                if (string2 != null) {
                    jspWriter.write(" id=\"");
                    jspWriter.write(TABLE_PREFIX);
                    jspWriter.write(state.tableType);
                    jspWriter.write(string2);
                    jspWriter.write(ROW_SUFFIX);
                    jspWriter.write("\"");
                }
                jspWriter.write(">");
            }
            boolean bl = this.layoutLabel(string, map, metawidgetTag);
            if (this.mNumberOfColumns == 0) {
                jspWriter.write("</tr>\r\n<tr");
                if (string2 != null) {
                    jspWriter.write(" id=\"");
                    jspWriter.write(TABLE_PREFIX);
                    jspWriter.write(state.tableType);
                    jspWriter.write(string2);
                    jspWriter.write(ROW_SUFFIX);
                    jspWriter.write("2\"");
                }
                jspWriter.write(">");
            }
            jspWriter.write("<td");
            if (string2 != null) {
                jspWriter.write(" id=\"");
                jspWriter.write(TABLE_PREFIX);
                jspWriter.write(state.tableType);
                jspWriter.write(string2);
                jspWriter.write(CELL_SUFFIX);
                jspWriter.write("\"");
            }
            this.writeStyleClass(1, metawidgetTag);
            if (tag instanceof MetawidgetTag || SimpleLayoutUtils.isSpanAllColumns(map)) {
                n = this.mNumberOfColumns * 3 - 2;
                state.currentColumn = this.mNumberOfColumns;
                if (!bl) {
                    ++n;
                }
                if (tag instanceof MetawidgetTag) {
                    ++n;
                }
            } else {
                n = !bl ? 2 : 1;
            }
            if (n > 1) {
                jspWriter.write(" colspan=\"");
                jspWriter.write(String.valueOf(n));
                jspWriter.write("\"");
            }
            jspWriter.write(">");
        }
        catch (IOException iOException) {
            throw LayoutException.newException(iOException);
        }
    }

    protected void layoutAfterChild(Map<String, String> map, MetawidgetTag metawidgetTag) {
        try {
            JspWriter jspWriter = metawidgetTag.getPageContext().getOut();
            jspWriter.write("</td>");
            jspWriter.write("<td");
            State state = this.getState(metawidgetTag);
            this.writeStyleClass(2, metawidgetTag);
            jspWriter.write(">");
            jspWriter.write(this.layoutRequired(map, metawidgetTag));
            jspWriter.write("</td>");
            if (state.currentColumn >= this.mNumberOfColumns) {
                state.currentColumn = 0;
                jspWriter.write("</tr>");
            }
        }
        catch (IOException iOException) {
            throw LayoutException.newException(iOException);
        }
    }

    protected boolean layoutLabel(String string, Map<String, String> map, MetawidgetTag metawidgetTag) {
        String string2 = metawidgetTag.getLabelString(map);
        if (string2 == null) {
            return false;
        }
        try {
            JspWriter jspWriter = metawidgetTag.getPageContext().getOut();
            jspWriter.write("<th");
            this.writeStyleClass(0, metawidgetTag);
            jspWriter.write(">");
            if (SimpleLayoutUtils.needsLabel(string2, string)) {
                jspWriter.write(string2);
                jspWriter.write(":");
            }
            jspWriter.write("</th>");
            return true;
        }
        catch (IOException iOException) {
            throw LayoutException.newException(iOException);
        }
    }

    protected String layoutRequired(Map<String, String> map, MetawidgetTag metawidgetTag) {
        if (map != null && "true".equals(map.get("required")) && !"true".equals(map.get("read-only")) && !metawidgetTag.isReadOnly()) {
            return "*";
        }
        return "<div></div>";
    }

    protected void writeStyleClass(int n, MetawidgetTag metawidgetTag) {
        if (this.mColumnStyleClasses == null || this.mColumnStyleClasses.length <= n) {
            return;
        }
        String string = this.mColumnStyleClasses[n];
        if (string.length() == 0) {
            return;
        }
        try {
            JspWriter jspWriter = metawidgetTag.getPageContext().getOut();
            jspWriter.write(" class=\"");
            jspWriter.write(string.trim());
            jspWriter.write("\"");
        }
        catch (IOException iOException) {
            throw LayoutException.newException(iOException);
        }
    }

    private State getState(MetawidgetTag metawidgetTag) {
        State state = (State)metawidgetTag.getClientProperty(class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout == null ? (class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout = HtmlTableLayout.class$("org.metawidget.jsp.tagext.html.layout.HtmlTableLayout")) : class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout);
        if (state == null) {
            state = new State();
            metawidgetTag.putClientProperty(class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout == null ? (class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout = HtmlTableLayout.class$("org.metawidget.jsp.tagext.html.layout.HtmlTableLayout")) : class$org$metawidget$jsp$tagext$html$layout$HtmlTableLayout, state);
        }
        return state;
    }

    @Override
    public /* synthetic */ void onEndBuild(Object object) {
        this.onEndBuild((MetawidgetTag)((Object)object));
    }

    @Override
    public /* synthetic */ void endContainerLayout(Object object, Object object2) {
        this.endContainerLayout((BodyTag)object, (MetawidgetTag)((Object)object2));
    }

    @Override
    public /* synthetic */ void startContainerLayout(Object object, Object object2) {
        this.startContainerLayout((BodyTag)object, (MetawidgetTag)((Object)object2));
    }

    @Override
    public /* synthetic */ void onStartBuild(Object object) {
        this.onStartBuild((MetawidgetTag)((Object)object));
    }

    @Override
    public /* synthetic */ void layoutWidget(Object object, String string, Map map, Object object2, Object object3) {
        this.layoutWidget((Tag)object, string, (Map<String, String>)map, (BodyTag)object2, (MetawidgetTag)((Object)object3));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    static class State {
        public int currentColumn;
        public Set<String> hiddenFields;
        public String tableType;

        State() {
        }
    }
}

