/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swing;

import java.awt.BasicStroke;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import org.metawidget.config.ConfigReader;
import org.metawidget.iface.MetawidgetException;
import org.metawidget.inspectionresultprocessor.iface.InspectionResultProcessor;
import org.metawidget.inspector.iface.Inspector;
import org.metawidget.layout.iface.Layout;
import org.metawidget.pipeline.w3c.W3CPipeline;
import org.metawidget.swing.Facet;
import org.metawidget.swing.Stub;
import org.metawidget.swing.SwingValuePropertyProvider;
import org.metawidget.util.ArrayUtils;
import org.metawidget.util.ClassUtils;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.Pair;
import org.metawidget.util.simple.PathUtils;
import org.metawidget.util.simple.StringUtils;
import org.metawidget.widgetbuilder.composite.CompositeWidgetBuilder;
import org.metawidget.widgetbuilder.iface.WidgetBuilder;
import org.metawidget.widgetprocessor.iface.WidgetProcessor;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SwingMetawidget
extends JComponent {
    private static final long serialVersionUID = 1L;
    private static final ConfigReader CONFIG_READER = new ConfigReader();
    private static final String DEFAULT_CONFIG = "org/metawidget/swing/metawidget-swing-default.xml";
    private static final Stroke STROKE_DOTTED = new BasicStroke(1.0f, 1, 1, 0.0f, new float[]{3.0f}, 0.0f);
    private Object mToInspect;
    private String mPath;
    private String mConfig;
    private boolean mNeedsConfiguring = true;
    private ResourceBundle mBundle;
    private boolean mNeedToBuildWidgets;
    private Element mLastInspection;
    private boolean mIgnoreAddRemove;
    private List<JComponent> mExistingComponents = CollectionUtils.newArrayList();
    private List<JComponent> mExistingUnusedComponents;
    private Map<String, Facet> mFacets = CollectionUtils.newHashMap();
    Pipeline mPipeline = this.newPipeline();
    static /* synthetic */ Class class$org$metawidget$swing$SwingMetawidget;

    public void setToInspect(Object object) {
        this.updateToInspectWithoutInvalidate(object);
        this.invalidateInspection();
    }

    public void updateToInspectWithoutInvalidate(Object object) {
        if (this.mToInspect == null) {
            if (this.mPath == null && object != null) {
                this.mPath = ClassUtils.getUnproxiedClass(object.getClass()).getName();
            }
        } else if (ClassUtils.getUnproxiedClass(this.mToInspect.getClass()).getName().equals(this.mPath)) {
            this.mPath = object == null ? null : ClassUtils.getUnproxiedClass(object.getClass()).getName();
        }
        this.mToInspect = object;
    }

    public <T> T getToInspect() {
        return (T)this.mToInspect;
    }

    public void setPath(String string) {
        this.mPath = string;
        this.invalidateInspection();
    }

    public String getPath() {
        return this.mPath;
    }

    public void setConfig(String string) {
        this.mConfig = string;
        this.mNeedsConfiguring = true;
        this.invalidateInspection();
    }

    public void setInspector(Inspector inspector) {
        this.mPipeline.setInspector(inspector);
        this.invalidateInspection();
    }

    public void addInspectionResultProcessor(InspectionResultProcessor<Element, SwingMetawidget> inspectionResultProcessor) {
        this.mPipeline.addInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateWidgets();
    }

    public void removeInspectionResultProcessor(InspectionResultProcessor<Element, SwingMetawidget> inspectionResultProcessor) {
        this.mPipeline.removeInspectionResultProcessor(inspectionResultProcessor);
        this.invalidateWidgets();
    }

    public void setInspectionResultProcessors(InspectionResultProcessor<Element, SwingMetawidget>[] inspectionResultProcessorArray) {
        this.mPipeline.setInspectionResultProcessors(CollectionUtils.newArrayList(inspectionResultProcessorArray));
        this.invalidateWidgets();
    }

    public void setWidgetBuilder(WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder) {
        this.mPipeline.setWidgetBuilder(widgetBuilder);
        this.invalidateWidgets();
    }

    public void addWidgetProcessor(WidgetProcessor<JComponent, SwingMetawidget> widgetProcessor) {
        this.mPipeline.addWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void removeWidgetProcessor(WidgetProcessor<JComponent, SwingMetawidget> widgetProcessor) {
        this.mPipeline.removeWidgetProcessor(widgetProcessor);
        this.invalidateWidgets();
    }

    public void setWidgetProcessors(WidgetProcessor<JComponent, SwingMetawidget>[] widgetProcessorArray) {
        this.mPipeline.setWidgetProcessors(CollectionUtils.newArrayList(widgetProcessorArray));
        this.invalidateWidgets();
    }

    public <T> T getWidgetProcessor(Class<T> clazz) {
        this.buildWidgets();
        return this.mPipeline.getWidgetProcessor(clazz);
    }

    public void setMetawidgetLayout(Layout<JComponent, JComponent, SwingMetawidget> layout) {
        this.mPipeline.setLayout(layout);
        this.invalidateWidgets();
    }

    public void setBundle(ResourceBundle resourceBundle) {
        this.mBundle = resourceBundle;
        this.invalidateWidgets();
    }

    public String getLabelString(Map<String, String> map) {
        if (map == null) {
            return "";
        }
        String string = map.get("label");
        if (string != null) {
            if ("".equals(string)) {
                return null;
            }
            String string2 = this.getLocalizedKey(StringUtils.camelCase(string));
            if (string2 != null) {
                return string2.trim();
            }
            return string.trim();
        }
        String string3 = map.get("name");
        if (string3 != null) {
            String string4 = this.getLocalizedKey(string3);
            if (string4 != null) {
                return string4.trim();
            }
            return StringUtils.uncamelCase(string3);
        }
        return "";
    }

    public String getLocalizedKey(String string) {
        if (this.mBundle == null) {
            return null;
        }
        try {
            return this.mBundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return new StringBuffer().append("???").append(string).append("???").toString();
        }
    }

    public boolean isReadOnly() {
        return this.mPipeline.isReadOnly();
    }

    public void setReadOnly(boolean bl) {
        if (this.mPipeline.isReadOnly() == bl) {
            return;
        }
        this.mPipeline.setReadOnly(bl);
        this.invalidateWidgets();
    }

    public int getMaximumInspectionDepth() {
        return this.mPipeline.getMaximumInspectionDepth();
    }

    public void setMaximumInspectionDepth(int n) {
        this.mPipeline.setMaximumInspectionDepth(n);
        this.invalidateWidgets();
    }

    public List<JComponent> fetchExistingUnusedComponents() {
        return this.mExistingUnusedComponents;
    }

    @Override
    public Dimension getPreferredSize() {
        this.buildWidgets();
        return super.getPreferredSize();
    }

    @Override
    public void setBounds(Rectangle rectangle) {
        this.buildWidgets();
        super.setBounds(rectangle);
    }

    @Override
    public Rectangle getBounds(Rectangle rectangle) {
        this.buildWidgets();
        return super.getBounds(rectangle);
    }

    @Override
    public Component getComponent(int n) {
        this.buildWidgets();
        return super.getComponent(n);
    }

    @Override
    public int getComponentCount() {
        this.buildWidgets();
        return super.getComponentCount();
    }

    @Override
    public LayoutManager getLayout() {
        this.buildWidgets();
        return super.getLayout();
    }

    @Override
    public void addNotify() {
        this.buildWidgets();
        super.addNotify();
    }

    public <T> T getValue(String[] stringArray) {
        Pair<Component, String> pair = this.getComponentAndValueProperty(stringArray);
        return ClassUtils.getProperty(pair.getLeft(), pair.getRight());
    }

    public void setValue(Object object, String[] stringArray) {
        Pair<Component, String> pair = this.getComponentAndValueProperty(stringArray);
        ClassUtils.setProperty(pair.getLeft(), pair.getRight(), object);
    }

    public String getValueProperty(Component component) {
        return this.getValueProperty(component, this.mPipeline.getWidgetBuilder());
    }

    public <T extends Component> T getComponent(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        Component component = this;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (component instanceof SwingMetawidget) {
                component.buildWidgets();
            }
            component = this.getComponent((Container)component, string);
            if (i == n - 1) {
                return (T)component;
            }
            if (component != null) continue;
            throw MetawidgetException.newException(new StringBuffer().append("No such component '").append(string).append("' of '").append(ArrayUtils.toString(stringArray, "', '")).append("'").toString());
        }
        return (T)component;
    }

    public Facet getFacet(String string) {
        this.buildWidgets();
        return this.mFacets.get(string);
    }

    @Override
    public void remove(Component component) {
        super.remove(component);
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getName());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    @Override
    public void remove(int n) {
        Component component = this.getComponent(n);
        super.remove(n);
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.remove(((Facet)component).getName());
            } else {
                this.mExistingComponents.remove(component);
            }
        }
    }

    @Override
    public void removeAll() {
        super.removeAll();
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            this.mFacets.clear();
            this.mExistingComponents.clear();
        }
    }

    public Element inspect(Object object, String string, String[] stringArray) {
        return (Element)this.mPipeline.inspect(object, string, stringArray);
    }

    protected Pipeline newPipeline() {
        return new Pipeline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(Graphics graphics) {
        this.buildWidgets();
        super.paintComponent(graphics);
        if (this.mPath == null && this.getComponentCount() == 0) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            Stroke stroke = graphics2D.getStroke();
            try {
                graphics2D.setStroke(STROKE_DOTTED);
                int n = this.getHeight();
                graphics2D.drawRect(0, 0, this.getWidth() - 1, n - 1);
                graphics2D.drawString("Metawidget", 10, n / 2);
            }
            finally {
                graphics2D.setStroke(stroke);
            }
        }
    }

    protected void invalidateInspection() {
        this.mLastInspection = null;
        this.invalidateWidgets();
    }

    protected void invalidateWidgets() {
        if (this.mNeedToBuildWidgets) {
            return;
        }
        super.removeAll();
        this.mNeedToBuildWidgets = true;
        this.repaint();
    }

    @Override
    protected void addImpl(Component component, Object object, int n) {
        if (!this.mIgnoreAddRemove) {
            this.invalidateWidgets();
            if (component instanceof Facet) {
                this.mFacets.put(component.getName(), (Facet)component);
                return;
            }
            if (component instanceof JComponent) {
                this.mExistingComponents.add((JComponent)component);
            }
        }
        super.addImpl(component, object, n);
    }

    protected void configure() {
        if (!this.mNeedsConfiguring) {
            return;
        }
        if (this.mPath == null) {
            return;
        }
        this.mNeedsConfiguring = false;
        try {
            if (this.mConfig != null) {
                CONFIG_READER.configure(this.mConfig, (Object)this, new String[0]);
            }
            if (this.mPipeline.getLayout() == null) {
                CONFIG_READER.configure(DEFAULT_CONFIG, (Object)this, new String[]{"metawidgetLayout"});
            }
            this.mPipeline.configureDefaults(CONFIG_READER, DEFAULT_CONFIG, class$org$metawidget$swing$SwingMetawidget == null ? (class$org$metawidget$swing$SwingMetawidget = SwingMetawidget.class$("org.metawidget.swing.SwingMetawidget")) : class$org$metawidget$swing$SwingMetawidget);
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
    }

    protected void buildWidgets() {
        if (!this.mNeedToBuildWidgets) {
            return;
        }
        this.configure();
        this.mNeedToBuildWidgets = false;
        this.mIgnoreAddRemove = true;
        try {
            if (this.mLastInspection == null) {
                this.mLastInspection = this.inspect();
            }
            if (this.mPath != null || this.getComponentCount() > 0) {
                this.mPipeline.buildWidgets(this.mLastInspection);
            }
        }
        catch (Exception exception) {
            throw MetawidgetException.newException(exception);
        }
        finally {
            this.mIgnoreAddRemove = false;
        }
    }

    protected void startBuild() {
        this.mExistingUnusedComponents = CollectionUtils.newArrayList(this.mExistingComponents);
    }

    protected void layoutWidget(Component component, String string, Map<String, String> map) {
        Component component2 = component;
        if (component2 instanceof JScrollPane) {
            component2 = ((JScrollPane)component2).getViewport().getView();
        }
        component.setName(map.get("name"));
        this.remove(component);
        Map<String, String> map2 = this.mPipeline.getAdditionalAttributes((JComponent)component);
        if (map2 != null) {
            map.putAll(map2);
        }
    }

    protected void endBuild() {
        if (this.mExistingUnusedComponents != null) {
            for (JComponent jComponent : this.mExistingUnusedComponents) {
                if (jComponent instanceof Facet) continue;
                HashMap<String, String> hashMap = CollectionUtils.newHashMap();
                hashMap.put("section", "");
                this.mPipeline.layoutWidget(jComponent, "property", (Map<String, String>)hashMap);
            }
        }
    }

    protected Element inspect() {
        if (this.mPath == null) {
            return null;
        }
        PathUtils.TypeAndNames typeAndNames = PathUtils.parsePath(this.mPath);
        return this.inspect(this.mToInspect, typeAndNames.getType(), typeAndNames.getNamesAsArray());
    }

    protected void initNestedMetawidget(SwingMetawidget swingMetawidget, Map<String, String> map) {
        this.mPipeline.initNestedPipeline(swingMetawidget.mPipeline, map);
        swingMetawidget.setPath(new StringBuffer().append(this.mPath).append('/').append(map.get("name")).toString());
        swingMetawidget.setBundle(this.mBundle);
        swingMetawidget.setOpaque(this.isOpaque());
        swingMetawidget.setToInspect(this.mToInspect);
    }

    private Pair<Component, String> getComponentAndValueProperty(String[] stringArray) {
        String string;
        Object object = this.getComponent(stringArray);
        if (object == null) {
            throw MetawidgetException.newException(new StringBuffer().append("No component named '").append(ArrayUtils.toString(stringArray, "', '")).append("'").toString());
        }
        if (object instanceof JScrollPane) {
            object = ((JScrollPane)object).getViewport().getView();
        }
        if ((string = this.getValueProperty((Component)object)) == null) {
            throw MetawidgetException.newException(new StringBuffer().append("Don't know how to getValue from a ").append(object.getClass().getName()).toString());
        }
        return new Pair<Component, String>((Component)object, string);
    }

    private String getValueProperty(Component component, WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder) {
        try {
            if (widgetBuilder instanceof CompositeWidgetBuilder) {
                for (WidgetBuilder<JComponent, SwingMetawidget> widgetBuilder2 : ((CompositeWidgetBuilder)widgetBuilder).getWidgetBuilders()) {
                    String string = this.getValueProperty(component, widgetBuilder2);
                    if (string == null) continue;
                    return string;
                }
                return null;
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
        if (widgetBuilder instanceof SwingValuePropertyProvider) {
            return ((SwingValuePropertyProvider)((Object)widgetBuilder)).getValueProperty(component);
        }
        return null;
    }

    private Component getComponent(Container container, String string) {
        for (Component component : container.getComponents()) {
            if (!(component.getName() == null && component instanceof Container ? (component = this.getComponent((Container)component, string)) != null : string.equals(component.getName()))) continue;
            return component;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class Pipeline
    extends W3CPipeline<JComponent, JComponent, SwingMetawidget> {
        protected Pipeline() {
        }

        @Override
        protected void startBuild() {
            super.startBuild();
            SwingMetawidget.this.startBuild();
        }

        @Override
        protected void layoutWidget(JComponent jComponent, String string, Map<String, String> map) {
            SwingMetawidget.this.layoutWidget(jComponent, string, map);
            if (this.getLayout() == null) {
                SwingMetawidget.this.add(jComponent);
            } else {
                super.layoutWidget(jComponent, string, map);
            }
        }

        @Override
        protected Map<String, String> getAdditionalAttributes(JComponent jComponent) {
            if (jComponent instanceof Stub) {
                return ((Stub)jComponent).getAttributes();
            }
            return null;
        }

        @Override
        public SwingMetawidget buildNestedMetawidget(Map<String, String> map) throws Exception {
            SwingMetawidget swingMetawidget = (SwingMetawidget)SwingMetawidget.this.getClass().newInstance();
            SwingMetawidget.this.initNestedMetawidget(swingMetawidget, map);
            return swingMetawidget;
        }

        @Override
        protected void endBuild() {
            SwingMetawidget.this.endBuild();
            super.endBuild();
            SwingMetawidget.this.validate();
        }

        @Override
        protected SwingMetawidget getPipelineOwner() {
            return SwingMetawidget.this;
        }

        @Override
        protected /* synthetic */ void layoutWidget(Object object, String string, Map map) {
            this.layoutWidget((JComponent)object, string, (Map<String, String>)map);
        }

        @Override
        protected /* synthetic */ Object getPipelineOwner() {
            return this.getPipelineOwner();
        }

        @Override
        public /* synthetic */ Object buildNestedMetawidget(Map map) throws Exception {
            return this.buildNestedMetawidget(map);
        }

        @Override
        protected /* synthetic */ Map getAdditionalAttributes(Object object) {
            return this.getAdditionalAttributes((JComponent)object);
        }
    }
}

