/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.swt.layout;

import java.util.Map;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.metawidget.layout.iface.AdvancedLayout;
import org.metawidget.swt.Facet;
import org.metawidget.swt.Stub;
import org.metawidget.swt.SwtMetawidget;
import org.metawidget.swt.layout.GridLayoutConfig;
import org.metawidget.util.simple.SimpleLayoutUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridLayout
implements AdvancedLayout<Control, Composite, SwtMetawidget> {
    private static final int LABEL_AND_CONTROL = 2;
    private static final String LABEL_NAME_SUFFIX = "_label";
    private final int mNumberOfColumns;
    private final int mLabelAlignment;
    private final Font mLabelFont;
    private final Color mLabelForeground;
    private final String mLabelSuffix;
    private final int mRequiredAlignment;
    private final String mRequiredText;

    public GridLayout() {
        this(new GridLayoutConfig());
    }

    public GridLayout(GridLayoutConfig gridLayoutConfig) {
        this.mNumberOfColumns = gridLayoutConfig.getNumberOfColumns();
        this.mLabelAlignment = gridLayoutConfig.getLabelAlignment();
        this.mLabelForeground = gridLayoutConfig.getLabelForeground();
        this.mLabelFont = gridLayoutConfig.getLabelFont();
        this.mLabelSuffix = gridLayoutConfig.getLabelSuffix();
        this.mRequiredAlignment = gridLayoutConfig.getRequiredAlignment();
        this.mRequiredText = gridLayoutConfig.getRequiredText();
    }

    @Override
    public void onStartBuild(SwtMetawidget swtMetawidget) {
    }

    @Override
    public void startContainerLayout(Composite composite, SwtMetawidget swtMetawidget) {
        org.eclipse.swt.layout.GridLayout gridLayout = new org.eclipse.swt.layout.GridLayout(this.mNumberOfColumns * 2, false);
        composite.setLayout((Layout)gridLayout);
    }

    @Override
    public void layoutWidget(Control control, String string, Map<String, String> map, Composite composite, SwtMetawidget swtMetawidget) {
        int n;
        int n2;
        if (control instanceof Stub && ((Stub)control).getChildren().length == 0) {
            GridData gridData = new GridData();
            gridData.exclude = true;
            control.setLayoutData((Object)gridData);
            return;
        }
        boolean bl = this.willFillHorizontally(control, map);
        if (bl && (n2 = (n = composite.getChildren().length) % (this.mNumberOfColumns * 2)) != 0 && n > 1) {
            Control control2 = composite.getChildren()[n - 2];
            ((GridData)control2.getLayoutData()).horizontalSpan = n2;
        }
        String string2 = null;
        if (map != null) {
            string2 = swtMetawidget.getLabelString(map);
        }
        this.layoutBeforeChild(control, string2, string, map, composite, swtMetawidget);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        if (!(control instanceof Button)) {
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
        }
        if (bl) {
            gridData.horizontalSpan = this.mNumberOfColumns * 2;
            if (SimpleLayoutUtils.needsLabel(string2, string)) {
                --gridData.horizontalSpan;
            }
        } else if (!SimpleLayoutUtils.needsLabel(string2, string)) {
            gridData.horizontalSpan = 2;
        }
        if (this.willFillVertically(control, map)) {
            gridData.grabExcessVerticalSpace = true;
        }
        control.setLayoutData((Object)gridData);
    }

    @Override
    public void endContainerLayout(Composite composite, SwtMetawidget swtMetawidget) {
    }

    @Override
    public void onEndBuild(SwtMetawidget swtMetawidget) {
        Facet facet = swtMetawidget.getFacet("buttons");
        if (facet != null) {
            GridData gridData = new GridData();
            gridData.horizontalSpan = 2;
            gridData.horizontalAlignment = 4;
            gridData.grabExcessHorizontalSpace = true;
            facet.setLayoutData(gridData);
            facet.moveBelow(null);
        }
    }

    protected String layoutBeforeChild(Control control, String string, String string2, Map<String, String> map, Composite composite, SwtMetawidget swtMetawidget) {
        if (SimpleLayoutUtils.needsLabel(string, string2)) {
            Label label = new Label(composite, 0);
            label.setData("name", (Object)(map.get("name") + LABEL_NAME_SUFFIX));
            if (this.mLabelFont != null) {
                label.setFont(this.mLabelFont);
            }
            if (this.mLabelForeground != null) {
                label.setForeground(this.mLabelForeground);
            }
            label.setAlignment(this.mLabelAlignment);
            String string3 = string;
            if (this.mRequiredText != null && "true".equals(map.get("required")) && !"true".equals(map.get("read-only")) && !swtMetawidget.isReadOnly()) {
                if (this.mRequiredAlignment == 0x1000000) {
                    string3 = string3 + this.mRequiredText;
                } else if (this.mRequiredAlignment == 16384) {
                    string3 = this.mRequiredText + string3;
                }
            }
            if (this.mLabelSuffix != null) {
                string3 = string3 + this.mLabelSuffix;
            }
            label.setText(string3);
            GridData gridData = new GridData();
            gridData.horizontalAlignment = 4;
            gridData.verticalAlignment = 4;
            label.setLayoutData((Object)gridData);
            label.moveAbove(control);
        }
        return string;
    }

    protected boolean willFillHorizontally(Control control, Map<String, String> map) {
        if (control instanceof SwtMetawidget) {
            return true;
        }
        return SimpleLayoutUtils.isSpanAllColumns(map);
    }

    protected boolean willFillVertically(Control control, Map<String, String> map) {
        return map != null && "true".equals(map.get("large"));
    }
}

