/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.lang.reflect.Array;
import java.util.List;
import java.util.regex.Pattern;
import org.metawidget.util.CollectionUtils;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArrayUtils {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];

    public static <T> String toString(T[] TArray) {
        return ArrayUtils.toString(TArray, StringUtils.SEPARATOR_COMMA);
    }

    public static <T> String toString(T[] TArray, String string) {
        return ArrayUtils.toString(TArray, string, false, false);
    }

    public static <T> String toString(T[] TArray, String string, boolean bl, boolean bl2) {
        if (TArray == null) {
            return "";
        }
        String string2 = string;
        if (string2.equals(".")) {
            string2 = "\\.";
        }
        Pattern pattern = Pattern.compile(string2, 16);
        String string3 = new StringBuffer().append("\\\\").append(string).toString();
        StringBuffer stringBuffer = new StringBuffer();
        for (T t : TArray) {
            String string4 = String.valueOf(t);
            if (stringBuffer.length() > 0 || bl) {
                stringBuffer.append(string);
            }
            string4 = pattern.matcher(string4).replaceAll(string3);
            stringBuffer.append(string4);
        }
        if (bl2 && stringBuffer.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static String[] fromString(String string) {
        return ArrayUtils.fromString(string, ',');
    }

    public static String[] fromString(String string, char c) {
        if (string == null) {
            return EMPTY_STRING_ARRAY;
        }
        List<String> list = CollectionUtils.fromString(string, c);
        return list.toArray(new String[list.size()]);
    }

    public static <T> T[] add(T[] TArray, T t) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length + 1);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        objectArray[TArray.length] = t;
        return objectArray;
    }

    public static <T> T[] add(T[] TArray, T[] TArray2) {
        if (TArray == null) {
            return TArray2;
        }
        if (TArray2 == null) {
            return TArray;
        }
        int n = TArray2.length;
        if (n == 0) {
            return TArray;
        }
        int n2 = TArray.length;
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), n2 + n);
        System.arraycopy(TArray, 0, objectArray, 0, TArray.length);
        System.arraycopy(TArray2, 0, objectArray, n2, n);
        return objectArray;
    }

    public static <T> boolean contains(T[] TArray, T t) {
        return ArrayUtils.indexOf(TArray, t) != -1;
    }

    public static <T> int indexOf(T[] TArray, T t) {
        if (TArray == null) {
            return -1;
        }
        for (int i = 0; i < TArray.length; ++i) {
            T t2 = TArray[i];
            if (!(t2 == null ? t == null : t2.equals(t))) continue;
            return i;
        }
        return -1;
    }

    public static <T> T[] removeAt(T[] TArray, int n) {
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), TArray.length - 1);
        if (n > 0) {
            System.arraycopy(TArray, 0, objectArray, 0, n);
        }
        if (n < TArray.length - 1) {
            System.arraycopy(TArray, n + 1, objectArray, n, TArray.length - (n + 1));
        }
        return objectArray;
    }

    private ArrayUtils() {
    }
}

