/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.metawidget.util.simple.StringUtils;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CollectionUtils {
    public static final <T> ArrayList<T> newArrayList() {
        return new ArrayList();
    }

    public static final <T> ArrayList<T> newArrayList(Collection<T> collection) {
        return new ArrayList<T>(collection);
    }

    public static final <T> ArrayList<T> newArrayList(int n) {
        return new ArrayList(n);
    }

    public static final <T> ArrayList<T> newArrayList(T[] TArray) {
        if (TArray == null) {
            return new ArrayList();
        }
        return new ArrayList<T>(Arrays.asList(TArray));
    }

    public static final <K> HashSet<K> newHashSet() {
        return new HashSet();
    }

    public static final <K> HashSet<K> newHashSet(Collection<K> collection) {
        return new HashSet<K>(collection);
    }

    public static final <K> HashSet<K> newHashSet(K[] KArray) {
        return new HashSet<K>(Arrays.asList(KArray));
    }

    public static final <K> Stack<K> newStack() {
        return new Stack();
    }

    public static final <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static final <K, V> HashMap<K, V> newHashMap(Map<K, V> map) {
        return new HashMap<K, V>(map);
    }

    public static final <K, V> HashMap<K, V> newHashMap(int n) {
        return new HashMap(n);
    }

    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static final <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<K, V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    public static final <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <T> List<T> unmodifiableList(T[] TArray) {
        return Collections.unmodifiableList(Arrays.asList(TArray));
    }

    public static <T extends Comparable> List<T> sort(Collection<T> collection) {
        return CollectionUtils.sort(collection, null);
    }

    public static <T extends Comparable> List<T> sort(Collection<T> collection, Comparator<T> comparator) {
        ArrayList<T> arrayList;
        if (collection == null) {
            return null;
        }
        if (collection instanceof List) {
            arrayList = (ArrayList<T>)collection;
        } else {
            if (collection.isEmpty()) {
                List list = Collections.EMPTY_LIST;
                return list;
            }
            arrayList = CollectionUtils.newArrayList(collection);
        }
        Collections.sort(arrayList, comparator);
        return arrayList;
    }

    public static <T> String toString(Collection<T> collection) {
        return CollectionUtils.toString(collection, StringUtils.SEPARATOR_COMMA);
    }

    public static <T> String toString(Collection<T> collection, String string) {
        return CollectionUtils.toString(collection, string, false, false);
    }

    public static <T> String toString(Collection<T> collection, String string, boolean bl, boolean bl2) {
        Object object;
        Object object2;
        if (collection == null) {
            return "";
        }
        Collection<T> collection2 = collection;
        if (collection2 instanceof Set && !collection2.isEmpty() && collection2.iterator().next() instanceof Comparable) {
            object2 = collection2;
            collection2 = object = CollectionUtils.sort(object2);
        }
        object2 = Pattern.compile(string, 16);
        object = new StringBuffer().append("\\\\").append(string).toString();
        StringBuffer stringBuffer = new StringBuffer();
        for (Object e : collection2) {
            String string2 = String.valueOf(e);
            if (stringBuffer.length() > 0 || bl) {
                stringBuffer.append(string);
            }
            string2 = ((Pattern)object2).matcher(string2).replaceAll((String)object);
            stringBuffer.append(string2);
        }
        if (bl2 && stringBuffer.length() > 0) {
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    public static List<String> fromString(String string) {
        return CollectionUtils.fromString(string, ',');
    }

    public static List<String> fromString(String string, char c) {
        if (string == null || string.length() == 0) {
            List list = Collections.EMPTY_LIST;
            return list;
        }
        ArrayList<String> arrayList = CollectionUtils.newArrayList();
        Pattern pattern = Pattern.compile(new StringBuffer().append("((\\\\").append(c).append("|[^").append(c).append("])*)(").append(c).append("|$)").toString());
        Pattern pattern2 = Pattern.compile(new StringBuffer().append("\\").append(c).toString(), 16);
        String string2 = String.valueOf(c);
        Matcher matcher = pattern.matcher(string);
        while (matcher.find()) {
            String string3 = matcher.group(1).trim();
            string3 = pattern2.matcher(string3).replaceAll(string2);
            arrayList.add(string3);
            if (matcher.end(1) != string.length()) continue;
            break;
        }
        return arrayList;
    }

    private CollectionUtils() {
    }
}

