/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.util;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LogUtils {
    static String LAST_TRACE_MESSAGE;
    static String LAST_DEBUG_MESSAGE;
    static String LAST_INFO_MESSAGE;
    static String LAST_WARN_MESSAGE;

    public static Log getLog(Class<?> clazz) {
        try {
            return new CommonsLog(clazz);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            return new UtilLog(clazz.getName());
        }
    }

    private LogUtils() {
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CommonsLog
    implements Log {
        private org.apache.commons.logging.Log mLog;

        public CommonsLog(Class<?> clazz) {
            this.mLog = LogFactory.getLog(clazz);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.mLog.isTraceEnabled();
        }

        @Override
        public void trace(String string) {
            LAST_TRACE_MESSAGE = string;
            this.mLog.trace((Object)string);
        }

        @Override
        public void trace(String string, Throwable throwable) {
            this.mLog.trace((Object)string, throwable);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.mLog.isDebugEnabled();
        }

        @Override
        public void debug(String string) {
            LAST_DEBUG_MESSAGE = string;
            this.mLog.debug((Object)string);
        }

        @Override
        public void debug(String string, Throwable throwable) {
            LAST_DEBUG_MESSAGE = string;
            this.mLog.debug((Object)string, throwable);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.mLog.isInfoEnabled();
        }

        @Override
        public void info(String string) {
            LAST_INFO_MESSAGE = string;
            this.mLog.info((Object)string);
        }

        @Override
        public void info(String string, Throwable throwable) {
            LAST_INFO_MESSAGE = string;
            this.mLog.info((Object)string, throwable);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.mLog.isWarnEnabled();
        }

        @Override
        public void warn(String string) {
            LAST_WARN_MESSAGE = string;
            this.mLog.warn((Object)string);
        }

        @Override
        public void warn(String string, Throwable throwable) {
            LAST_WARN_MESSAGE = string;
            this.mLog.warn((Object)string, throwable);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.mLog.isErrorEnabled();
        }

        @Override
        public void error(String string) {
            this.mLog.error((Object)string);
        }

        @Override
        public void error(String string, Throwable throwable) {
            this.mLog.error((Object)string, throwable);
        }
    }

    private static class UtilLog
    implements Log {
        private Logger mLogger;

        public UtilLog(String string) {
            this.mLogger = Logger.getLogger(string);
        }

        public boolean isTraceEnabled() {
            return this.mLogger.isLoggable(Level.FINER);
        }

        public void trace(String string) {
            LAST_TRACE_MESSAGE = string;
            this.mLogger.finer(string);
        }

        public void trace(String string, Throwable throwable) {
            this.mLogger.log(Level.FINER, string, throwable);
        }

        public boolean isDebugEnabled() {
            return this.mLogger.isLoggable(Level.FINE);
        }

        public void debug(String string) {
            LAST_DEBUG_MESSAGE = string;
            this.mLogger.fine(string);
        }

        public void debug(String string, Throwable throwable) {
            this.mLogger.log(Level.FINE, string, throwable);
        }

        public boolean isInfoEnabled() {
            return this.mLogger.isLoggable(Level.INFO);
        }

        public void info(String string) {
            LAST_INFO_MESSAGE = string;
            this.mLogger.info(string);
        }

        public void info(String string, Throwable throwable) {
            this.mLogger.log(Level.INFO, string, throwable);
        }

        public boolean isWarnEnabled() {
            return this.mLogger.isLoggable(Level.WARNING);
        }

        public void warn(String string) {
            LAST_WARN_MESSAGE = string;
            this.mLogger.warning(string);
        }

        public void warn(String string, Throwable throwable) {
            LAST_WARN_MESSAGE = string;
            this.mLogger.log(Level.WARNING, string, throwable);
        }

        public boolean isErrorEnabled() {
            return this.mLogger.isLoggable(Level.SEVERE);
        }

        public void error(String string) {
            this.mLogger.log(Level.SEVERE, string);
        }

        public void error(String string, Throwable throwable) {
            this.mLogger.log(Level.SEVERE, string, throwable);
        }
    }

    public static interface Log {
        public boolean isTraceEnabled();

        public void trace(String var1);

        public void trace(String var1, Throwable var2);

        public boolean isDebugEnabled();

        public void debug(String var1);

        public void debug(String var1, Throwable var2);

        public boolean isInfoEnabled();

        public void info(String var1);

        public void info(String var1, Throwable var2);

        public boolean isWarnEnabled();

        public void warn(String var1);

        public void warn(String var1, Throwable var2);

        public boolean isErrorEnabled();

        public void error(String var1);

        public void error(String var1, Throwable var2);
    }
}

