/*
 * Decompiled with CFR 0.152.
 */
package org.metawidget.inspector.impl;

import java.util.regex.Pattern;
import org.metawidget.util.simple.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BaseTraitStyleConfig {
    private static Pattern DEFAULT_EXCLUDE_BASE_TYPE;
    private boolean mCacheLookups = true;
    private Pattern mExcludeBaseType;
    private boolean mNullExcludeBaseType;
    private Class<?>[] mExcludeReturnType;
    private String[] mExcludeName;

    public BaseTraitStyleConfig setCacheLookups(boolean cacheLookups) {
        this.mCacheLookups = cacheLookups;
        return this;
    }

    public BaseTraitStyleConfig setExcludeBaseType(Pattern excludeBaseType) {
        this.mExcludeBaseType = excludeBaseType;
        this.mNullExcludeBaseType = excludeBaseType == null;
        return this;
    }

    public BaseTraitStyleConfig setExcludeReturnType(Class<?> ... excludeReturnType) {
        this.mExcludeReturnType = excludeReturnType;
        return this;
    }

    public BaseTraitStyleConfig setExcludeName(String ... excludeName) {
        this.mExcludeName = excludeName;
        return this;
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (!ObjectUtils.nullSafeClassEquals(this, that)) {
            return false;
        }
        if (this.mCacheLookups != ((BaseTraitStyleConfig)that).mCacheLookups) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mExcludeBaseType, ((BaseTraitStyleConfig)that).mExcludeBaseType)) {
            return false;
        }
        if (this.mNullExcludeBaseType != ((BaseTraitStyleConfig)that).mNullExcludeBaseType) {
            return false;
        }
        if (!ObjectUtils.nullSafeEquals(this.mExcludeReturnType, ((BaseTraitStyleConfig)that).mExcludeReturnType)) {
            return false;
        }
        return ObjectUtils.nullSafeEquals(this.mExcludeName, ((BaseTraitStyleConfig)that).mExcludeName);
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mCacheLookups);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mExcludeBaseType);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mNullExcludeBaseType);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mExcludeReturnType);
        hashCode = 31 * hashCode + ObjectUtils.nullSafeHashCode(this.mExcludeName);
        return hashCode;
    }

    protected boolean isCacheLookups() {
        return this.mCacheLookups;
    }

    protected Pattern getExcludeBaseType() {
        if (this.mExcludeBaseType == null && !this.mNullExcludeBaseType) {
            if (DEFAULT_EXCLUDE_BASE_TYPE == null) {
                DEFAULT_EXCLUDE_BASE_TYPE = Pattern.compile("^(java|javax)\\..*$");
            }
            return DEFAULT_EXCLUDE_BASE_TYPE;
        }
        return this.mExcludeBaseType;
    }

    protected Class<?>[] getExcludeReturnType() {
        return this.mExcludeReturnType;
    }

    protected String[] getExcludeName() {
        return this.mExcludeName;
    }
}

