/*
 * Decompiled with CFR 0.152.
 */
package org.milyn.delivery;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.milyn.cdr.ParameterAccessor;
import org.milyn.cdr.SmooksResourceConfiguration;
import org.milyn.container.ApplicationContext;
import org.milyn.container.ExecutionContext;
import org.milyn.delivery.ContentDeliveryConfig;
import org.milyn.delivery.ContentHandlerConfigMap;
import org.milyn.delivery.ContentHandlerConfigMapTable;
import org.milyn.delivery.ExecutionLifecycleCleanable;
import org.milyn.delivery.ExecutionLifecycleInitializable;
import org.milyn.delivery.FilterBypass;
import org.milyn.delivery.Visitor;
import org.milyn.dtd.DTDStore;
import org.milyn.event.types.ConfigBuilderEvent;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractContentDeliveryConfig
implements ContentDeliveryConfig {
    private static Log logger = LogFactory.getLog(AbstractContentDeliveryConfig.class);
    private ApplicationContext applicationContext;
    private Map<String, List<SmooksResourceConfiguration>> resourceConfigTable = new LinkedHashMap<String, List<SmooksResourceConfiguration>>();
    private Map objectsTable = new LinkedHashMap();
    private DTDStore.DTDObjectContainer dtd;
    private List<ConfigBuilderEvent> configBuilderEvents = new ArrayList<ConfigBuilderEvent>();
    private Set<ExecutionLifecycleInitializable> execInitializableHandlers = new LinkedHashSet<ExecutionLifecycleInitializable>();
    private Set<ExecutionLifecycleCleanable> execCleanableHandlers = new LinkedHashSet<ExecutionLifecycleCleanable>();
    private Boolean isDefaultSerializationOn = null;
    private List<XMLReader> readerPool = new CopyOnWriteArrayList<XMLReader>();
    private int readerPoolSize;
    private static final Vector EMPTY_LIST = new Vector();

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }

    public List getSmooksResourceConfigurations(String selector) {
        return this.resourceConfigTable.get(selector);
    }

    public void setSmooksResourceConfigurations(Map<String, List<SmooksResourceConfiguration>> resourceConfigTable) {
        this.resourceConfigTable = resourceConfigTable;
    }

    @Override
    public Map<String, List<SmooksResourceConfiguration>> getSmooksResourceConfigurations() {
        return this.resourceConfigTable;
    }

    @Override
    public List getObjects(String selector) {
        Vector<Object> objects = (Vector<Object>)this.objectsTable.get(selector);
        if (objects == null) {
            List<SmooksResourceConfiguration> unitDefs = this.resourceConfigTable.get(selector);
            if (unitDefs != null && unitDefs.size() > 0) {
                objects = new Vector<Object>(unitDefs.size());
                if (this.applicationContext == null) {
                    throw new IllegalStateException("Call to getObjects() before the setApplicationContext() was called.");
                }
                for (int i = 0; i < unitDefs.size(); ++i) {
                    SmooksResourceConfiguration resConfig = unitDefs.get(i);
                    objects.add(this.applicationContext.getStore().getObject(resConfig));
                }
            } else {
                objects = EMPTY_LIST;
            }
            this.objectsTable.put(selector, objects);
        }
        return objects;
    }

    @Override
    public DTDStore.DTDObjectContainer getDTD() {
        return this.dtd;
    }

    public void setDtd(DTDStore.DTDObjectContainer dtd) {
        this.dtd = dtd;
    }

    @Override
    public List<ConfigBuilderEvent> getConfigBuilderEvents() {
        return this.configBuilderEvents;
    }

    @Override
    public boolean isDefaultSerializationOn() {
        if (this.isDefaultSerializationOn == null) {
            this.isDefaultSerializationOn = ParameterAccessor.getBoolParameter("default.serialization.on", true, this);
        }
        return this.isDefaultSerializationOn;
    }

    public <T extends Visitor> void addToExecutionLifecycleSets(ContentHandlerConfigMapTable<T> handlerSet) {
        Collection<List<ContentHandlerConfigMap<T>>> mapEntries = handlerSet.getTable().values();
        for (List<ContentHandlerConfigMap<T>> mapList : mapEntries) {
            for (ContentHandlerConfigMap<T> map : mapList) {
                if (map.isLifecycleInitializable()) {
                    this.execInitializableHandlers.add((ExecutionLifecycleInitializable)map.getContentHandler());
                }
                if (!map.isLifecycleCleanable()) continue;
                this.execCleanableHandlers.add((ExecutionLifecycleCleanable)map.getContentHandler());
            }
        }
    }

    @Override
    public void executeHandlerInit(ExecutionContext executionContext) {
        for (ExecutionLifecycleInitializable handler : this.execInitializableHandlers) {
            handler.executeExecutionLifecycleInitialize(executionContext);
        }
    }

    @Override
    public void executeHandlerCleanup(ExecutionContext executionContext) {
        for (ExecutionLifecycleCleanable handler : this.execCleanableHandlers) {
            try {
                handler.executeExecutionLifecycleCleanup(executionContext);
            }
            catch (Throwable t) {
                logger.error((Object)"Error during Visit handler cleanup.", t);
            }
        }
    }

    public void initializeXMLReaderPool() {
        try {
            this.readerPoolSize = Integer.parseInt(ParameterAccessor.getStringParameter("reader.pool.size", "0", this).trim());
        }
        catch (NumberFormatException e) {
            this.readerPoolSize = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public XMLReader getXMLReader() throws SAXException {
        List<XMLReader> list = this.readerPool;
        synchronized (list) {
            if (!this.readerPool.isEmpty()) {
                return this.readerPool.remove(0);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void returnXMLReader(XMLReader reader) {
        List<XMLReader> list = this.readerPool;
        synchronized (list) {
            if (this.readerPool.size() < this.readerPoolSize) {
                this.readerPool.add(reader);
            }
        }
    }

    protected FilterBypass getFilterBypass(ContentHandlerConfigMapTable ... visitorTables) {
        for (ContentHandlerConfigMapTable visitorTable : visitorTables) {
            if (visitorTable == null || visitorTable.getUserConfiguredCount() <= 1) continue;
            return null;
        }
        HashSet<FilterBypass> bypassSet = new HashSet<FilterBypass>();
        for (ContentHandlerConfigMapTable visitorTable : visitorTables) {
            if (visitorTable == null || visitorTable.getUserConfiguredCount() != 1) continue;
            FilterBypass filterBypass = this.getFilterBypass(visitorTable);
            if (filterBypass != null) {
                bypassSet.add(filterBypass);
                continue;
            }
            return null;
        }
        if (bypassSet.size() == 1) {
            return (FilterBypass)bypassSet.iterator().next();
        }
        return null;
    }

    private <T extends Visitor> FilterBypass getFilterBypass(ContentHandlerConfigMapTable<T> visitorTable) {
        Set<Map.Entry<String, List<ContentHandlerConfigMap<T>>>> entries = visitorTable.getTable().entrySet();
        for (Map.Entry<String, List<ContentHandlerConfigMap<T>>> entry : entries) {
            Visitor visitor;
            ContentHandlerConfigMap<T> configMap = entry.getValue().get(0);
            SmooksResourceConfiguration resourceConfig = configMap.getResourceConfig();
            if (resourceConfig.isDefaultResource()) continue;
            if (resourceConfig.getTargetElement().equals("#document") && (visitor = (Visitor)configMap.getContentHandler()) instanceof FilterBypass) {
                return (FilterBypass)((Object)visitor);
            }
            return null;
        }
        return null;
    }
}

