/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import com.google.common.net.MediaType;
import javax.xml.bind.DatatypeConverter;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.model.BinaryBody;

public class BinaryBodyDTO
extends BodyDTO {
    private String value;

    public BinaryBodyDTO(BinaryBody binaryBody) {
        this(binaryBody, false);
    }

    public BinaryBodyDTO(BinaryBody binaryBody, Boolean not) {
        super(binaryBody.getType(), not, binaryBody.getContentType());
        if (binaryBody.getValue() != null && binaryBody.getValue().length > 0) {
            this.value = DatatypeConverter.printBase64Binary((byte[])binaryBody.getValue());
        }
    }

    protected BinaryBodyDTO() {
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public BinaryBody buildObject() {
        return new BinaryBody(DatatypeConverter.parseBase64Binary((String)this.value), this.contentType != null ? MediaType.parse((String)this.contentType) : null);
    }
}

