/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.client.serialization.model;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.mockserver.client.serialization.model.BodyDTO;
import org.mockserver.client.serialization.model.CookieDTO;
import org.mockserver.client.serialization.model.HeaderDTO;
import org.mockserver.client.serialization.model.NotDTO;
import org.mockserver.client.serialization.model.ParameterDTO;
import org.mockserver.model.Cookie;
import org.mockserver.model.Header;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.Not;
import org.mockserver.model.NottableString;
import org.mockserver.model.Parameter;

public class HttpRequestDTO
extends NotDTO {
    private NottableString method = NottableString.string("");
    private NottableString path = NottableString.string("");
    private List<ParameterDTO> queryStringParameters = new ArrayList<ParameterDTO>();
    private BodyDTO body;
    private List<CookieDTO> cookies = new ArrayList<CookieDTO>();
    private List<HeaderDTO> headers = new ArrayList<HeaderDTO>();
    private Boolean keepAlive = null;
    private Boolean secure = null;

    public HttpRequestDTO(HttpRequest httpRequest) {
        this(httpRequest, false);
    }

    public HttpRequestDTO(HttpRequest httpRequest, Boolean not) {
        super(not);
        if (httpRequest != null) {
            this.method = httpRequest.getMethod();
            this.path = httpRequest.getPath();
            this.headers = Lists.transform(httpRequest.getHeaders(), (Function)new Function<Header, HeaderDTO>(){

                public HeaderDTO apply(Header header) {
                    return new HeaderDTO(header);
                }
            });
            this.cookies = Lists.transform(httpRequest.getCookies(), (Function)new Function<Cookie, CookieDTO>(){

                public CookieDTO apply(Cookie cookie) {
                    return new CookieDTO(cookie);
                }
            });
            this.queryStringParameters = Lists.transform(httpRequest.getQueryStringParameters(), (Function)new Function<Parameter, ParameterDTO>(){

                public ParameterDTO apply(Parameter parameter) {
                    return new ParameterDTO(parameter);
                }
            });
            this.body = BodyDTO.createDTO(httpRequest.getBody());
            this.keepAlive = httpRequest.isKeepAlive();
            this.secure = httpRequest.isSecure();
        }
    }

    public HttpRequestDTO() {
    }

    public HttpRequest buildObject() {
        return new HttpRequest().withMethod(this.method).withPath(this.path).withHeaders(Lists.transform(this.headers, (Function)new Function<HeaderDTO, Header>(){

            public Header apply(HeaderDTO header) {
                return header.buildObject();
            }
        })).withCookies(Lists.transform(this.cookies, (Function)new Function<CookieDTO, Cookie>(){

            public Cookie apply(CookieDTO cookie) {
                return cookie.buildObject();
            }
        })).withQueryStringParameters(Lists.transform(this.queryStringParameters, (Function)new Function<ParameterDTO, Parameter>(){

            public Parameter apply(ParameterDTO parameter) {
                return parameter.buildObject();
            }
        })).withBody(this.body != null ? Not.not(this.body.buildObject(), this.body.getNot()) : null).withSecure(this.secure).withKeepAlive(this.keepAlive);
    }

    public NottableString getMethod() {
        return this.method;
    }

    public HttpRequestDTO setMethod(NottableString method) {
        this.method = method;
        return this;
    }

    public NottableString getPath() {
        return this.path;
    }

    public HttpRequestDTO setPath(NottableString path) {
        this.path = path;
        return this;
    }

    public List<ParameterDTO> getQueryStringParameters() {
        return this.queryStringParameters;
    }

    public HttpRequestDTO setQueryStringParameters(List<ParameterDTO> queryStringParameters) {
        this.queryStringParameters = queryStringParameters;
        return this;
    }

    public BodyDTO getBody() {
        return this.body;
    }

    public HttpRequestDTO setBody(BodyDTO body) {
        this.body = body;
        return this;
    }

    public List<HeaderDTO> getHeaders() {
        return this.headers;
    }

    public HttpRequestDTO setHeaders(List<HeaderDTO> headers) {
        this.headers = headers;
        return this;
    }

    public List<CookieDTO> getCookies() {
        return this.cookies;
    }

    public HttpRequestDTO setCookies(List<CookieDTO> cookies) {
        this.cookies = cookies;
        return this;
    }

    public Boolean getKeepAlive() {
        return this.keepAlive;
    }

    public HttpRequestDTO setKeepAlive(Boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public Boolean getSecure() {
        return this.secure;
    }

    public HttpRequestDTO setSecure(Boolean secure) {
        this.secure = secure;
        return this;
    }
}

