/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.echo.http;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import org.mockserver.echo.http.EchoServer;
import org.mockserver.filters.RequestLogFilter;
import org.mockserver.logging.LogFormatter;
import org.mockserver.model.HttpRequest;
import org.mockserver.model.HttpResponse;
import org.mockserver.server.netty.codec.MockServerResponseEncoder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class EchoServerHandler
extends SimpleChannelInboundHandler<HttpRequest> {
    private final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final EchoServer.Error error;
    private final boolean isSecure;
    private final RequestLogFilter requestLogFilter;
    private final EchoServer.NextResponse nextResponse;
    private LogFormatter logFormatter = new LogFormatter(this.logger);

    public EchoServerHandler(EchoServer.Error error, boolean isSecure, RequestLogFilter requestLogFilter, EchoServer.NextResponse nextResponse) {
        this.error = error;
        this.isSecure = isSecure;
        this.requestLogFilter = requestLogFilter;
        this.nextResponse = nextResponse;
    }

    protected void channelRead0(ChannelHandlerContext ctx, HttpRequest request) {
        this.logFormatter.traceLog("received request:{}" + System.getProperty("line.separator"), request);
        this.requestLogFilter.onRequest(request);
        if (!this.nextResponse.httpResponse.isEmpty()) {
            DefaultFullHttpResponse httpResponse = new MockServerResponseEncoder().encode(this.nextResponse.httpResponse.remove());
            ctx.writeAndFlush((Object)httpResponse);
        } else {
            int length;
            HttpResponse httpResponse = HttpResponse.response().withStatusCode(request.getPath().equalsIgnoreCase("/not_found") ? HttpResponseStatus.NOT_FOUND.code() : HttpResponseStatus.OK.code()).withBody(request.getBody()).withHeaders(request.getHeaders());
            int n = length = httpResponse.getBodyAsString() != null ? httpResponse.getBodyAsString().length() : 0;
            if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH) {
                httpResponse.updateHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length * 2));
            } else if (this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
                httpResponse.updateHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length / 2));
            } else {
                httpResponse.updateHeader(HttpHeaderNames.CONTENT_LENGTH.toString(), String.valueOf(length));
            }
            ctx.writeAndFlush((Object)httpResponse);
            if (this.error == EchoServer.Error.LARGER_CONTENT_LENGTH || this.error == EchoServer.Error.SMALLER_CONTENT_LENGTH) {
                ctx.close();
            }
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

