/*
 * Decompiled with CFR 0.152.
 */
package org.mockserver.collections;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.mockserver.collections.ImmutableEntry;
import org.mockserver.matchers.RegexStringMatcher;
import org.mockserver.model.NottableString;

public class SubSetMatcher {
    static boolean containsSubset(RegexStringMatcher regexStringMatcher, List<ImmutableEntry> subset, List<ImmutableEntry> superset) {
        boolean result = true;
        HashSet<Integer> matchingIndexes = new HashSet<Integer>();
        for (ImmutableEntry subsetItem : subset) {
            boolean optionalAndNotPresent;
            Set<Integer> subsetItemMatchingIndexes = SubSetMatcher.matchesIndexes(regexStringMatcher, superset, subsetItem);
            boolean bl = optionalAndNotPresent = subsetItem.isOptional() && !SubSetMatcher.containsKey(regexStringMatcher, superset, subsetItem);
            if (!optionalAndNotPresent && subsetItemMatchingIndexes.isEmpty()) {
                result = false;
                break;
            }
            matchingIndexes.addAll(subsetItemMatchingIndexes);
        }
        if (result) {
            long subsetNonOptionalSize = subset.stream().filter(ImmutableEntry::isNotOptional).count();
            result = (long)matchingIndexes.size() >= subsetNonOptionalSize;
        }
        return result;
    }

    private static Set<Integer> matchesIndexes(RegexStringMatcher regexStringMatcher, List<ImmutableEntry> matchedList, ImmutableEntry matcherItem) {
        HashSet<Integer> matchingIndexes = new HashSet<Integer>();
        for (int i = 0; i < matchedList.size(); ++i) {
            ImmutableEntry matchedItem = matchedList.get(i);
            boolean keyMatches = regexStringMatcher.matches((NottableString)matcherItem.getKey(), (NottableString)matchedItem.getKey(), true);
            boolean valueMatches = regexStringMatcher.matches((NottableString)matcherItem.getValue(), (NottableString)matchedItem.getValue(), true);
            if (!keyMatches || !valueMatches) continue;
            matchingIndexes.add(i);
        }
        return matchingIndexes;
    }

    private static boolean containsKey(RegexStringMatcher regexStringMatcher, List<ImmutableEntry> matchedList, ImmutableEntry matcherItem) {
        for (ImmutableEntry matchedItem : matchedList) {
            if (!regexStringMatcher.matches((NottableString)matcherItem.getKey(), (NottableString)matchedItem.getKey(), true)) continue;
            return true;
        }
        return false;
    }
}

